/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionM2, PCM2_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
	P(SMail, "Webmail Address", UNI_L("http://www.operamail.com/")),

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionM2, PCM2_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
	I(SMail, "Compose Header Display", 0x477, prefssetting::integer),
	I(SMail, "Default Mail Search Type", 0, prefssetting::integer),
	I(SMail, "Default Mail Sorting", 7, prefssetting::integer),
	I(SMail, "Default Mail Sorting Ascending", FALSE, prefssetting::boolean),
	I(SMail, "Fit To Width Messages", 1, prefssetting::integer),
	I(SMail, "Load Mail Databases Asynchronously", TRUE, prefssetting::boolean),
	I(SMail, "Mail Database Consistency Check Time", 0, prefssetting::integer),
	I(SMail, "Mail Default Flat Threaded View", 1, prefssetting::integer),
	I(SMail, "Mail Grouping Method", 2, prefssetting::integer),
	I(SMail, "Mail Message Width List On Top", 105, prefssetting::integer),
	I(SMail, "Mail View Two Lined Messages", 1, prefssetting::integer),
	I(SMail, "Message Width List On Left", 0, prefssetting::integer),
	I(SMail, "Padding in Compose Window", TRUE, prefssetting::boolean),
	I(SMail, "Show Default Mail Client Dialog", TRUE, prefssetting::boolean),
	I(SMail, "Split Up Thread When Subject Changed", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Auto Mail Panel Toggle", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Chat Room Splitter", 100, prefssetting::integer),
	I(SUserPrefs, "Default Mail Store Type", 2, prefssetting::integer),
	I(SUserPrefs, "Mail View Accountinfo Splitter", 0xd000, prefssetting::integer),
	I(SUserPrefs, "Mail View List Splitter", 0x8000, prefssetting::integer),
	I(SUserPrefs, "Mail View Mode", 1, prefssetting::integer),
	I(SUserPrefs, "Mark As Read Automatically", 0, prefssetting::integer),
	I(SUserPrefs, "Preferred Mail Body Mode", 1, prefssetting::integer),
	I(SUserPrefs, "Show Attachments Inline", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Show Delete Mail Dialog", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show E-mail Client", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Encoding Mismatch Dialog", 0, prefssetting::integer),
	I(SUserPrefs, "Show Mail Header Toolbar", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show quick reply", FALSE, prefssetting::boolean),

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionM2::stringpref e)
{
	switch (e) {
	case PrefsCollectionM2::WebmailAddress:
		return dbg << "PrefsCollectionM2::WebmailAddress";
	default:
		return dbg << "PrefsCollectionM2::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionM2::integerpref e)
{
	switch (e) {
	case PrefsCollectionM2::MailComposeHeaderDisplay:
		return dbg << "PrefsCollectionM2::MailComposeHeaderDisplay";
	case PrefsCollectionM2::DefaultMailSearch:
		return dbg << "PrefsCollectionM2::DefaultMailSearch";
	case PrefsCollectionM2::DefaultMailSorting:
		return dbg << "PrefsCollectionM2::DefaultMailSorting";
	case PrefsCollectionM2::DefaultMailSortingAscending:
		return dbg << "PrefsCollectionM2::DefaultMailSortingAscending";
	case PrefsCollectionM2::FitToWidth:
		return dbg << "PrefsCollectionM2::FitToWidth";
	case PrefsCollectionM2::LoadMailDatabasesAsynchronously:
		return dbg << "PrefsCollectionM2::LoadMailDatabasesAsynchronously";
	case PrefsCollectionM2::LastDatabaseCheck:
		return dbg << "PrefsCollectionM2::LastDatabaseCheck";
	case PrefsCollectionM2::DefaultMailFlatThreadedView:
		return dbg << "PrefsCollectionM2::DefaultMailFlatThreadedView";
	case PrefsCollectionM2::MailGroupingMethod:
		return dbg << "PrefsCollectionM2::MailGroupingMethod";
	case PrefsCollectionM2::MessageWidthListOnTop:
		return dbg << "PrefsCollectionM2::MessageWidthListOnTop";
	case PrefsCollectionM2::MailTwoLinedItems:
		return dbg << "PrefsCollectionM2::MailTwoLinedItems";
	case PrefsCollectionM2::MessageWidthListOnRight:
		return dbg << "PrefsCollectionM2::MessageWidthListOnRight";
	case PrefsCollectionM2::PaddingInComposeWindow:
		return dbg << "PrefsCollectionM2::PaddingInComposeWindow";
	case PrefsCollectionM2::ShowDefaultMailClientDialog:
		return dbg << "PrefsCollectionM2::ShowDefaultMailClientDialog";
	case PrefsCollectionM2::SplitUpThreadWhenSubjectChanged:
		return dbg << "PrefsCollectionM2::SplitUpThreadWhenSubjectChanged";
	case PrefsCollectionM2::AutoMailPanelToggle:
		return dbg << "PrefsCollectionM2::AutoMailPanelToggle";
	case PrefsCollectionM2::ChatRoomSplitter:
		return dbg << "PrefsCollectionM2::ChatRoomSplitter";
	case PrefsCollectionM2::DefaultMailStoreType:
		return dbg << "PrefsCollectionM2::DefaultMailStoreType";
	case PrefsCollectionM2::AccountInfoSplitter:
		return dbg << "PrefsCollectionM2::AccountInfoSplitter";
	case PrefsCollectionM2::MailViewListSplitter:
		return dbg << "PrefsCollectionM2::MailViewListSplitter";
	case PrefsCollectionM2::MailViewMode:
		return dbg << "PrefsCollectionM2::MailViewMode";
	case PrefsCollectionM2::MarkAsReadAutomatically:
		return dbg << "PrefsCollectionM2::MarkAsReadAutomatically";
	case PrefsCollectionM2::MailBodyMode:
		return dbg << "PrefsCollectionM2::MailBodyMode";
	case PrefsCollectionM2::ShowAttachmentsInline:
		return dbg << "PrefsCollectionM2::ShowAttachmentsInline";
	case PrefsCollectionM2::ShowDeleteMailDialog:
		return dbg << "PrefsCollectionM2::ShowDeleteMailDialog";
	case PrefsCollectionM2::ShowEmailClient:
		return dbg << "PrefsCollectionM2::ShowEmailClient";
	case PrefsCollectionM2::ShowEncodingMismatchDialog:
		return dbg << "PrefsCollectionM2::ShowEncodingMismatchDialog";
	case PrefsCollectionM2::ShowQuickHeaders:
		return dbg << "PrefsCollectionM2::ShowQuickHeaders";
	case PrefsCollectionM2::ShowQuickReply:
		return dbg << "PrefsCollectionM2::ShowQuickReply";
	default:
		return dbg << "PrefsCollectionM2::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
