/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2002-2012 Opera Software ASA.  All rights reserved.
 *
 * This file is part of the Opera web browser.
 * It may not be distributed under any circumstances.
 */

// ---------------------------------------------------------------------------------

#ifndef MODULES_UTIL_OPTYPEDOBJECT_H
#define MODULES_UTIL_OPTYPEDOBJECT_H

// ---------------------------------------------------------------------------------

class OpTypedObject
{
	public:

		enum Type
		{
			UNKNOWN_TYPE,
			INDEX_TYPE,
			MAIL_TYPE,
			CONTACT_TYPE,
			BOOKMARK_TYPE,
			NOTE_TYPE,
			GROUP_TYPE,
			FOLDER_TYPE,
			MUSIC_TYPE,
			GADGET_TYPE,
			UNITE_SERVICE_TYPE,
			SEPARATOR_TYPE,
			VISUALDEVICE_TYPE,
			WIDGET_TYPE,

			// Widget types must stay in same order.. used to look up their string.. see Application.cpp

			WIDGET_TYPE_BUTTON,
			WIDGET_TYPE_RADIOBUTTON,
			WIDGET_TYPE_CHECKBOX,
			WIDGET_TYPE_LISTBOX,
			WIDGET_TYPE_TREEVIEW,
			WIDGET_TYPE_DROPDOWN,
			WIDGET_TYPE_EDIT,
			WIDGET_TYPE_MULTILINE_EDIT,
			WIDGET_TYPE_LABEL,
			WIDGET_TYPE_IMAGE,
			WIDGET_TYPE_WEBIMAGE,
			WIDGET_TYPE_FILECHOOSER_EDIT,
			WIDGET_TYPE_FOLDERCHOOSER_EDIT,
			WIDGET_TYPE_TOOLBAR,
			WIDGET_TYPE_GROUP,
			WIDGET_TYPE_SPLITTER,
			WIDGET_TYPE_BROWSERVIEW,
			WIDGET_TYPE_PROGRESSBAR,
			WIDGET_TYPE_TABS,
			WIDGET_TYPE_PAGEBAR,
			WIDGET_TYPE_PERSONALBAR,
			WIDGET_TYPE_STATUS_FIELD,
			WIDGET_TYPE_PROGRESS_FIELD,
			WIDGET_TYPE_WORKSPACE,
			WIDGET_TYPE_ADDRESS_DROPDOWN,
			WIDGET_TYPE_SEARCH_DROPDOWN,
			WIDGET_TYPE_SEARCH_EDIT,
			WIDGET_TYPE_ZOOM_DROPDOWN,
			WIDGET_TYPE_ACCOUNT_DROPDOWN,
			WIDGET_TYPE_SCROLLBAR,
			WIDGET_TYPE_QUICK_FIND,
			WIDGET_TYPE_BOOKMARKS_VIEW,
			WIDGET_TYPE_CONTACTS_VIEW,
			WIDGET_TYPE_GADGETS_VIEW,
			WIDGET_TYPE_NOTES_VIEW,
			WIDGET_TYPE_MUSIC_VIEW,
			WIDGET_TYPE_LINKS_VIEW,
            WIDGET_TYPE_IDENTIFY_FIELD,
			WIDGET_TYPE_HOTLIST,
			WIDGET_TYPE_SPACER,
            WIDGET_TYPE_DOCUMENT_EDIT,
            WIDGET_TYPE_PANEL_SELECTOR,
			WIDGET_TYPE_MULTILINE_LABEL,
			WIDGET_TYPE_SEPARATOR,
			WIDGET_TYPE_ATTACHMENT_LIST,
			WIDGET_TYPE_THUMBNAIL,
			WIDGET_TYPE_ROOT,
			WIDGET_TYPE_SPEEDDIAL,
			WIDGET_TYPE_NUMBER_EDIT,
			WIDGET_TYPE_SLIDER,
			WIDGET_TYPE_CALENDAR,
			WIDGET_TYPE_DATETIME,

#ifdef PRODUCT_OPTYPEDOBJECT_WIDGET_FILE
#include PRODUCT_OPTYPEDOBJECT_WIDGET_FILE
#endif // PRODUCT_OPTYPEDOBJECT_WIDGET_FILE

			//Add new widget types here
			WIDGET_TYPE_COLOR_MATRIX,
			WIDGET_TYPE_COLOR_BOX,

			// Panels must follow here since they are also widgets

			PANEL_TYPE_WEB,			// generic web panel, special case

			// Panel types must stay in same order.. used to look up their string.. see Hotlist.cpp

			PANEL_TYPE_FIRST,
			PANEL_TYPE_BOOKMARKS = PANEL_TYPE_FIRST,
			PANEL_TYPE_MAIL,
			PANEL_TYPE_CONTACTS,
			PANEL_TYPE_HISTORY,
			PANEL_TYPE_TRANSFERS,
			PANEL_TYPE_LINKS,
			PANEL_TYPE_WINDOWS,
			PANEL_TYPE_CHAT,
			PANEL_TYPE_INFO,
			PANEL_TYPE_GADGETS,
			PANEL_TYPE_NOTES,
			PANEL_TYPE_MUSIC,
			PANEL_TYPE_START,
			PANEL_TYPE_SEARCH,

			//Add new panel types here

#ifdef PRODUCT_OPTYPEDOBJECT_PANEL_FILE
#include PRODUCT_OPTYPEDOBJECT_PANEL_FILE
#endif // PRODUCT_OPTYPEDOBJECT_PANEL_FILE

			PANEL_TYPE_LAST,		// must come last

			WIDGET_TYPE_LAST,		// this must be last of all widget types (this comes after the panels)

			WINDOW_TYPE_UNKNOWN,
			WINDOW_TYPE_DESKTOP,
			WINDOW_TYPE_DESKTOP_WITH_BROWSER_VIEW,
			WINDOW_TYPE_BROWSER,
			WINDOW_TYPE_MAIL_VIEW,
			WINDOW_TYPE_MAIL_COMPOSE,
			WINDOW_TYPE_HOTLIST,
			WINDOW_TYPE_DOCUMENT,
			WINDOW_TYPE_CHAT,
			WINDOW_TYPE_CHAT_ROOM,
			WINDOW_TYPE_HELP,
			WINDOW_TYPE_UI_BUILDER,
			WINDOW_TYPE_JAVASCRIPT_CONSOLE,
            WINDOW_TYPE_PAGE_CYCLER,
            WINDOW_TYPE_PANEL,
            WINDOW_TYPE_SOURCE,
            WINDOW_TYPE_GADGET,
            WINDOW_TYPE_ACCESSKEY_CYCLER,
            WINDOW_TYPE_DEVTOOLS,

			//Add new window types here

#ifdef PRODUCT_OPTYPEDOBJECT_WINDOW_FILE
#include PRODUCT_OPTYPEDOBJECT_WINDOW_FILE
#endif // PRODUCT_OPTYPEDOBJECT_WINDOW_FILE

			WINDOW_TYPE_LAST,	// must be last of window types.. so we can cast something unknown to DesktopWindow based on type

			DIALOG_TYPE,			// must be first of dialog types.. so we can cast something unknown to Dialog based on type
			DIALOG_TYPE_ACCOUNT_MANAGER,
			DIALOG_TYPE_ACCOUNT_PROPERTIES,
			DIALOG_TYPE_ACCOUNT_SUBSCRIPTION,
			DIALOG_TYPE_AUTHENTICATION,
			DIALOG_TYPE_PASSWORD,
			DIALOG_TYPE_CHANGE_NICK,
			DIALOG_TYPE_ROOM_PASSWORD,
			DIALOG_TYPE_JOIN_CHAT,
			DIALOG_TYPE_KICK_CHAT_USER,
			DIALOG_TYPE_EDIT_ROOM,
			DIALOG_TYPE_SEARCH_MAIL,
			DIALOG_TYPE_ERROR,
			DIALOG_TYPE_BOOKMARK_PROPERTIES,
			DIALOG_TYPE_CONTACT_PROPERTIES,
			DIALOG_TYPE_MAIL_INDEX_PROPERTIES,
			DIALOG_TYPE_STARTUP,
			DIALOG_TYPE_SIMPLE,
			DIALOG_TYPE_CUSTOMIZE_TOOLBAR,
			DIALOG_TYPE_DELETE_MAIL,
			DIALOG_TYPE_GO_TO_PAGE,
			DIALOG_TYPE_MAIL_FILTER,
			DIALOG_TYPE_DOWNLOAD,
			DIALOG_TYPE_DOWNLOAD_SETUP,
			DIALOG_TYPE_BOOKMARK_MANAGER,
			DIALOG_TYPE_CONTACT_MANAGER,
			DIALOG_TYPE_LINK_MANAGER,
			DIALOG_TYPE_FILETYPE,
			DIALOG_TYPE_CLEAR_PRIVATE_DATA,
			DIALOG_TYPE_SAVE_SESSION,
			DIALOG_TYPE_IMAGE_PROPERTIES,
			DIALOG_TYPE_SET_HOMEPAGE,
			DIALOG_TYPE_PRINT_OPTIONS,
			DIALOG_TYPE_VALIDATE_SOURCE,
			DIALOG_TYPE_PREFERENCES,
			DIALOG_TYPE_INPUT_MANAGER,
			DIALOG_TYPE_SERVER_MANAGER,
			DIALOG_TYPE_FIND_TEXT,
			DIALOG_TYPE_CHANGE_MASTERPASSWORD,
			DIALOG_TYPE_CERTIFICATE_MANAGER,
			DIALOG_TYPE_ADD_WEB_LANGUAGE,
			DIALOG_TYPE_LINK_STYLE,
			DIALOG_TYPE_INTERNATIONAL_FONTS,
			DIALOG_TYPE_CERTIFICATE_DETAILS,
			DIALOG_TYPE_CERTIFICATE_INSTALL,
			DIALOG_TYPE_PROXY_SERVERS,
			DIALOG_TYPE_NAME_COMPLETION,
			DIALOG_TYPE_SECURITY_PROTOCOLS,
			DIALOG_TYPE_SECURITY_PASSWORD,
			DIALOG_TYPE_FILE_UPLOAD,
			DIALOG_TYPE_ASKTEXT,
			DIALOG_TYPE_COOKIEWARNING,
			DIALOG_TYPE_ASKCOOKIE,
			DIALOG_TYPE_POSTINSECURE,
			DIALOG_TYPE_COOKIE_ERROR,
			DIALOG_TYPE_SERVER_PROPERTIES,
			DIALOG_TYPE_FIRST_TIME_SETUP,
			DIALOG_TYPE_SELECT_FONT,
            DIALOG_TYPE_MIDCLICK_PREFERENCES,
            DIALOG_TYPE_WEB_SEARCH,
            DIALOG_TYPE_PLUGIN_PATH,
            DIALOG_TYPE_PLUGIN_CHECK,
            DIALOG_TYPE_PLUGIN_RECOVERY,
            DIALOG_TYPE_JAVASCRIPT_CONSOLE,
			DIALOG_TYPE_MODE_MANAGER,
            DIALOG_TYPE_TRUSTED_PROTOCOL,
			DIALOG_TYPE_GROUP_PROPERTIES,
			DIALOG_TYPE_ADD_FILTER,
            DIALOG_TYPE_KIOSK_RESET,
			DIALOG_TYPE_REINDEX_MAIL,
			DIALOG_TYPE_SCRIPT_OPTIONS,
			DIALOG_TYPE_NEW_ACCOUNT,
            DIALOG_TYPE_PROFILE,
			DIALOG_TYPE_SPELL_CHECK,
            DIALOG_TYPE_PRINT,
            DIALOG_TYPE_PRINT_PROGRESS,
            DIALOG_TYPE_FILE_HANDLER,
            DIALOG_TYPE_EDIT_FILE_HANDLER,
			DIALOG_TYPE_ADVANCED_VOICE_OPTIONS_obsolete,
			DIALOG_TYPE_REPORT_SITE_PROBLEM,
			DIALOG_TYPE_UPGRADE_AVAILABLE,
			DIALOG_TYPE_NO_UPGRADE_AVAILABLE,
			DIALOG_TYPE_ERROR_CHECKING_FOR_UPGRADE,
			DIALOG_TYPE_ADVANCED_WINDOWS_OPTIONS,
			DIALOG_TYPE_SECURITY_INFORMATION_DIALOG,
			DIALOG_TYPE_SAVE_ATTACHMENTS,
			DIALOG_TYPE_LANGUAGE_PREFERENCES,
			DIALOG_TYPE_DEFAULT_APPLICATION,
			DIALOG_TYPE_MESSAGE_CONSOLE_DIALOG,
			DIALOG_TYPE_BITTORRENT_STARTDOWNLOAD,
			DIALOG_TYPE_BITTORRENT_CONFIGURATION,
			DIALOG_TYPE_SEARCH_ENGINE_EDIT,
#ifdef SUPPORT_VISUAL_ADBLOCK
			DIALOG_TYPE_CONTENT_BLOCK_ACCEPT,
#endif // SUPPORT_VISUAL_ADBLOCK
			DIALOG_TYPE_GADGET_PROPERTIES,
			DIALOG_TYPE_MAILER_SELECTION,
			DIALOG_TYPE_SPEEDDIAL_CONFIG,
			DIALOG_TYPE_ASK_MAX_MESSAGES_DOWNLOAD,
			DIALOG_TYPE_MAIL_MESSAGE,
			DIALOG_TYPE_SYNC_LOGON,
			DIALOG_TYPE_SYNC_SIGNUP,
			DIALOG_TYPE_INSTALL_CERT_WIZARD,
			DIALOG_TYPE_CERT_WARNING,

			//Add new dialog types here

#ifdef PRODUCT_OPTYPEDOBJECT_DIALOG_FILE
#include PRODUCT_OPTYPEDOBJECT_DIALOG_FILE
#endif // PRODUCT_OPTYPEDOBJECT_DIALOG_FILE

			DIALOG_TYPE_LAST,			// must be last of dialog types.. so we can cast something unknown to Dialog based on type

			DRAG_TYPE_BOOKMARK,
			DRAG_TYPE_CONTACT,
			DRAG_TYPE_NOTE,
			DRAG_TYPE_HISTORY,
			DRAG_TYPE_TRANSFER,
			DRAG_TYPE_WINDOW,
			DRAG_TYPE_DOCUMENT,
			DRAG_TYPE_MAIL,
			DRAG_TYPE_MAIL_INDEX,
			DRAG_TYPE_LINK,
			DRAG_TYPE_IMAGE,
			DRAG_TYPE_BUTTON,
			DRAG_TYPE_EDIT,
			DRAG_TYPE_DROPDOWN,
			DRAG_TYPE_SPACER,
			DRAG_TYPE_ADDRESS_DROPDOWN,
			DRAG_TYPE_SEARCH_DROPDOWN,
			DRAG_TYPE_SEARCH_EDIT,
			DRAG_TYPE_ZOOM_DROPDOWN,
            DRAG_TYPE_ACCOUNT_DROPDOWN,
			DRAG_TYPE_STATUS,
			DRAG_TYPE_TEXT,
            DRAG_TYPE_SEPARATOR,
            DRAG_TYPE_QUICK_FIND,
			DRAG_TYPE_SPEEDDIAL,
			DRAG_TYPE_HTML_ELEMENT,

#ifdef PRODUCT_OPTYPEDOBJECT_DRAG_FILE
#include PRODUCT_OPTYPEDOBJECT_DRAG_FILE
#endif // PRODUCT_OPTYPEDOBJECT_DRAG_FILE

			//Add new drag types here

			HISTORY_ELEMENT_TYPE,
			CHATTER_TYPE,
			CHATROOM_TYPE,
			ACCOUNT_TYPE,
			CONNECTION_TYPE,
			INDEX_FOLDER_TYPE,
			CHATROOM_SERVER_TYPE,
			NEWSGROUP_TYPE,
			NEWSFEED_TYPE,
			IMAPFOLDER_TYPE,
			APPLICATION_TYPE,
			TRANSFER_ELEMENT_TYPE,
			SEARCHTEMPLATE_TYPE,
			VIEWER_TYPE,
			SOUND_TYPE,
			PREFERENCE_TYPE,
			IMPORT_IDENTITY_TYPE,
			IMPORT_ACCOUNT_TYPE,
			IMPORT_FOLDER_TYPE,
			IMPORT_MAILBOX_TYPE,
			PLUGINVIEWER_TYPE,
			COOKIE_TYPE,
			SERVER_TYPE,
			WAND_TYPE,
			EMBEDDED_CONTENT_TYPE
		};

		virtual Type		GetType() = 0;
		virtual INT32		GetID() = 0;

		// getting a new unique ID

		static INT32		GetUniqueID();
		virtual 			~OpTypedObject(){}
};

// ---------------------------------------------------------------------------------
#endif // !MODULES_UTIL_OPTYPEDOBJECT_H
