/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 2002-2010 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.
** It may not be distributed under any circumstances.
*/
#include "core/pch.h"

#include "modules/dom/src/domevents/domeventdata.h"
#include "modules/dom/src/domglobaldata.h"

// Note: we need to undefine the macro FLAG here, because it was
// already defined as "unsigned short" in
// modules/spellchecker/hunspell_3p/src/hunspell/atypes.h - so let's
// hope that nobody in dom's jumbo compile unit needs anything from
// hunspell...
#undef FLAG
#define FLAG(name) DOM_EventData::FLAG_##name

#ifdef DOM_NO_COMPLEX_GLOBALS
# define DOM_EVENTDATA_START() void DOM_eventData_Init(DOM_GlobalData *global_data) { DOM_EventData *data = global_data->eventData;
# define DOM_EVENTDATA_ITEM(name_, flags_) data->name = name_; data->flags = flags_; ++data;
# define DOM_EVENTDATA_END() data->name = NULL; }
#else // DOM_NO_COMPLEX_GLOBALS
# define DOM_EVENTDATA_START() const DOM_EventData g_DOM_eventData[] = {
# define DOM_EVENTDATA_ITEM(name_, flags_) { name_, flags_ },
# define DOM_EVENTDATA_END() { NULL, FLAG(NONE) } };
#endif // DOM_NO_COMPLEX_GLOBALS


/* Note, if you add a name shorter than 4 characters or longer than 32
   characters, you have to modify Event::GetEventType.
   This table has to be kept in sync with the enum in domeventtypes.h
   */
DOM_EVENTDATA_START()
	DOM_EVENTDATA_ITEM("resize",                        FLAG(BUBBLES) | FLAG(PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("scroll",                        FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("focusin",                       FLAG(BUBBLES) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("focusout",                      FLAG(BUBBLES) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("gainselection",                 FLAG(BUBBLES) | FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("loseselection",                 FLAG(BUBBLES) | FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("activate",                      FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("click",                         FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("mousedown",                     FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("mouseup",                       FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("mouseover",                     FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("mouseenter",                    FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("mousemove",                     FLAG(BUBBLES) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("mouseout",                      FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("mouseleave",                    FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("mousewheel",                    FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("", /* ONMOUSEWHEELH */          FLAG(BUBBLES) | FLAG(CANCELABLE))
	DOM_EVENTDATA_ITEM("", /* ONMOUSEWHEELV */          FLAG(BUBBLES) | FLAG(CANCELABLE))
	DOM_EVENTDATA_ITEM("keypress",                      FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("keydown",                       FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("keyup",                         FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("load",                          FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("unload",                        FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("abort",                         FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("error",                         FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("select",                        FLAG(BUBBLES) | FLAG(PROPERTY) | FLAG(HTML_FORM_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("change",                        FLAG(BUBBLES) | FLAG(PROPERTY) | FLAG(HTML_FORM_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("submit",                        FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_FORM_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("reset",                         FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_FORM_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("focus",                         FLAG(PROPERTY) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("blur",                          FLAG(PROPERTY) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("dblclick",                      FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("contextmenu",                   FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("readystatechange",              FLAG(PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("visibilitychange",              FLAG(BUBBLES))
	DOM_EVENTDATA_ITEM("hashchange",                    FLAG(PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("input",                         FLAG(BUBBLES) | FLAG(PROPERTY) | FLAG(HTML_FORM_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("online",                        FLAG(BUBBLES) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("offline",                       FLAG(BUBBLES) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("message",                       FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("DOMFocusIn",                    FLAG(BUBBLES))
	DOM_EVENTDATA_ITEM("DOMFocusOut",                   FLAG(BUBBLES))
	DOM_EVENTDATA_ITEM("DOMActivate",                   FLAG(BUBBLES) | FLAG(CANCELABLE))
#ifdef DOM2_MUTATION_EVENTS
	DOM_EVENTDATA_ITEM("DOMSubtreeModified",            FLAG(BUBBLES))
	DOM_EVENTDATA_ITEM("DOMNodeInserted",               FLAG(BUBBLES))
	DOM_EVENTDATA_ITEM("DOMNodeRemoved",                FLAG(BUBBLES))
	DOM_EVENTDATA_ITEM("DOMNodeRemovedFromDocument",    FLAG(NONE))
	DOM_EVENTDATA_ITEM("DOMNodeInsertedIntoDocument",   FLAG(NONE))
	DOM_EVENTDATA_ITEM("DOMAttrModified",               FLAG(BUBBLES))
	DOM_EVENTDATA_ITEM("DOMCharacterDataModified",      FLAG(BUBBLES))
#endif // DOM2_MUTATION_EVENTS
	DOM_EVENTDATA_ITEM("DOMContentLoaded",              FLAG(BUBBLES) | FLAG(CANCELABLE))
	DOM_EVENTDATA_ITEM("DOMFrameContentLoaded",         FLAG(BUBBLES) | FLAG(CANCELABLE))
	DOM_EVENTDATA_ITEM("invalid",                       FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("forminput",                     FLAG(PROPERTY) | FLAG(HTML_FORM_ELEMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("formchange",                    FLAG(PROPERTY) | FLAG(HTML_FORM_ELEMENT_PROPERTY))
#ifdef SVG_DOM
	DOM_EVENTDATA_ITEM("SVGLoad",                       FLAG(NONE))
	DOM_EVENTDATA_ITEM("SVGUnload",                     FLAG(NONE))
	DOM_EVENTDATA_ITEM("SVGAbort",                      FLAG(BUBBLES))
	DOM_EVENTDATA_ITEM("SVGError",                      FLAG(BUBBLES))
	DOM_EVENTDATA_ITEM("SVGResize",                     FLAG(NONE))
	DOM_EVENTDATA_ITEM("SVGScroll",                     FLAG(NONE))
	DOM_EVENTDATA_ITEM("SVGZoom",                       FLAG(NONE))	// NOTE: Has no DOM event name according to svg spec
	DOM_EVENTDATA_ITEM("beginEvent",                    FLAG(BUBBLES) | FLAG(CANCELABLE) ) // NOTE: Has no DOM event name according to svg spec
	DOM_EVENTDATA_ITEM("endEvent",                      FLAG(BUBBLES) | FLAG(CANCELABLE) ) // NOTE: Has no DOM event name according to svg spec
	DOM_EVENTDATA_ITEM("repeatEvent",                   FLAG(BUBBLES) | FLAG(CANCELABLE) ) // NOTE: Has no DOM event name according to svg spec
#endif // SVG_DOM
#if defined(PROGRESS_EVENTS_SUPPORT) || defined(MEDIA_HTML_SUPPORT)
	DOM_EVENTDATA_ITEM("loadstart",                     FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("progress",                      FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("suspend",                       FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("stalled",                       FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("loadend",                       FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("timeout",                       FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
#endif // defined(PROGRESS_EVENTS_SUPPORT) || defined(MEDIA_HTML_SUPPORT)
#ifdef MEDIA_HTML_SUPPORT
	DOM_EVENTDATA_ITEM("emptied",                       FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("play",                          FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("pause",                         FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("loadedmetadata",                FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("loadeddata",                    FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("waiting",                       FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("playing",                       FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("seeking",                       FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("seeked",                        FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("timeupdate",                    FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("ended",                         FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("canplay",                       FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("canplaythrough",                FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("ratechange",                    FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("durationchange",                FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("volumechange",                  FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("cuechange",                     FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("enter",                         FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("exit",                          FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("addtrack",                      FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("removetrack",                   FLAG(PROPERTY))
#endif // MEDIA_HTML_SUPPORT
#ifdef CSS_TRANSITIONS
	DOM_EVENTDATA_ITEM("webkitTransitionEnd",           FLAG(BUBBLES) | FLAG(CANCELABLE) )
	DOM_EVENTDATA_ITEM("otransitionend",                FLAG(BUBBLES) | FLAG(CANCELABLE) )
	DOM_EVENTDATA_ITEM("transitionend",                 FLAG(BUBBLES) | FLAG(CANCELABLE) )
#endif // CSS_TRANSITIONS
#ifdef CSS_ANIMATIONS
	DOM_EVENTDATA_ITEM("animationstart",                FLAG(BUBBLES) | FLAG(CANCELABLE) )
	DOM_EVENTDATA_ITEM("animationend",                  FLAG(BUBBLES) | FLAG(CANCELABLE) )
	DOM_EVENTDATA_ITEM("animationiteration",            FLAG(BUBBLES) | FLAG(CANCELABLE) )
#endif // CSS_ANIMATIONS
#ifdef CLIENTSIDE_STORAGE_SUPPORT
	DOM_EVENTDATA_ITEM("storage",                       FLAG(PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
#endif // CLIENTSIDE_STORAGE_SUPPORT

	DOM_EVENTDATA_ITEM("SearchSuggestionsEvent",        FLAG(PROPERTY) )

#ifdef DOM_FULLSCREEN_MODE
	DOM_EVENTDATA_ITEM("fullscreenerror",               FLAG(BUBBLES) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("fullscreenchange",              FLAG(BUBBLES) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY))
#endif // DOM_FULLSCREEN_MODE

#ifdef APPLICATION_CACHE_SUPPORT
	DOM_EVENTDATA_ITEM("checking",                      FLAG(CANCELABLE) | FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("noupdate",                      FLAG(CANCELABLE) | FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("downloading",                   FLAG(CANCELABLE) | FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("updateready",                   FLAG(CANCELABLE) | FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("cached",                        FLAG(CANCELABLE) | FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("obsolete",                      FLAG(CANCELABLE) | FLAG(PROPERTY))
#endif

#if defined(EVENT_SOURCE_SUPPORT) || defined(WEBSOCKETS_SUPPORT)
	DOM_EVENTDATA_ITEM("open",							FLAG(PROPERTY) )
#endif // EVENT_SOURCE_SUPPORT || WEBSOCKETS_SUPPORT

#ifdef WEBSOCKETS_SUPPORT
	DOM_EVENTDATA_ITEM("close",							FLAG(PROPERTY))
#endif //WEBSOCKETS_SUPPORT

#ifdef DOM_WEBWORKERS_SUPPORT
	DOM_EVENTDATA_ITEM("connect",						FLAG(PROPERTY) )
#endif // DOM_WEBWORKERS_SUPPORT

#ifdef CANVAS3D_SUPPORT
	DOM_EVENTDATA_ITEM("frameend",						FLAG(PROPERTY) )
#endif //CANVAS3D_SUPPORT

#ifdef TOUCH_EVENTS_SUPPORT
	DOM_EVENTDATA_ITEM("touchstart",                    FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("touchmove",                     FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("touchend",                      FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("touchcancel",                   FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
#endif // TOUCH_EVENTS_SUPPORT

#ifdef EXTENSION_SUPPORT
	DOM_EVENTDATA_ITEM("create",                        FLAG(PROPERTY) )
	DOM_EVENTDATA_ITEM("disconnect",                    FLAG(PROPERTY) )
	DOM_EVENTDATA_ITEM("move",                          FLAG(PROPERTY) )
	DOM_EVENTDATA_ITEM("remove",                        FLAG(PROPERTY) )
	DOM_EVENTDATA_ITEM("update",                        FLAG(PROPERTY) )
#endif // EXTENSION_SUPPORT

	DOM_EVENTDATA_ITEM("popstate",                      FLAG(PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) )

#ifdef DOM_DEVICE_ORIENTATION_EVENT_SUPPORT
	DOM_EVENTDATA_ITEM("deviceorientation",             FLAG(PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("compassneedscalibration",       FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
	DOM_EVENTDATA_ITEM("devicemotion",                  FLAG(PROPERTY) | FLAG(HTML_WINDOW_PROPERTY))
#endif // DOM_DEVICE_ORIENTATION_EVENT_SUPPORT

#ifdef PAGED_MEDIA_SUPPORT
	DOM_EVENTDATA_ITEM("pagechange",                    FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) )
#endif // PAGED_MEDIA_SUPPORT

#ifdef DRAG_SUPPORT
	DOM_EVENTDATA_ITEM("dragstart",						FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("drag",							FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("dragenter",						FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("dragleave",						FLAG(BUBBLES) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("dragover",						FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("drop",							FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("dragend",						FLAG(BUBBLES) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(HTML_WINDOW_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
#endif // DRAG_SUPPORT
#ifdef USE_OP_CLIPBOARD
	DOM_EVENTDATA_ITEM("copy",							FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("cut",							FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
	DOM_EVENTDATA_ITEM("paste",							FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY) | FLAG(HTML_DOCUMENT_PROPERTY) | FLAG(SVG_DOCUMENT_PROPERTY))
#endif // USE_OP_CLIPBOARD
	DOM_EVENTDATA_ITEM("textinput",                     FLAG(BUBBLES) | FLAG(CANCELABLE) | FLAG(PROPERTY) | FLAG(HTML_ELEMENT_PROPERTY))

#ifdef URL_FILTER
	DOM_EVENTDATA_ITEM("contentblocked",             FLAG(PROPERTY))
	DOM_EVENTDATA_ITEM("contentunblocked",           FLAG(PROPERTY))
	#ifdef SELFTEST
		DOM_EVENTDATA_ITEM("contentallowed",           FLAG(PROPERTY))
	#endif // SELFTEST
#endif // URL_FILTER
DOM_EVENTDATA_END()
#undef FLAG
