#!/usr/bin/pike
/* -*- Mode: pike; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */

#define SUPPORT_TEXT_DIRECTION
#include "../unicode.h"

void main()
{
	array table = ({});
	int rows;
	string mirror = "\0"*65536;

	// Read BidiMirroring.txt
	foreach (Stdio.stdin.read()/"\n", string line)
	{
		// Ignore comments and split semi-colon separated fields
		sscanf(line, "%s#", line);
		array data = line / ";";
		if (sizeof(data) != 2)
			continue;

		// Fetch the character numbers
		int c1, c2;
		sscanf(data[0], "%x", c1);
		sscanf(data[1], "%x", c2);
		mirror[c1]=c2;

		// Ignore non-BMP characters
		if (c1 > 65535 || c2 > 65535)
			continue;
		rows++;

		if (!sizeof(table))
			table += ({ ({c1, c2}) });
		else {
			if (c2 < c1)
				continue;
			table += ({ ({ c1, c2 }) });
		}
	}

	// Sort the mapping table
	array table_other = ({});
	sort(table);

	// Split table in two; one where each code point is consecutive
	// over both the first and second index (we can binary-search it)
	// and one with the overlapping mappings which we need to
	// search linearly.	
	foreach (table; int i; array q)
	{
		if (i && (q[0]<table[i-1][1]))
		{
			table_other += ({table[i-1]});
			table[i-1]=0;
		}
	}
	table -= ({0});

	Stdio.write_file("mirror.dat", string_to_unicode(mirror));


	werror("%d rows; %d in table1; %d in table2\n", rows,
		 sizeof(table), sizeof(table_other));
	write(#"/** @file mirror.inl
 * This file is auto-generated by modules/unicode/scripts/make_mirror.pike.
 * DO NOT EDIT THIS FILE MANUALLY.
 */\n
#ifdef USE_UNICODE_INC_DATA\n");
	write("#define MIRROR_OTHER_MIN "+min(@Array.flatten(table_other))+"\n");
	write("#define MIRROR_OTHER_MAX "+max(@Array.flatten(table_other))+"\n");

	write("static const uni_char mirror_table_other[] = { // not sorted");
	for (int i = 0; i < sizeof(table_other); i ++)
	{
		if (i)
			write(",");
		write("\n\t0x%x, 0x%x", table_other[i][0], table_other[i][1]);
	}
	write("\n};\n");
	write("\n");


	int table_max_255;
	write("static const uni_char mirror_table[] = { // sorted");
	for (int i = 0; i<sizeof(table); i++)
	{
		if (i)
			write(",");
		write("\n\t0x%x, 0x%x", table[i][0], table[i][1]);
		if (table[i][0] < 256)
			table_max_255 = i*2+2;
	}
	write("\n};\n");
	write("#define MIRROR_LAST_255 "+table_max_255+"\n");
	write("\n#endif // USE_UNICODE_INC_DATA\n");
}
