#! /usr/bin/python
import sys
import re
import array

def error(message):
	print >>sys.stderr, message
	sys.exit(1)

pattern = re.compile('([\d\.A-Fa-f]+); [^;]*; (.)')
joining_types = ['JT_' + ch for ch in 'RLDCUT']
codepoints = []
values = []

# Interesting values are only in BMP, so only BMP is selftested.
# Code points that are not explicitly listed in ArabicShaping.txt are either of joining type T or U (not T only),  
# so the table is corrected in the selftest code basing on CharacterClass property.
selftest_table = ['JT_T']*0x10000;

# Open and parse the input data
try:
	file = open('../data/ArabicShaping.txt', 'r')
except:
	error("Error opening ArabicShaping.txt")

for line in file.readlines():
	m = pattern.match(line)
	if not m:
		continue

	# Get codepoint and joining_type from the parsed line
	codepoint_s, joining_type = m.group(1,2)

	joining_type = "JT_"+joining_type
	codepoint = int(codepoint_s, 16)

	if not joining_type in joining_types:
		joining_types.append(joining_type)

	codepoints.append(codepoint)
	values.append(joining_type)
	selftest_table[codepoint] = joining_type;

# Write the selftest data
out = open("joiningtype.dat", "wb")
array.array("B", [joining_types.index(x) for x in selftest_table]).tofile(out)
out.close()

# Write the requested table
# Write enum and table used by Unicode::GetJoiningType method
print "/** @file joiningtype.inl"
print " * This file is auto-generated by modules/unicode/scripts/make_joiningtype.py."
print " * DO NOT EDIT THIS FILE MANUALLY."
print " */\n"
print "#ifdef USE_UNICODE_INC_DATA"

print "enum UnicodeJoiningType {" + ",".join(joining_types)+"};\n"

print "static const UnicodePoint table_joiningtype_codepoints[] = {"
row = codepoints[0:8]
while row:
	print "\t"+", ".join(["0x%.4x" % v for v in row])+","
	codepoints = codepoints[8:]
	row = codepoints[0:8]
print "};\n"

print "static const UnicodeJoiningType table_joiningtype_values[] = {"
row = values[0:16]
while row:
	print "\t"+", ".join(row)+","
	values = values[16:]
	row = values[0:16]
print "};"

print "#endif // USE_UNICODE_INC_DATA"
