/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 2008-2009 Opera Software ASA.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

#ifndef INPUTMANAGER_CONSTANTS_H
#define INPUTMANAGER_CONSTANTS_H

enum FOCUS_REASON
{
	FOCUS_REASON_MOUSE,				// Clicked in it
	FOCUS_REASON_KEYBOARD,			// Keyboard navigated to it
	FOCUS_REASON_ACTION,			// Focus set because of action handling (shortcuts)
	FOCUS_REASON_ACTIVATE,			// Window was activated
	FOCUS_REASON_RELEASE,			// Focus received because focused child released itself
	FOCUS_REASON_RESTORE,           // Document state was restored, e.g. due to history navigation
	FOCUS_REASON_SIMULATED,			/** No well defined reason except that it should result in new ONFOCUS events and such, just like mouse and keyboard reasons.
										Extra caution is taken to not change focus in some cases using this reason (for security reasons!).
										This is to f.ex prevent evil scripts from moving focus between webpages (or from the UI) to record keystrokes. */
	FOCUS_REASON_OTHER				/** No well defined reason.
										Extra caution is taken to not change focus in some cases using this reason (for security reasons!).
										This is to f.ex prevent evil scripts from moving focus between webpages (or from the UI) to record keystrokes. */
};

enum TOUCH_INPUT_STATE
{
	TOUCH_INPUT_ACTIVE	= 0x01,		// Input event generated by touch
	TOUCH_INPUT_INERTIA = 0x02,		// Inertia is active for touch scrolling or simulated mouse move
};

#endif // INPUTMANAGER_CONSTANTS_H
