// <-*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*->
// <copyright header>

// <autogenerated opera.py>

#ifndef MODULES_HARDCORE_OPERA_OPERA_H
#define MODULES_HARDCORE_OPERA_OPERA_H

// <includes>
#include "modules/hardcore/component/OpComponent.h"
#include "modules/hardcore/component/OpComponentManager.h"
#include "modules/hardcore/component/OpComponentPlatform.h"


class CoreComponent
	: public OpComponent
{
public:
	CoreComponent(const OpMessageAddress& address, OpComponentType type);

	~CoreComponent() {}

	/**
	 * Initializes the component by running InitL(info, type) on all modules.
	 * When this function succeeds the component is completely initialized.
	 *
	 * If this function fails it LEAVE:s with an error code from the
	 * module that failed.  The member failed_module_index can be used
	 * to check which module failed, or, in debug builds, the member
	 * init_message, containing the name of the failed module.
	 *
	 * After this function has been called, Destroy() must be called
	 * to deinitialize the component, even if the initialization failed.
	 *
	 * Multi process note:
	 *
	 * It is not the intention that the platform explicitly call InitL on
	 * each CoreComponent created. It actually can't, as it won't know them.
	 * Instead, CoreComponents will be started and receive an INIT message
	 * from the service process, containing the information they need. This
	 * will then prompt them to call InitL on themselves, and everything
	 * will happen tidily within the context of their RunSlice().
	 *
	 * The service component, being the first component to be started, and
	 * responsible for starting all other components, will receive its INIT
	 * message from the platform.
	 */
	void InitL(const OperaInitInfo& info);

	/**
	 * Terminates the component.
	 */
	void Destroy();

#ifdef MESSAGELOOP_RUNSLICE_SUPPORT
	/**
	 * RequestRunSlice is a compatibility function that relays the request
	 * to the new API.
	 */
	virtual OP_STATUS RequestRunSlice();
#endif // MESSAGELOOP_RUNSLICE_SUPPORT

	/**
	 * Deliver an incoming message to a local listener.
	 *
	 * See OpComponent::DispatchMessage().
	 *
	 * @param message Message to dispatch.
	 *
	 * @returns Return value from the appropriate ProcessMessage() method.
	 */
	virtual OP_STATUS DispatchMessage(const OpTypedMessage* message);

	/**
	 * Process an incoming message
	 */
	virtual OP_STATUS ProcessMessage(const OpTypedMessage* message);

	/**
	 * Tells the component to free cached data.
	 * This can be done in a new handler for example.
	 * If there is a possibility that there will be more memory available,
	 * TRUE will be returned.
	 */
	BOOL FreeCachedData();

	// <opera variables>

	OperaModule* modules[OPERA_MODULE_COUNT];

	/**
	 * Index of the module that failed during a call to InitL(), or -1 if
	 * InitL() hasn't been called or no module failed.
	 */
	int failed_module_index;

#if defined(_DEBUG) || defined(HC_MODULE_INIT_PROFILING)
	const char* module_names[OPERA_MODULE_COUNT];
#endif // defined(_DEBUG) || defined(HC_MODULE_INIT_PROFILING)
#ifdef _DEBUG
	/**
	 * Message set by initialization code. Can be used when debugging.
	 */
	const char* init_message;
#endif // _DEBUG

#ifdef INIT_BLACKLIST
	/**
	 * Black list used when TWEAK_HC_INIT_BLACKLIST is turned on.
	 */
	unsigned char black_list[(OPERA_MODULE_COUNT + 7) / 8];
#endif // INIT_BLACKLIST

	BOOL running;

	/** Returns true if the CoreComponents is alive.
	 * This is the case from the start of the existence until Destroy() is
	 * called to terminate the component. An associated MessageHandler shall
	 * only accept legacy messages while the CoreComponent is alive. */
	bool IsAlive() const { return m_is_alive; }

private:
	/**
	 * Collect entropy during processing of legacy messages. Should be expanded
	 * to collect entropy from all component manager messages, but this requires
	 * additional support from the typed message interface.
	 */
	void CollectEntropy(class OpLegacyMessage* message);

	/* Entropy collect count. @See CoreComponent::CollectEntropy(). */
	unsigned int m_entropy_collect_count;

	/** Is true from the start of the existence until Destroy() is called to
	 * terminate the component. An associated MessageHandler shall only accept
	 * legacy messages while the CoreComponent is alive. */
	bool m_is_alive;
};

enum OperaModuleId
{
	// <opera modules enum>
};
#endif // !MODULES_HARDCORE_OPERA_OPERA
