# -*- Mode: python; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-

import datetime
import re
import sys
import os
import os.path
import glob
import StringIO
import optparse

# This script is known to be located in modules/sqlite/ so that is the
# value of sys.path[0] and two levels up is the source root:
sourceRoot = os.path.normpath(os.path.join(sys.path[0], '..', '..'))
sqliteDir = os.path.join(sourceRoot, 'modules', 'sqlite')
sys.path.insert(1, os.path.join(sourceRoot, 'modules', 'hardcore', 'scripts'))
import util

exclude_files = frozenset(("tclsqlite.c",))
wrapper_template = os.path.join(sqliteDir, 'wrapper_template.c')

usage = ["usage: %prog [options]",
		 "",
		 "Generate wrapper files for all sqlite source-files src/*.c"]
parser = optparse.OptionParser(usage="\n".join(usage))
parser.add_option("-v", "--verbose",
				  action="count", dest="verbosity", default=0,
				  help="increase verbosity")
(options, args) = parser.parse_args()
verbosity = options.verbosity

def verbose(message, level = 0):
	"""
	Prints the specified message if the specified level is greater or
	equal the verbosity level specified on the command-line.
	"""
    global verbosity
    if verbosity >= level:
        print message

def relative_filename(filename):
	"""
	Returns the filename relative to the directory modules/sqlite/.
	"""
	return re.sub("^%s%s" % (re.escape(sqliteDir), re.escape(os.sep)), '',
				  filename)

class HandleTemplateAction:
	"""
	Used to generate the wrapper file with util.readTemplate()
	"""
    def __init__(self, original_filename):
        self.__original_filename = original_filename

    def __call__(self, action, output):
        if action == "original filename":
            output.write('# include "modules/sqlite/src/%s"\n' % self.__original_filename)
            return True

module_sources = StringIO.StringIO()
module_sources.write("# Note: this file is automatically generated by modules/sqlite/mkwrappers.py\n")
module_sources.write("#\n")
module_sources.write("# Note: The generated source files needs to include several\n")
module_sources.write("# system header files. Thus it defines COMPILING_SQLITE before\n")
module_sources.write("# including core/pch_system_includes.h so the platform's system.h is\n")
module_sources.write("# able to prepare for that. So all files need options\n")
module_sources.write("# [no-jumbo;system_includes;no-pch]\n")

verbose("Scanning for .c files...")

# find the .c files
for filename in glob.glob(os.path.join(sqliteDir, "src", "*.c")):
    verbose(" Found %s" % relative_filename(filename), 1)
    basename = os.path.basename(filename)
    if basename not in exclude_files:
		wrapper_filename = os.path.join(sqliteDir, "generated", "sqlite_" + basename)
		verbose("  Wrapping %s into %s" % (relative_filename(filename), relative_filename(wrapper_filename)), 2)
		if util.readTemplate(wrapper_template, wrapper_filename,
							 HandleTemplateAction(basename)):
			verbose("  Updated %s" % relative_filename(wrapper_filename))
		else:
			verbose("  File %s not changed" % relative_filename(wrapper_filename), 2)
		module_sources.write("%s # [winnopch]\n" % '/'.join(["generated", "sqlite_" + basename]))
    else:
        verbose("  Excluded %s" % filename, 2)

verbose("Finished wrapping .c files.");

if (util.updateFile(module_sources, os.path.join(sqliteDir, "module.sources"))):
	verbose("Updated module.sources")
else:
	verbose("module.sources not changed")
