#!/usr/local/bin/perl

use strict;

my %xref_tbl;
my %oid_tbl;

my ($mac_file, $xref_file) = @ARGV;

open(IN, $mac_file) || die "Can't open $mac_file";

# Read in OID nid values for a lookup table.

while (<IN>)
	{
	chomp;
	my ($name, $num) = /^(\S+)\s+(\S+)$/;
	$oid_tbl{$name} = $num;
	}
close IN;

open(IN, $xref_file) || die "Can't open $xref_file";

my $ln = 1;

while (<IN>)
	{
	chomp;
	s/#.*$//;
	next if (/^\S*$/);
	my ($xr, $p1, $p2) = /^(\S+)\s+(\S+)\s+(\S+)/;
	check_oid($xr);
	check_oid($p1);
	check_oid($p2);
	$xref_tbl{$xr} = [$p1, $p2, $ln];
	}

my @xrkeys = keys %xref_tbl;

my @srt1 = sort { $oid_tbl{$a} <=> $oid_tbl{$b}} @xrkeys;

for(my $i = 0; $i <= $#srt1; $i++)
	{
	$xref_tbl{$srt1[$i]}[2] = $i;
	}

my @srt2 = sort
	{
	my$ap1 = $oid_tbl{$xref_tbl{$a}[0]};
	my$bp1 = $oid_tbl{$xref_tbl{$b}[0]};
	return $ap1 - $bp1 if ($ap1 != $bp1);
	my$ap2 = $oid_tbl{$xref_tbl{$a}[1]};
	my$bp2 = $oid_tbl{$xref_tbl{$b}[1]};

	return $ap2 - $bp2;
	} @xrkeys;

my $pname = $0;

$pname =~ s|^.[^/]/||;

print <<EOF;
/* AUTOGENERATED BY $pname, DO NOT EDIT */

#include "modules/libopeay/libopeay_arrays.h"


typedef struct nid_triple_st
	{
	int sign_id;
	int hash_id;
	int pkey_id;
	} nid_triple;

OPENSSL_PREFIX_CONST_ARRAY(extern, struct nid_triple_st, obj_xref__sigoid_srt, libopeay)
EOF

foreach (@srt1)
	{
	my $xr = $_;
	my ($p1, $p2) = @{$xref_tbl{$_}};
	#print "\t{NID_$xr, NID_$p1, NID_$p2},\n";
	print "\tCONST_TRIPLE_ENTRY(sign_id,NID_$xr, hash_id,NID_$p1, pkey_id,NID_$p2)\n";
	}

print <<EOF;
CONST_END(obj_xref__sigoid_srt)
#define sigoid_srt OPENSSL_GLOBAL_ARRAY_NAME(obj_xref__sigoid_srt)


OPENSSL_PREFIX_CONST_ARRAY(static, const struct nid_triple_st*, obj_xref__sigoid_srt_xref, libopeay)
EOF

foreach (@srt2)
	{
	my $x = $xref_tbl{$_}[2];
	#print "\t\&sigoid_srt\[$x\],\n";
	print "\tCONST_ENTRY(\&sigoid_srt\[$x\])\n";
	}

print <<EOF;
CONST_END(obj_xref__sigoid_srt_xref)
#define sigoid_srt_xref OPENSSL_GLOBAL_ARRAY_NAME(obj_xref__sigoid_srt_xref)
EOF

sub check_oid
	{
	my ($chk) = @_;
	if (!exists $oid_tbl{$chk})
		{
		die "Not Found \"$chk\"\n";
		}
	}

