/* crypto/cryptlib.h */
/* Copyright (C) 1995-1998 Eric Young (eay@cryptsoft.com)
 * All rights reserved.
 *
 * This package is an SSL implementation written
 * by Eric Young (eay@cryptsoft.com).
 * The implementation was written so as to conform with Netscapes SSL.
 * 
 * This library is free for commercial and non-commercial use as long as
 * the following conditions are aheared to.  The following conditions
 * apply to all code found in this distribution, be it the RC4, RSA,
 * lhash, DES, etc., code; not just the SSL code.  The SSL documentation
 * included with this distribution is covered by the same copyright terms
 * except that the holder is Tim Hudson (tjh@cryptsoft.com).
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * If this package is used in a product, Eric Young should be given attribution
 * as the author of the parts of the library used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    "This product includes cryptographic software written by
 *     Eric Young (eay@cryptsoft.com)"
 *    The word 'cryptographic' can be left out if the rouines from the library
 *    being used are not cryptographic related :-).
 * 4. If you include any Windows specific code (or a derivative thereof) from 
 *    the apps directory (application code) you must include an acknowledgement:
 *    "This product includes software written by Tim Hudson (tjh@cryptsoft.com)"
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#ifndef HEADER_CRYPTLIB_H
#define HEADER_CRYPTLIB_H

#ifndef OPERA_SMALL_VERSION
#include <stdlib.h>
#include <string.h>
#endif /* !OPERA_SMALL_VERSION */

#include <openssl/e_os.h>

#if defined(_SSL_USE_OPENSSL_) || defined(LIBOPEAY_ENABLE_PARTLY_OPENSSL_SUPPORT)

#if defined(WIN32) && !defined(SIXTY_FOUR_BIT) && !defined(THIRTY_TWO_BIT)
#define THIRTY_TWO_BIT
#elif !defined(THIRTY_TWO_BIT) && !defined(SIXTY_FOUR_BIT) && !defined(SIXTEEN_BIT) && !defined(EIGHT_BIT)
#error One of these MUST be defined
#endif


#define OPENSSL_NO_CAMELLIA
#define OPENSSL_NO_CMS
#define OPENSSL_NO_SOCK
#define OPENSSL_NO_DEPRECATED
/*#define OPENSSL_NO_BIO */
#define OPENSSL_NO_FP_API
#define OPENSSL_NO_IDEA
#define OPENSSL_NO_ENGINE
#define OPENSSL_NO_EC
#define OPENSSL_NO_ECDH
#define OPENSSL_NO_ECDSA
#define OPENSSL_NO_SEED
//#define OPENSSL_NO_SHA256
//#define OPENSSL_NO_SHA512
#define OPENSSL_NO_SHA0
#define NO_OLD_ASN1
#define OPENSSL_NO_STDIO
#define OPENSSL_DISABLE_OLD_DES_SUPPORT

#define OPENSSL_SMALL_FOOTPRINT
#define NO_ASN1_FIELD_NAMES

#ifndef USE_SYSTEM_ASSERT
#undef assert
#define assert(x) OP_ASSERT(x)
#endif // USE_SYSTEM_ASSERT

#ifndef SSL_BLOWFISH_SUPPORT
#define OPENSSL_NO_BF
#endif

#if !(defined(NEED_LIBOPEAY_CAST_RIPE_SUPPORT))
/*#define OPENSSL_NO_AES*/
#define OPENSSL_NO_CAST
#define OPENSSL_NO_RIPEMD
#endif
#if defined(NEED_LIBOPEAY_CFB_SUPPORT)
#define OPENSSL_USE_CFB_CIPHERS
#endif
#if !defined(__SSL_WITH_DH_DSA__)
#define OPENSSL_NO_DSA
#define OPENSSL_NO_DH
#endif
#define OPENSSL_NO_MD2
#define OPENSSL_NO_MDC2
#define OPENSSL_NO_MD4
#define OPENSSL_NO_RC5
#define OPENSSL_NO_WHIRLPOOL

/*#define OPENSSL_NO_OCSP */

#define NO_CONF
#if !defined SSL_USE_WEAK_CIPHERS
#define NO_SINGLE_DES
#endif
#if !defined SSL_USE_WEAK_CIPHERS && !defined SSL_2_0_SUPPORT && !defined LIBOPEAY_PKCS12_SUPPORT
#define OPENSSL_NO_RC2
#endif
#define DES_PART_ONLY
#define NO_ERR
#define OPENSSL_NO_ERR

#ifdef EXTERNAL_SSL_OPENSSL_IMPLEMENTATION
#define OPENSSL_NO_COMP
#define OPENSSL_NO_DTLS1
#define OPENSSL_NO_ECB
#endif // EXTERNAL_SSL_OPENSSL_IMPLEMENTATION


#define OPERA_OPENSSL_STRINGS(x) ((const char *) NULL)
#else
#define OPERA_OPENSSL_STRINGS(x) x
#endif /* _SSL_USE_OPENSSL_ || LIBOPEAY_ENABLE_PARTLY_OPENSSL_SUPPORT */

#ifdef OPENSSL_USE_APPLINK
#define BIO_FLAGS_UPLINK 0x8000
#include "ms/uplink.h"
#endif

#include <openssl/crypto.h>
#include <openssl/buffer.h> 
#include <openssl/bio.h> 
#include <openssl/err.h>
#include <openssl/opensslconf.h>

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef OPENSSL_SYS_VMS
#define X509_CERT_AREA		OPENSSLDIR
#define X509_CERT_DIR		OPENSSLDIR "/certs"
#define X509_CERT_FILE		OPENSSLDIR "/cert.pem"
#define X509_PRIVATE_DIR	OPENSSLDIR "/private"
#else
#define X509_CERT_AREA		"SSLROOT:[000000]"
#define X509_CERT_DIR		"SSLCERTS:"
#define X509_CERT_FILE		"SSLCERTS:cert.pem"
#define X509_PRIVATE_DIR        "SSLPRIVATE:"
#endif

#define X509_CERT_DIR_EVP        "SSL_CERT_DIR"
#define X509_CERT_FILE_EVP       "SSL_CERT_FILE"

/* size of string representations */
#define DECIMAL_SIZE(type)	((sizeof(type)*8+2)/3+1)
#define HEX_SIZE(type)		(sizeof(type)*2)

void OPENSSL_cpuid_setup(void);
extern unsigned long OPENSSL_ia32cap_P;
void OPENSSL_showfatal(const char *,...);
void *OPENSSL_stderr(void);
extern int OPENSSL_NONPIC_relocated;

#ifdef  __cplusplus
}
#endif

#endif
