/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2006 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

#ifndef MODULES_HARDCORE_MH_MH_ENUM_H
#define MODULES_HARDCORE_MH_MH_ENUM_H

#define ID_TIMER_DELAYED_MSG_CONTROL		123

#define MH_LIST_ALL				0
#define MH_LIST_INLINE_ONLY			0x01
#define MH_LIST_NOT_INLINE_ONLY			0x02
#define MH_LIST_NOT_LOAD_SILENT_ONLY		0x04
#define MH_LIST_NOT_MODIFIED_SILENT_ONLY	0x08

enum ProgressState
{
	WAITING,
	START_NAME_LOOKUP,
	START_NAME_COMPLETION,
	WAITING_FOR_CONNECTION,
	START_SECURE_CONNECTION,
	START_CONNECT_PROXY,
	START_CONNECT,
	START_REQUEST,
	STARTED_40SECOND_TIMEOUT,
	UPLOADING_FILES,
	UPLOADING_FINISHED,
	FETCHING_DOCUMENT,
	REQUEST_FINISHED,
	REQUEST_CONNECTION_ESTABLISHED_TIMOUT,
	CONNECT_FINISHED,
	EXECUTING_ECMASCRIPT,
	WAITING_FOR_COOKIES,
	WAITING_FOR_COOKIES_DNS,
	// do not use directly
	SET_SECURITYLEVEL,
	SET_NEXTPROTOCOL,
	UPLOADING_PROGRESS,
	UPLOAD_COUNT,
#ifdef EMBROWSER_SUPPORT
	UPLOAD_SIZE,
#endif //EMBROWSER_SUPPORT
	LOAD_PROGRESS,
	HEADER_LOADED,
	LOADING_FINISHED,
	LOADING_FAILED,
	HANDLE_SECONDARY_DATA,
	REQUEST_QUEUED,
	RESTART_LOADING,
	UPDATE_DOCUMENT_INFO,
	GET_APPLICATIONINFO,
	SET_INTERNAL_ERROR_MESSAGE,
	STOP_FURTHER_REQUESTS,
	SMARTCARD_AUTHENTICATED,
	SET_SESSION_INFORMATION,
	GET_ORIGINATING_WINDOW,
	GET_ORIGINATING_CORE_WINDOW,
	REPORT_LOAD_STATUS,
	ACTIVITY_REPORT,
	ACTIVITY_CONNECTION,
	NO_STATE
};

typedef enum MessageBoxType_enums
{
	MBT_ERROR,
	MBT_MESSAGE,
	MBT_OK_CANCEL,
	MBT_YES_NO_CANCEL,
	MBT_ASK_TEXT,
	MBT_OK_CANCEL_TEXT
} MessageBoxType;

#endif // !MODULES_HARDCORE_MH_MH_ENUM_H
