#!/usr/bin/perl

#### Toolbar ini merger ####
#
# Reads in a base toolbar file, then proceeds to merge/replace in sections 
# from other toolbar ini files.
#

package toolbar_ini;
use strict; 
use warnings;






sub new {
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $self  = {}; 

	# "private" members
	$self->{_SECTION_ORDER} = "";

    bless ($self, $class);

    return $self;
}

sub read {
    my $self = shift;
    my $filename = shift;

    if (! defined $self->{ini} ) {
        $self->{ini} = {}; 
    }

    my ($l, $currentstruct) = ("","");
    
    if (!open(FILE,$filename))
	{
	   	print "Toolbar ini for reading doesn't exist.\n";
    	die;
    }
    
    my $section_data = "";
    my $previous_section = "";
    my $full_previous_section = "";
    my $current_section = "";
    my $started = 0;
    
    while ($l = <FILE>) {
		# Check if this line is a [Section]
        if ($l =~ /^\[(.*)\]/) {
            $current_section = $1;
            # This started flag makes sure that the stuff at the top of
            # ini files is skipped as this screws up stuff
            $started = 1;
            
            # Check if any section data was collected.
            # If so then save the section data
            if ($section_data ne "")
            {
            	# Save the section data against the previously see section
                $self->{ini}->{$previous_section} = "[".$full_previous_section."]\n".$section_data;
                
				# Save the ordering data so the file looks the same as before
                $self->{_SECTION_ORDER} = $self->{_SECTION_ORDER}.$previous_section.",";
            
				# Reset the section data
            	$section_data = "";
            }
            
            $previous_section = lc($current_section);
        	$full_previous_section = $current_section;
        } else {
			# Skip comment lines
            next if $l =~ /^#/;

			# Collection all the lines of section data
			if ($started)
			{
				$section_data = $section_data.$l;
			}
        }	
    }
    
    # Add the last section
	if ($section_data ne "")
	{
		# Save the section data against the previously see section
		# Add an extra \n so this section has a gap after it
		$self->{ini}->{$previous_section} = "[".$full_previous_section."]\n".$section_data."\n";

		# Save the ordering data so the file looks the same as before
		$self->{_SECTION_ORDER} = $self->{_SECTION_ORDER}.$previous_section.",";
	}

    close(FILE);
}

## Writes the modified ini file to disk

sub write {
    my $self = shift;
    my $filename = shift;
    my @array = split(/,/,$self->{_SECTION_ORDER});

    if (!open(FILE, '>', $filename))
	{
	   	print "Cannot write to toolbar ini file.\n";
    	die;
    }
    
    # Dodgey add the text for the top of toolbar files :)
    print FILE "Opera Preferences version 2.1\n";
    print FILE "; Do not edit this file while Opera is running\n";
    print FILE "; This file is stored in UTF-8 encoding\n\n";

	foreach my $item (@array)
	{
        print FILE $self->{ini}->{$item};
	}

    close(FILE);
}

1; # so the require or use succeeds
