/* -*- Mode: c++; indent-tabs-mode: nil; c-file-style: "gnu" -*-
 *
 * Copyright (C) 1995-2002 Opera Software ASA.  All rights reserved.
 *
 * This file is part of the Opera web browser.  It may not be distributed
 * under any circumstances.
 */

#ifndef XSLT_TYPES_H
#define XSLT_TYPES_H

#ifdef XSLT_SUPPORT

enum XSLT_ElementType
  {
    XSLTE_UNSUPPORTED = -4,
    XSLTE_UNRECOGNIZED = -3,
    XSLTE_OTHER = -2,
    XSLTE_LITERAL_RESULT_TEXT_NODE = -1,

    XSLTE_APPLY_IMPORTS = 0,
    XSLTE_APPLY_TEMPLATES,
    XSLTE_ATTRIBUTE,
    XSLTE_ATTRIBUTE_SET,
    XSLTE_CALL_TEMPLATE,
    XSLTE_CHOOSE,
    XSLTE_COMMENT,
    XSLTE_COPY,
    XSLTE_COPY_OF,
    XSLTE_DECIMAL_FORMAT,
    XSLTE_ELEMENT,
    XSLTE_FALLBACK,
    XSLTE_FOR_EACH,
    XSLTE_IF,
    XSLTE_IMPORT,
    XSLTE_INCLUDE,
    XSLTE_KEY,
    XSLTE_MESSAGE,
    XSLTE_NAMESPACE_ALIAS,
    XSLTE_NUMBER,
    XSLTE_OTHERWISE,
    XSLTE_OUTPUT,
    XSLTE_PARAM,
    XSLTE_PRESERVE_SPACE,
    XSLTE_PROCESSING_INSTRUCTION,
    XSLTE_SORT,
    XSLTE_STRIP_SPACE,
    XSLTE_STYLESHEET,
    XSLTE_TEMPLATE,
    XSLTE_TEXT,
    XSLTE_TRANSFORM,
    XSLTE_VALUE_OF,
    XSLTE_VARIABLE,
    XSLTE_WHEN,
    XSLTE_WITH_PARAM,

    XSLTE_LAST
  };

enum XSLT_AttributeType
  {
    XSLTA_UNRECOGNIZED = -3,
    XSLTA_OTHER = -2,
    XSLTA_NO_MORE_ATTRIBUTES = -1,

    XSLTA_NAN = 0,
    XSLTA_CASE_ORDER,
    XSLTA_CDATA_SECTION_ELEMENTS,
#ifdef XSLT_COPY_TO_FILE_SUPPORT
    XSLTA_COPY_TO_FILE,
#endif // XSLT_COPY_TO_FILE_SUPPORT
    XSLTA_COUNT,
    XSLTA_DATA_TYPE,
    XSLTA_DECIMAL_SEPARATOR,
    XSLTA_DIGIT,
    XSLTA_DISABLE_OUTPUT_ESCAPING,
    XSLTA_DOCTYPE_PUBLIC,
    XSLTA_DOCTYPE_SYSTEM,
    XSLTA_ELEMENTS,
    XSLTA_ENCODING,
    XSLTA_EXCLUDE_RESULT_PREFIXES,
    XSLTA_EXTENSION_ELEMENT_PREFIXES,
    XSLTA_FORMAT,
    XSLTA_FROM,
    XSLTA_GROUPING_SEPARATOR,
    XSLTA_GROUPING_SIZE,
    XSLTA_HREF,
    XSLTA_ID,
    XSLTA_INDENT,
    XSLTA_INFINITY,
    XSLTA_LANG,
    XSLTA_LEVEL,
    XSLTA_MATCH,
    XSLTA_MEDIA_TYPE,
    XSLTA_METHOD,
    XSLTA_MINUS_SIGN,
    XSLTA_MODE,
    XSLTA_NAME,
    XSLTA_NAMESPACE,
    XSLTA_OMIT_XML_DECLARATION,
    XSLTA_ORDER,
    XSLTA_PATTERN_SEPARATOR,
    XSLTA_PER_MILLE, // sorted as in xslt_lexer.cpp
    XSLTA_PERCENT,
    XSLTA_PRIORITY,
    XSLTA_RESULT_PREFIX,
    XSLTA_SELECT,
    XSLTA_STANDALONE,
    XSLTA_STYLESHEET_PREFIX,
    XSLTA_TERMINATE,
    XSLTA_TEST,
    XSLTA_USE,
    XSLTA_USE_ATTRIBUTE_SET,
    XSLTA_VALUE,
    XSLTA_VERSION,
    XSLTA_ZERO_DIGIT,

    XSLTA_LAST
  };

class XSLT_Error
{
public:
  enum Code
    {
      ATTRIBUTE_AFTER_CHILD
    };
};

enum XSLT_StylesheetVersion
  {
    XSLT_VERSION_NONE,
    XSLT_VERSION_1_0,
    XSLT_VERSION_FUTURE
  };

enum XSLT_OutputMethod
  {
    XSLT_OUTPUT_DEFAULT,
    XSLT_OUTPUT_XML,
    XSLT_OUTPUT_HTML,
    XSLT_OUTPUT_TEXT
  };

#endif // XSLT_SUPPORT
#endif // XSLT_TYPES_H
