# -*- coding: iso-8859-1 -*-

import re
import string
import sys
import os
import time
from StringIO import StringIO

# The file downloaded from: http://www.loc.gov/standards/iso639-2/ISO-639-2_8859-1.txt
iso639_table_path = "ISO-639-2_8859-1.txt"

conversions_inc_path = "../language_code_conversions.inc"
selftest_path = "../language_code_conversions.ot"

def fatal(msg):
    print >>sys.stderr, msg
    time.sleep(1)
    sys.exit(1)

class ISO639_2_MappingGenerator:
	def __init__(self):
		self.__mapping = []
		return

	def read_iso639_table(self):
		try:
			input = open(iso639_table_path, "r")
		except:
			fatal("Can't open \"%s\" for reading." % iso639_table_path)

		for line in input:
			tokens = string.split(line, '|')
			if len(tokens) != 5:
				fatal("Corrupted line in \"%s\": \"%s\"." % (iso639_table_path, line))
			
			if tokens[0] == "(none)":
				continue
				
			#print("tokens: |%s|%s|%s|" % (tokens[3], tokens[0], tokens[2]))
			self.__mapping.append([tokens[3], tokens[0], tokens[2]])
			
		input.close()

	def generate_mapping(self):

		try:
			output = open(conversions_inc_path, "w")
		except:
			fatal("Can't open \"%s\" for writing." % output_path)

		map = {}
		print >> output, "/* This file is autogenerated using generate_iso639-2_conversions.py script */"
		print >> output, ""
		print >> output, "#define STR2INT16(x,y) (((x) << 8) | (y))"
		print >> output, ""
		print >> output, "OP_STATUS LanguageCodeUtils::Convert2To3LetterCode(OpString8* output, const char* two_letter_code)"

		print >> output, "{"
		print >> output, "\tOP_ASSERT(output);"
		print >> output, "\tconst char* three_letter_code = NULL;"
		print >> output, "\tswitch(STR2INT16(op_tolower((unsigned char) two_letter_code[0]),op_tolower((unsigned char) two_letter_code[1])))"
		print >> output, "\t{"

		for i in range(0, len(self.__mapping)):
			iso_639_1_code 	= self.__mapping[i][2]
			iso_639_2_code 	= self.__mapping[i][1]
			all_lang_names 	= self.__mapping[i][0]
			if iso_639_2_code in map:
				print ("Remove duplicate mapping in line %i for the code: %s" % (i+10, iso_639_2_code))
			map[iso_639_2_code] = 1;
			if iso_639_1_code == "":
				continue;
			print >> output, "\tcase STR2INT16('%s', '%s'): three_letter_code = \"%s\"; break;" % (iso_639_1_code[0], iso_639_1_code[1], iso_639_2_code[0:3])

		print >> output, "\tdefault: return OpStatus::ERR;"
		print >> output, "\t}"
		print >> output, "\treturn output->Set(three_letter_code);"
		print >> output, "}"
		print >> output, "#undef STR2INT16"
		print >> output, ""

	def generate_selftest(self):

		try:
			output = open(selftest_path, "w")
		except:
			fatal("Can't open \"%s\" for writing." % output_path)

		print >> output, "group \"util.language_code_conversions\";"
		print >> output, ""

		print >> output, "language c++;"
		print >> output, ""

		print >> output, "include \"modules/util/language_codes.h\";"
		print >> output, ""

		print >> output, "test(\"Test language code conversion\")"
		print >> output, "{"
		print >> output, "    OpString three_letter_code;"
		print >> output, "    OP_STATUS error;"

		for i in range(0, len(self.__mapping)):
			iso_639_1_code 	= self.__mapping[i][2]
			iso_639_2_code 	= self.__mapping[i][1]

			print >> output, "    three_letter_code.Empty();"
			if iso_639_1_code == "":
				print >> output, "    error = LanguageCodeUtils::ConvertTo3LetterCode(&three_letter_code, UNI_L(\"%s\"));" % iso_639_2_code
			else:
				print >> output, "    error = LanguageCodeUtils::ConvertTo3LetterCode(&three_letter_code, UNI_L(\"%s\"));" % iso_639_1_code

			print >> output, "    verify(OpStatus::IsSuccess(error));"
			print >> output, "    verify(uni_str_eq(three_letter_code.CStr(), UNI_L(\"%s\")));" % iso_639_2_code[0:3] # some languages have 2 alternative 3letter codes - we only use the first one
			print >> output, ""

		print >> output, "}"


generator = ISO639_2_MappingGenerator()
generator.read_iso639_table()
generator.generate_mapping()
#generator.generate_selftest() # Modify the selftest by hand
