/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 2011-2012 Opera Software ASA.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

#ifndef __OP_GENERATED_RESPONSE_H__
#define __OP_GENERATED_RESPONSE_H__

#include "modules/formats/hdsplit.h"
#include "modules/network/src/op_response_impl.h"
#include "modules/url/url2.h"

/** @class OpGeneratedResponse
 *
 *  OpGeneratedResponse is used for creating a custom generated OpResponse.
 *  Usage:
 *
 *  @code
 *  OpGeneratedResponse *response = NULL;
 *  request->GenerateResponse(response);
 *  response->SetGeneratedByOpera(TRUE);
 *  response->WriteDocumentDataUniSprintf(UNI_L("Test"));
 *  response->WriteDocumentDataFinished();
 *  @endcode
 *
 */

class OpGeneratedResponse: public OpResponseImpl
{
public:
	OpGeneratedResponse(OpURL url) : OpResponseImpl(url) {}

	virtual ~OpGeneratedResponse() {}

	/** Set the content generated by Opera. */
	virtual OP_STATUS SetGeneratedByOpera(BOOL value) = 0;

	/** Set cache policy to no-store. */
	virtual OP_STATUS SetCachePolicyNoStore(BOOL value) = 0;

	/** Set cache policy to always verify. */
	virtual OP_STATUS SetCachePolicyAlwaysVerify(BOOL value) = 0;

	/** Set cache policy to must revalidate. */
	virtual OP_STATUS SetCachePolicyMustRevalidate(BOOL value) = 0;

	/** Force the MIME-type to this. */
	virtual OP_STATUS ForceMIMEContentType(const OpStringC8 &value) = 0;

	/** Set the X-Frame-Options header. */
	virtual OP_STATUS SetHTTPFrameOptions(const OpStringC8 &value) = 0;

	/**	Write the specified formatted string and parameters to the document of this URL.
	 *
	 *  @param	format		sprintf type format string.
	 *  @param	...			Parameters specified by the format string.
	 */
	virtual OP_STATUS WriteDocumentDataUniSprintf(const uni_char *format, ...) = 0;

#ifdef NEED_URL_WRITE_DOC_IMAGE
	/** Write a binary file with the given content type into this document.
	 *
	 *  NOTE: This function is only compiled in for some platforms.
	 *
	 *  @param	ctype	Content type to set.
	 *  @param	data	pointer to the binary data.
	 *  @param	len		length of data string (in characters).
	 *  @return OP_STATUS
	 */
	virtual OP_STATUS WriteDocumentImage(const char * ctype, const char * data, int size) = 0;
#endif // NEED_URL_WRITE_DOC_IMAGE

	/** Write the specified buffer to the document of this URL
	 *  If specified the source is XML- or HTMLified first.
	 *
	 *  @param	conversion	How to preprocess the input (no action/HTMify, XMLify).
	 *  @param	data	pointer to the data NULL terminations are ignored.
	 *  @param	len		length of data string (in characters).
	 */
	virtual OP_STATUS WriteDocumentData(URL::URL_WriteDocumentConversion conversion, const OpStringC &data, unsigned int len= (unsigned int) KAll) = 0;

	/** Write the specified buffer to the document of this URL.
	 *  If specified the source is XML- or HTMLified first.
	 *
	 *  @param	conversion	How to preprocess the input (no action/HTMify, XMLify).
	 *  @param	data		pointer to the data NULL terminations are ignored.
	 *  @param	len			length of data string (in characters).
	 */
	virtual OP_STATUS WriteDocumentData(URL::URL_WriteDocumentConversion conversion, const OpStringC8 &data, unsigned int len= (unsigned int) KAll) = 0;

	/** Write data from the specified datadescriptor to the document of this URL.
	 *  If specified the source is XML- or HTMLified.
	 *  For HMTL/XMLifying the content is assumed to the UTF-16 encoded.
	 *
	 *  @param	conversion	How to preprocess the input (no action/HTMify, XMLify).
	 *  @param	src			Datadescriptor source.
	 *  @param	len			Number of bytes to read from the source, 0 means read everything that is available.
	 */
	virtual OP_STATUS WriteDocumentData(URL::URL_WriteDocumentConversion conversion, URL_DataDescriptor *data, unsigned int len= (unsigned int) KAll) = 0;

	/** Close the document. */
	virtual void WriteDocumentDataFinished() = 0;

#ifdef _MIME_SUPPORT_
	/** MIME body comment string.  */
	virtual OP_STATUS GetBodyCommentString(OpString &value) const = 0;
	virtual OP_STATUS SetBodyCommentString(OpString &value) = 0;

	/** MIME decode presentation uses big attachment icon. */
	virtual OP_STATUS SetBigAttachmentIcons(BOOL value) = 0;

	/** Use the  plain text version of the document if it is available. */
	virtual OP_STATUS SetPreferPlaintext(BOOL value) = 0;

	/** Ignore warnings from the decoding of the document (e-mail specific). */
	virtual OP_STATUS SetIgnoreWarnings(BOOL value) = 0;
#endif
};

#endif
