/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; c-file-style: "stroustrup" -*-
 *
 * Copyright (C) Opera Software ASA  2002 - 2011
 *
 * Table of instruction names.
 *
 * @author modules/ecmascript/carakan/src/scripts/es_instruction_string.h.py
 */

#ifndef ES_INSTRUCTION_STRING_H
#define ES_INSTRUCTION_STRING_H
# if defined(ES_DISASSEMBLER_SUPPORT) || defined(ES_BYTECODE_LOGGER) || defined(ES_SLOW_CASE_PROFILING)

const char *const g_instruction_strings[] =
{
    "LOAD_STRING",
    "LOAD_DOUBLE",
    "LOAD_INT32",
    "LOAD_NULL",
    "LOAD_UNDEFINED",
    "LOAD_TRUE",
    "LOAD_FALSE",
    "LOAD_GLOBAL_OBJECT",
    "COPY",
    "COPYN",
    "TYPEOF",
    "TONUMBER",
    "TOOBJECT",
    "TOPRIMITIVE",
    "TOPRIMITIVE1",
    "IS_NULL_OR_UNDEFINED",
    "IS_NOT_NULL_OR_UNDEFINED",
    "ADD",
    "ADD_IMM",
#ifdef ES_COMBINED_ADD_SUPPORT
    "ADDN",
#endif
    "FORMAT_STRING",
    "SUB",
    "SUB_IMM",
    "MUL",
    "MUL_IMM",
    "DIV",
    "DIV_IMM",
    "REM",
    "REM_IMM",
    "LSHIFT",
    "LSHIFT_IMM",
    "RSHIFT_SIGNED",
    "RSHIFT_SIGNED_IMM",
    "RSHIFT_UNSIGNED",
    "RSHIFT_UNSIGNED_IMM",
    "NEG",
    "COMPL",
    "INC",
    "DEC",
    "BITAND",
    "BITAND_IMM",
    "BITOR",
    "BITOR_IMM",
    "BITXOR",
    "BITXOR_IMM",
    "NOT",
    "EQ",
    "EQ_IMM",
    "NEQ",
    "NEQ_IMM",
    "EQ_STRICT",
    "EQ_STRICT_IMM",
    "NEQ_STRICT",
    "NEQ_STRICT_IMM",
    "LT",
    "LT_IMM",
    "LTE",
    "LTE_IMM",
    "GT",
    "GT_IMM",
    "GTE",
    "GTE_IMM",
    "CONDITION",
    "JUMP",
    "JUMP_INDIRECT",
    "JUMP_IF_TRUE",
    "JUMP_IF_FALSE",
    "START_LOOP",
    "STORE_BOOLEAN",
    "GETN_IMM",
    "PUTN_IMM",
    "INIT_PROPERTY",
    "GET_LENGTH",
    "PUT_LENGTH",
    "GETI_IMM",
    "PUTI_IMM",
    "GET",
    "PUT",
    "DEFINE_GETTER",
    "DEFINE_SETTER",
    "GET_SCOPE",
    "GET_SCOPE_REF",
    "PUT_SCOPE",
    "DELETE_SCOPE",
    "GET_GLOBAL",
    "PUT_GLOBAL",
    "GET_LEXICAL",
    "PUT_LEXICAL",
    "DELETEN_IMM",
    "DELETEI_IMM",
    "DELETE",
    "DECLARE_GLOBAL",
    "HASPROPERTY",
    "INSTANCEOF",
    "ENUMERATE",
    "NEXT_PROPERTY",
    "EVAL",
    "CALL",
    "REDIRECTED_CALL",
    "APPLY",
    "CONSTRUCT",
    "RETURN_VALUE",
    "RETURN_NO_VALUE",
    "RETURN_FROM_EVAL",
    "NEW_OBJECT",
    "CONSTRUCT_OBJECT",
    "NEW_ARRAY",
    "CONSTRUCT_ARRAY",
    "NEW_FUNCTION",
    "NEW_REGEXP",
    "TABLE_SWITCH",
    "CATCH",
    "CATCH_SCOPE",
    "THROW",
    "THROW_BUILTIN",
    "RETHROW",
    "EXIT",
    "EXIT_TO_BUILTIN",
    "EXIT_TO_EVAL",
#ifdef ECMASCRIPT_DEBUGGER
    "DEBUGGER_STOP",
#endif
    "LAST_INSTRUCTION"
};

# endif // ES_DISASSEMBLER_SUPPORT || ES_BYTECODE_LOGGER || ES_SLOW_CASE_PROFILING
#endif // ES_INSTRUCTION_STRING_H
