@echo off
:: Copyright (C)2013 Nintendo Co., Ltd.  All rights reserved.
:: 
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.

:: ---------------------------------------------------------------------------
::
:: Setup development environments and launch command prompt.
::
:: ---------------------------------------------------------------------------
setlocal

:: ----------------------------------------------------------------------------
::  Move to this script's directory.
:: ----------------------------------------------------------------------------
%~d0
cd %~p0

call Integrate\Scripts\Setup-SigloShellEnvironment.cmd

:: ----------------------------------------------------------------------------
::  Launch shell.
:: ----------------------------------------------------------------------------
:run_shell
if defined SIGLO_USE_MSYS         goto run_shell_msys
if exist "%SIGLO_CYGWIN_PATH%"    goto run_shell_cygwin

:run_shell_msys
if exist "%SIGLO_MSYS_PATH%"      goto run_shell_msys_bash

:run_shell_cmd
cmd.exe /k
goto exit

:run_shell_cygwin
if exist "%SIGLO_CYGWIN_PATH%\bin\zsh.exe" (
    for /f "delims=" %%a in ('%SIGLO_CYGWIN_PATH%\bin\cygpath -u %~dp0Integrate\Resources\Scripts\Zsh') do set ZDOTDIR=%%a
    SET SIGLO_CYGWIN_SHELL=zsh
) else (
    SET SIGLO_CYGWIN_SHELL=bash
)

if exist "%SIGLO_CONEMU_PATH%" (
    "%SIGLO_CONEMU_PATH%" /cmd "%SIGLO_CYGWIN_PATH%bin\%SIGLO_CYGWIN_SHELL%" -i %*
) else if exist "%SIGLO_CYGWIN_PATH%\bin\mintty.exe" (
    %SIGLO_CYGWIN_PATH%bin\mintty -e /bin/%SIGLO_CYGWIN_SHELL% -i %*
) else (
    %SIGLO_CYGWIN_PATH%bin\%SIGLO_CYGWIN_SHELL% --login -i %*
)
goto exit

:run_shell_msys_bash
if exist "%SIGLO_CONEMU_PATH%" (
    "%SIGLO_CONEMU_PATH%" /cmd "%SIGLO_MSYS_PATH%bin\sh" --init-file /etc/profile -i %*
) else (
    "%SIGLO_MSYS_PATH%bin\sh" --init-file /etc/profile -i %*
)
goto exit

:exit
rem pause
endlocal
