:: ---------------------------------------------------------------------------
:: Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off

:: ---------------------------------------------------------------------------
::
:: Setup development environments.
::
:: It is preferable to execute this script every checkout of the revision.
::
:: ---------------------------------------------------------------------------

:: ----------------------------------------------------------------------------
::  Move to this script's directory.
:: ----------------------------------------------------------------------------
%~d0
cd %~p0

:: ----------------------------------------------------------------------------
::  Setup git environments.
:: ----------------------------------------------------------------------------
call "%~dp0setupGit.cmd"

if not %ERRORLEVEL% == 0 (
    echo ERROR: fail to setup git settings. 1>&2
    goto error
)

:: ---------------------------------------------------------------------------
:: Setup Siglo common git hook scripts.
:: ---------------------------------------------------------------------------
call "%REPOSITORY_ROOT%Integrate\Repository\HookScripts\Common\setup.cmd"

if not %ERRORLEVEL% == 0 (
    echo ERROR: fail to setup Siglo common git hook scripts. 1>&2
    goto error
)

:: ---------------------------------------------------------------------------
:: Setup CodingChecker.
:: ---------------------------------------------------------------------------
call "%REPOSITORY_ROOT%Integrate\Sources\Tools\CodingChecker\setup.cmd"

if not %ERRORLEVEL% == 0 (
    echo ERROR: fail to setup CodingChecker. 1>&2
    goto error
)

:: ---------------------------------------------------------------------------
:: Setup git hook scripts for cpplint.
:: ---------------------------------------------------------------------------
call "%REPOSITORY_ROOT%Integrate\Repository\HookScripts\CppLint\setup.cmd"

if not %ERRORLEVEL% == 0 (
    echo ERROR: fail to setup git hook scripts for cpplint. 1>&2
    goto error
)

:: ---------------------------------------------------------------------------
:: Check .git/config settings.
:: ---------------------------------------------------------------------------
echo Check .git/config settings.

:: get attributes
FOR /F %%a IN ('git config --get exrepo-m.attributes') DO set "EXREPO_M_CONFIG_ATTRIBUTES=%%a"

if not defined EXREPO_M_CONFIG_ATTRIBUTES (
    echo;
    echo *********************************** Warning ***********************************
    echo;
    echo 'exrepo-m.attributes' in .git/config is empty. Please see the following link and configure settings.
    echo;
    echo http://spdlybra.nintendo.co.jp/confluence/pages/viewpage.action?pageId=90891305
    echo;
    echo *******************************************************************************
    echo;
    pause
) else (
    set EXREPO_M_CONFIG_ATTRIBUTES=
)

:: ---------------------------------------------------------------------------
:: Register Oasis registry key for SDK developers
:: ---------------------------------------------------------------------------
reg IMPORT Externals\Oasis\Installer\Scripts\OasisKeyForSdkDeveloper.reg 2>nul
if not %ERRORLEVEL% == 0 (
    echo ERROR: failed to register Oasis key into registry
    goto error
)

:: ---------------------------------------------------------------------------
:: Register Oasis analytics registry key for SDK developers
:: ---------------------------------------------------------------------------
reg IMPORT Externals\Oasis\Installer\Scripts\EnableOasisAnalytics.reg 2>nul
if not %ERRORLEVEL% == 0 (
    echo ERROR: failed to register Oasis analytics key into registry
    goto error
)

:: ---------------------------------------------------------------------------
:: Register Oasis analytics registry key for SDK developers
:: ---------------------------------------------------------------------------
reg IMPORT Externals\Oasis\Installer\Scripts\RegisterGroupId.reg 2>nul
if not %ERRORLEVEL% == 0 (
    echo ERROR: failed to register Group ID
    goto error
)

goto exit

:exit
rem pause
exit /B 0

:error
pause
exit /B 1
