﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*

// BEGIN__HARVEST_EXCEPTION_ZSTRING

<javascriptresource>
<name>Nintendo Select Negative Z Normal</name>
<menu>automate</menu>
<type>automate</type>
<enableinfo>in (PSHOP_ImageMode, RGBMode)</enableinfo>
<eventid>5956062E-0EB0-461e-BD2D-192DADC8DCAA</eventid>
<category>Nintendo</category>
</javascriptresource>

// END__HARVEST_EXCEPTION_ZSTRING

*/

#strict on
#target photoshop

#include "./NintendoExportTextureFunc.jsxinc"

//-----------------------------------------------------------------------------
//! @brief 法線の Z 成分がマイナスになっているピクセルを選択します。
//!        アクティブなレイヤーが対象です。
//!
//! @param[in] doc ドキュメントです。
//-----------------------------------------------------------------------------
function SelectNegativeZNormal(doc)
{
	//-----------------------------------------------------------------------------
	// ブルーチャンネルを新規アルファチャンネルにコピーします。
	doc.activeChannels = [ doc.componentChannels[2] ];
	if (doc.activeLayer.isBackgroundLayer)
	{
		doc.selection.selectAll();
	}
	else
	{
		SelectLayerBounds(doc, doc.activeLayer);
	}
	doc.selection.copy(false);
	var zChan = doc.channels.add();
	doc.paste(true);

	//-----------------------------------------------------------------------------
	// 新規アルファチャンネルをしきい値 128 で 2 階調化して選択範囲に変換します。
	doc.activeLayer.threshold(128);
	var isFound = (zChan.histogram[0] != 0);
		// 輝度 0 のピクセル数が 0 でなければ Z 成分が 127 以下のピクセルが存在しています。
	if (isFound)
	{
		doc.selection.load(zChan, SelectionType.REPLACE, true);
			// Z 成分が 127 以下のピクセルを選択するため
			// 第 3 引数 inverting を true にして選択範囲を反転します。
	}
	else
	{
		doc.selection.deselect();
	}

	//-----------------------------------------------------------------------------
	// 新規アルファチャンネルを削除します。
	doc.activeChannels = doc.componentChannels;
	zChan.remove();

	//-----------------------------------------------------------------------------
	// すべての Z 成分が 128 以上ならメッセージを表示します。
	if (!isFound)
	{
		alert("All pixels have positive Z", "Nintendo Select Negative Z Normal");
	}
}

//-----------------------------------------------------------------------------
//! @brief メイン関数です。
//-----------------------------------------------------------------------------
function main()
{
	//-----------------------------------------------------------------------------
	// bring to front
	app.bringToFront(); // CS2-

	//-----------------------------------------------------------------------------
	// get document
	if (app.documents.length == 0)
	{
		alert("Please open a file");
		return;
	}
	var doc = app.activeDocument;

	//-----------------------------------------------------------------------------
	// check image mode
	if (doc.mode != DocumentMode.RGB)
	{
		ShowError("Image mode is not RGB color");
		return;
	}

	//-----------------------------------------------------------------------------
	// test
	//alert(doc.activeLayer.bounds);
	//return;

	//-----------------------------------------------------------------------------
	// 非表示または完全に透明なレイヤーなら処理しません。
	if (!doc.activeLayer.visible)
	{
		ShowError("The active layer is not visible");
		return;
	}
	if (doc.activeLayer.bounds[0] == doc.activeLayer.bounds[2] &&
		doc.activeLayer.bounds[1] == doc.activeLayer.bounds[3])
	{
		ShowError("The active layer is completely transparent");
		return;
	}

	//-----------------------------------------------------------------------------
	// 法線の Z 成分がマイナスになっているピクセルを選択します。
	//SelectNegativeZNormal(doc);
	doc.suspendHistory("NintendoSelectNegativeZNormal", "SelectNegativeZNormal(doc)");
}

// 定規の単位を pixels にして main を呼びます。
CallFunctionUnitsPixels(main);

