﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*

// BEGIN__HARVEST_EXCEPTION_ZSTRING

<javascriptresource>
<name>Nintendo Export Texture Settings...</name>
<menu>automate</menu>
<type>automate</type>
<enableinfo>in (PSHOP_ImageMode, GrayScaleMode, IndexedMode, RGBMode, CMYKMode, Gray32Mode, RGB96Mode)</enableinfo>
<eventid>B0D674DD-6F56-4DFC-8FFC-320D367A781D</eventid>
<category>Nintendo</category>
</javascriptresource>

// END__HARVEST_EXCEPTION_ZSTRING

*/

#strict on
#target photoshop

#include "./NintendoExportTextureFunc.jsxinc"

//-----------------------------------------------------------------------------
//! @brief メイン関数です。
//-----------------------------------------------------------------------------
function main()
{
	//-----------------------------------------------------------------------------
	// bring to front
	app.bringToFront(); // CS2-

	//-----------------------------------------------------------------------------
	// test
	//alert($.version); // 3.7.69 (CS3), 3.92.114 (CS4), 4.1.26 (CS5)
	//alert(app.version); // 10.0.1 (CS3), 11.0.2 (CS4), 12.0.4 (CS5)
	//var a = [3,5,7];
	//DumpProperties(a);
	//DumpMethods(f);
	//DumpArray(a);
	//DumpXml(reflect.toXML(app.activeDocument));
	//alert(app.activeDocument.info.keywords.length);
	//DumpArray(app.activeDocument.info.supplementalCategories);
	//DumpArray(app.fonts); // フォント一覧
	//app.activeDocument.info.keywords = ["a=1", "b=3"];
	//app.activeDocument.info.supplementalCategories = ["foo", "bar"];
	//app.activeDocument.info.copyrightNotice = "noticeA"; // 著作権情報
	//app.activeDocument.info.ownerUrl = "urlA"; // 著作権情報 URL
	//return;

	//-----------------------------------------------------------------------------
	// get document
	if (app.documents.length == 0)
	{
		alert("Please open a PSD document to export");
		return;
	}
	var doc = app.activeDocument;
	if (doc.name.GetExtensionFromFilePath() != "psd")
	{
		alert("Please open a PSD document to export");
		return;
	}

	//-----------------------------------------------------------------------------
	// オプション設定をドキュメントからロードします。
	var opts = new Object();
	var valid = LoadSettings(opts, doc);
	//alert("valid opt: " + valid);

	//-----------------------------------------------------------------------------
	// オプション設定ダイアログを表示します。
	if (DoDialog(opts, doc))
	{
		SaveSettings(doc, opts);
	}
}

// 定規の単位を pixels にして main を呼びます。
CallFunctionUnitsPixels(main);

