﻿/// <header>
///   <version>0.0.0</version>
/// </header>

/// <tag name="LayoutMath">
///   <func id="NormalizeWithVec2"/>
/// </tag>
/// <func id="NormalizeWithVec2" name="NormalizeWithVec2">
///   <in name="v" type="vec2"/>
///   <return type="vec2"/>
///   <description>ベクトル v の正規化を行います。但し、長さ == 0 の場合にゼロベクターを返します。</description>
/// </func>
/// <block guid="{F975EE9A-C575-4092-ACEF-F032E2AD48D8}" displayname="NormalizeWithVec2">
///   <func id="NormalizeWithVec2"/>
///   <out displayname="return" type="vec2" target="return"/>
///   <in displayname="v" type="vec2" target="v"/>
/// </block>
/// <code funcid="NormalizeWithVec2">
vec2 NormalizeWithVec2( vec2 v )
{
    float len = length(v);
    if (len == 0.0)
    {
        return vec2(0.0);
    }
    else
    {
        return v / len;
    }
}
/// </code>

/// <tag name="LayoutMath">
///   <func id="NormalizeWithVec3"/>
/// </tag>
/// <func id="NormalizeWithVec3" name="NormalizeWithVec3">
///   <in name="v" type="vec3"/>
///   <return type="vec3"/>
///   <description>ベクトル v の正規化を行います、長さ == 0 の場合にゼロベクターを返します。</description>
/// </func>
/// <block guid="{5FD7674C-6DEA-4432-A996-DC4704C52705}" displayname="NormalizeWithVec3">
///   <func id="NormalizeWithVec3"/>
///   <out displayname="return" type="vec3" target="return"/>
///   <in displayname="v" type="vec3" target="v"/>
/// </block>
/// <code funcid="NormalizeWithVec3">
vec3 NormalizeWithVec3( vec3 v )
{
    float len = length(v);
    if (len == 0.0)
    {
        return vec3(0.0);
    }
    else
    {
        return v / len;
    }
}
/// </code>

