﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#version 440

layout( location = 0 ) in Raster
{
    vec3 pos_w;
    vec3 normal;
    vec3 normal_w;
    vec3 tangent_w;
    vec3 binormal_w;
    vec3 eye2pos_w;
    vec4 color;
    vec4 uv;
    vec4 projection;
} IN;

layout( location = 0 ) out vec4 o_Color;


uniform sampler2D _a0;
#define nwAlbedoTexture0 _a0


layout( std140, binding = 3 ) uniform Material
{
    vec4 offset;
};

void main()
{
    o_Color.r = max( IN.normal_w.y, 0.2 );
    o_Color.g = max( IN.normal_w.y, 0.2 );
    o_Color.b = max( IN.normal_w.y, 0.2 );
    o_Color.a = 1;
    vec4 texture = texture( nwAlbedoTexture0, IN.uv.xy );
    o_Color.rgb *= texture.rgb;
}
