﻿/// <header>
///   <version>0.0.0</version>
///   <options>
///     <option name="CodeOutputCondition" value="Always"/>
///   </options>
/// </header>

/// <code output_condtion="Always">
#define LINEAR_STEP( minValue, maxValue, x ) ( clamp( (x), (minValue), (maxValue) ) - (minValue) ) / ( (maxValue) - (minValue) )
/// </code>

/// <tag name="Math">
///   <func id="GetLinearStepF4"/>
/// </tag>
/// <func id="GetLinearStepF4" name="GetLinearStepF4">
///   <in name="minValue" type="vec4"/>
///   <in name="maxValue" type="vec4"/>
///   <in name="x" type="vec4"/>
///   <return type="vec4"/>
///   <description>[非推奨]線形Step処理を行います</description>
/// </func>
/// <block guid="{E39119E8-44E6-4033-9329-FBEE1F7BDD5B}" displayname="[deprecated]LinearStepF4">
///   <func id="GetLinearStepF4"/>
///   <out displayname="return" type="vec4" target="return"/>
///   <in displayname="min" type="vec4" target="minValue"/>
///   <in displayname="max" type="vec4" target="maxValue"/>
///   <in displayname="x" type="vec4" target="x"/>
/// </block>
/// <code funcid="GetLinearStepF4">
vec4 GetLinearStepF4( vec4 minValue, vec4 maxValue, vec4 x )
{
  vec4 v;
  v.x = LINEAR_STEP( minValue.x, maxValue.x, x.x );
  v.y = LINEAR_STEP( minValue.y, maxValue.y, x.y );
  v.z = LINEAR_STEP( minValue.z, maxValue.z, x.z );
  v.w = LINEAR_STEP( minValue.w, maxValue.w, x.w );
  return v;
}
/// </code>

/// <tag name="Math">
///   <func id="GetLinearStepF3"/>
/// </tag>
/// <func id="GetLinearStepF3" name="GetLinearStepF3">
///   <in name="minValue" type="vec3"/>
///   <in name="maxValue" type="vec3"/>
///   <in name="x" type="vec3"/>
///   <return type="vec3"/>
///   <description>[非推奨]線形Step処理を行います</description>
/// </func>
/// <block guid="{29764B10-5377-4F5F-A4D3-5AA21157094A}" displayname="[deprecated]LinearStepF3">
///   <func id="GetLinearStepF3"/>
///   <out displayname="return" type="vec3" target="return"/>
///   <in displayname="min" type="vec3" target="minValue"/>
///   <in displayname="max" type="vec3" target="maxValue"/>
///   <in displayname="x" type="vec3" target="x"/>
/// </block>
/// <code funcid="GetLinearStepF3">
vec3 GetLinearStepF3( vec3 minValue, vec3 maxValue, vec3 x )
{
  vec3 v;
  v.x = LINEAR_STEP( minValue.x, maxValue.x, x.x );
  v.y = LINEAR_STEP( minValue.y, maxValue.y, x.y );
  v.z = LINEAR_STEP( minValue.z, maxValue.z, x.z );
  return v;
}
/// </code>

/// <tag name="Math">
///   <func id="GetLinearStepF2"/>
/// </tag>
/// <func id="GetLinearStepF2" name="GetLinearStepF2">
///   <in name="minValue" type="vec2"/>
///   <in name="maxValue" type="vec2"/>
///   <in name="x" type="vec2"/>
///   <return type="vec2"/>
///   <description>[非推奨]線形Step処理を行います</description>
/// </func>
/// <block guid="{8AEDC3C1-C136-4368-B14E-502D85ABB3A5}" displayname="[deprecated]LinearStepF2">
///   <func id="GetLinearStepF2"/>
///   <out displayname="return" type="vec2" target="return"/>
///   <in displayname="min" type="vec2" target="minValue"/>
///   <in displayname="max" type="vec2" target="maxValue"/>
///   <in displayname="x" type="vec2" target="x"/>
/// </block>
/// <code funcid="GetLinearStepF2">
vec2 GetLinearStepF2( vec2 minValue, vec2 maxValue, vec2 x )
{
  vec2 v;
  v.x = LINEAR_STEP( minValue.x, maxValue.x, x.x );
  v.y = LINEAR_STEP( minValue.y, maxValue.y, x.y );
  return v;
}
/// </code>

/// <tag name="Math">
///   <func id="GetLinearStepF"/>
/// </tag>
/// <func id="GetLinearStepF" name="GetLinearStepF">
///   <in name="minValue" type="float"/>
///   <in name="maxValue" type="float"/>
///   <in name="x" type="float"/>
///   <return type="float"/>
///   <description>[非推奨]線形Step処理を行います</description>
/// </func>
/// <block guid="{02D09A4C-7FBF-4003-933B-A98C5E6E54BE}" displayname="[deprecated]LinearStepF">
///   <func id="GetLinearStepF"/>
///   <out displayname="return" type="float" target="return"/>
///   <in displayname="min" type="float" target="minValue"/>
///   <in displayname="max" type="float" target="maxValue"/>
///   <in displayname="x" type="float" target="x"/>
/// </block>
/// <code funcid="GetLinearStepF">
float GetLinearStepF( float minValue, float maxValue, float x )
{
  return LINEAR_STEP( minValue, maxValue, x );
}
/// </code>

/// <tag name="Math">
///   <func id="MinusF4"/>
/// </tag>
/// <func id="MinusF4" name="MinusF4">
///   <in name="value" type="vec4"/>
///   <return type="vec4"/>
///   <description>[非推奨]入力を符号反転（vec4）</description>
/// </func>
/// <block guid="{48954685-4DFD-4F97-95E6-160A94754A9F}" displayname="[deprecated]MinusF4">
///   <func id="MinusF4"/>
///   <out displayname="-vec4" type="vec4" target="return"/>
///   <in displayname="vec4" type="vec4" target="value"/>
/// </block>
/// <code funcid="MinusF4">
vec4 MinusF4( vec4 value )
{
  return -value;
}
/// </code>

/// <tag name="Math">
///   <func id="MinusF3"/>
/// </tag>
/// <func id="MinusF3" name="MinusF3">
///   <in name="value" type="vec3"/>
///   <return type="vec3"/>
///   <description>[非推奨]入力を符号反転（vec3）</description>
/// </func>
/// <block guid="{48954685-4DFD-4F96-85E5-160A94754A9F}" displayname="[deprecated]MinusF3">
///   <func id="MinusF3"/>
///   <out displayname="-vec3" type="vec3" target="return"/>
///   <in displayname="vec3" type="vec3" target="value"/>
/// </block>
/// <code funcid="MinusF3">
vec3 MinusF3( vec3 value )
{
  return -value;
}
/// </code>

/// <tag name="Math">
///   <func id="MinusF2"/>
/// </tag>
/// <func id="MinusF2" name="MinusF2">
///   <in name="value" type="vec2"/>
///   <return type="vec2"/>
///   <description>[非推奨]入力を符号反転（vec2）</description>
/// </func>
/// <block guid="{48943685-4DFD-4e96-85E5-160A94754A9F}" displayname="[deprecated]MinusF2">
///   <func id="MinusF2"/>
///   <out displayname="-vec2" type="vec2" target="return"/>
///   <in displayname="vec2" type="vec2" target="value"/>
/// </block>
/// <code funcid="MinusF2">
vec2 MinusF2( vec2 value )
{
  return -value;
}
/// </code>

/// <tag name="Math">
///   <func id="MinusF"/>
/// </tag>
/// <func id="MinusF" name="MinusF">
///   <in name="value" type="float"/>
///   <return type="float"/>
///   <description>[非推奨]入力を符号反転（float）</description>
/// </func>
/// <block guid="{48943685-4DFD-4e96-85E5-150A93754A9F}" displayname="[deprecated]MinusF">
///   <func id="MinusF"/>
///   <out displayname="-x" type="float" target="return"/>
///   <in displayname="x" type="float" target="value"/>
/// </block>
/// <code funcid="MinusF">
float MinusF( float value )
{
  return -value;
}
/// </code>

/// <tag name="Math">
///   <func id="InverseF4"/>
/// </tag>
/// <func id="InverseF4" name="InverseF4">
///   <in name="value" type="vec4"/>
///   <return type="vec4"/>
///   <description>[非推奨]逆数で構成される vec4 を出力</description>
/// </func>
/// <block guid="{48953707-4DFD-4e99-85E5-151A93754A9F}" displayname="[deprecated]InverseF4">
///   <func id="InverseF4"/>
///   <out displayname="1/vec4" type="vec4" target="return"/>
///   <in displayname="vec4" type="vec4" target="value"/>
/// </block>
/// <code funcid="InverseF4">
vec4 InverseF4( vec4 value )
{
  return vec4( 1.0/value.x, 1.0/value.y, 1.0/value.z, 1.0/value.w );
}
/// </code>

/// <tag name="Math">
///   <func id="InverseF3"/>
/// </tag>
/// <func id="InverseF3" name="InverseF3">
///   <in name="value" type="vec3"/>
///   <return type="vec3"/>
///   <description>[非推奨]逆数で構成される vec3 を出力</description>
/// </func>
/// <block guid="{48943797-4DFD-4e98-85E5-151A93754A9F}" displayname="[deprecated]InverseF3">
///   <func id="InverseF3"/>
///   <out displayname="1/vec3" type="vec3" target="return"/>
///   <in displayname="vec3" type="vec3" target="value"/>
/// </block>
/// <code funcid="InverseF3">
vec3 InverseF3( vec3 value )
{
  // 1/Xを計算
  return vec3( 1.0/value.x, 1.0/value.y, 1.0/value.z );
}
/// </code>

/// <tag name="Math">
///   <func id="InverseF2"/>
/// </tag>
/// <func id="InverseF2" name="InverseF2">
///   <in name="value" type="vec2"/>
///   <return type="vec2"/>
///   <description>[非推奨]逆数で構成される vec2 を出力</description>
/// </func>
/// <block guid="{48943796-4DFD-4e97-85E5-151A93754A9F}" displayname="[deprecated]InverseF2">
///   <func id="InverseF2"/>
///   <out displayname="1/vec2" type="vec2" target="return"/>
///   <in displayname="vec2" type="vec2" target="value"/>
/// </block>
/// <code funcid="InverseF2">
vec2 InverseF2( vec2 value )
{
  return vec2( 1.0/value.x, 1.0/value.y );
}
/// </code>

/// <tag name="Math">
///   <func id="InverseF"/>
/// </tag>
/// <func id="InverseF" name="InverseF">
///   <in name="value" type="float"/>
///   <return type="float"/>
///   <description>[非推奨]逆数を出力</description>
/// </func>
/// <block guid="{48943685-4DFD-4e97-85E5-150A93754A9F}" displayname="[deprecated]InverseF">
///   <func id="InverseF"/>
///   <out displayname="1/x" type="float" target="return"/>
///   <in displayname="x" type="float" target="value"/>
/// </block>
/// <code funcid="InverseF">
float InverseF( float value )
{
  return (1.0 / value);
}
/// </code>

/// <tag name="Math">
///   <func id="GetNormalize4"/>
/// </tag>
/// <func id="GetNormalize4" name="GetNormalize4">
///   <in name="v" type="vec4"/>
///   <return type="vec4"/>
///   <description>[非推奨]ベクトルの正規化（vec4）</description>
/// </func>
/// <block guid="{48943683-4DFC-4e96-85E5-150A93754A9F}" displayname="[deprecated]NormalizeV4">
///   <func id="GetNormalize4"/>
///   <out displayname="vec4" type="vec4" target="return"/>
///   <in displayname="vec4" type="vec4" target="v"/>
/// </block>
/// <code funcid="GetNormalize4">
vec4 GetNormalize4( vec4 v )
{
  return normalize( v );
}
/// </code>

/// <tag name="Math">
///   <func id="GetNormalize3"/>
/// </tag>
/// <func id="GetNormalize3" name="GetNormalize3">
///   <in name="v" type="vec3"/>
///   <return type="vec3"/>
///   <description>[非推奨]ベクトルの正規化（vec3）</description>
/// </func>
/// <block guid="{48943682-4DFC-4e96-85E5-150A93754A9F}" displayname="[deprecated]NormalizeV3">
///   <func id="GetNormalize3"/>
///   <out displayname="vec3" type="vec3" target="return"/>
///   <in displayname="vec3" type="vec3" target="v"/>
/// </block>
/// <code funcid="GetNormalize3">
vec3 GetNormalize3( vec3 v )
{
  return normalize( v );
}
/// </code>

/// <tag name="Math">
///   <func id="GetNormalize2"/>
/// </tag>
/// <func id="GetNormalize2" name="GetNormalize2">
///   <in name="v" type="vec2"/>
///   <return type="vec2"/>
///   <description>[非推奨]ベクトルの正規化（vec2）</description>
/// </func>
/// <block guid="{48943682-4DFC-4e96-85E5-151A93754A9F}" displayname="[deprecated]NormalizeV2">
///   <func id="GetNormalize2"/>
///   <out displayname="vec2" type="vec2" target="return"/>
///   <in displayname="vec2" type="vec2" target="v"/>
/// </block>
/// <code funcid="GetNormalize2">
vec2 GetNormalize2( vec2 v )
{
  return normalize( v );
}
/// </code>

/// <tag name="Math">
///   <func id="Clamp01F4"/>
/// </tag>
/// <func id="Clamp01F4" name="Clamp01F4">
///   <in name="value" type="vec4"/>
///   <return type="vec4"/>
///   <description>[非推奨][0, 1] の範囲で Clamp（vec4）</description>
/// </func>
/// <block guid="{58943685-4DFD-4e97-88E5-260A94764A9F}" displayname="[deprecated]ClampF4 [0, 1]">
///   <func id="Clamp01F4"/>
///   <out displayname="vec4 [0, 1]" type="vec4" target="return"/>
///   <in displayname="vec4" type="vec4" target="value"/>
/// </block>
/// <code funcid="Clamp01F4">
vec4 Clamp01F4( vec4 value )
{
  return vec4(
   clamp( value.x, 0.0, 1.0 ),
   clamp( value.y, 0.0, 1.0 ),
   clamp( value.z, 0.0, 1.0 ),
   clamp( value.w, 0.0, 1.0 ) );
}
/// </code>

/// <tag name="Math">
///   <func id="Clamp01F3"/>
/// </tag>
/// <func id="Clamp01F3" name="Clamp01F3">
///   <in name="value" type="vec3"/>
///   <return type="vec3"/>
///   <description>[非推奨][0, 1] の範囲で Clamp（vec3）</description>
/// </func>
/// <block guid="{58943685-4DFD-4e97-88E5-251A94754A9F}" displayname="[deprecated]ClampF3 [0, 1]">
///   <func id="Clamp01F3"/>
///   <out displayname="vec3 [0, 1]" type="vec3" target="return"/>
///   <in displayname="vec3" type="vec3" target="value"/>
/// </block>
/// <code funcid="Clamp01F3">
vec3 Clamp01F3( vec3 value )
{
  return vec3(
   clamp( value.x, 0.0, 1.0 ),
   clamp( value.y, 0.0, 1.0 ),
   clamp( value.z, 0.0, 1.0 ) );
}
/// </code>

/// <tag name="Math">
///   <func id="Clamp01F2"/>
/// </tag>
/// <func id="Clamp01F2" name="Clamp01F2">
///   <in name="value" type="vec2"/>
///   <return type="vec2"/>
///   <description>[非推奨][0, 1] の範囲で Clamp（vec2）</description>
/// </func>
/// <block guid="{58943685-4DFD-4e97-88E5-250A93754A9F}" displayname="[deprecated]ClampF2 [0, 1]">
///   <func id="Clamp01F2"/>
///   <out displayname="vec2 [0, 1]" type="vec2" target="return"/>
///   <in displayname="vec2" type="vec2" target="value"/>
/// </block>
/// <code funcid="Clamp01F2">
vec2 Clamp01F2( vec2 value )
{
  return vec2( clamp( value.x, 0.0, 1.0 ), clamp( value.y, 0.0, 1.0 ) );
}
/// </code>

/// <tag name="Math">
///   <func id="Clamp01F"/>
/// </tag>
/// <func id="Clamp01F" name="Clamp01F">
///   <in name="value" type="float"/>
///   <return type="float"/>
///   <description>[非推奨][0, 1] の範囲で Clamp（float）</description>
/// </func>
/// <block guid="{48943685-4DFD-4e97-88E5-150A93754A9F}" displayname="[deprecated]ClampF [0, 1]">
///   <func id="Clamp01F"/>
///   <out displayname="x [0, 1]" type="float" target="return"/>
///   <in displayname="x" type="float" target="value"/>
/// </block>
/// <code funcid="Clamp01F">
float Clamp01F( float value )
{
  return clamp( value, 0.0, 1.0 );
}
/// </code>

