﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の target を更新します。
def Update(doc):
	if doc.SelectSingleNode("/nw4f_3dif/shader_definition"):
		print("\nIntermediateFileUpdater does not support updating shader definition(.fsdb) file. Please recreate it by 3dShaderConverter.\n")
		Result = False
		return

	UpdateRootItemVersion(doc, "/nw4f_3dif")
	RemoveAttr(doc, "create", "user")
	RemoveAttr(doc, "create", "host")
	RemoveAttr(doc, "create", "date_time")
	RemoveAttr(doc, "modify", "user")
	RemoveAttr(doc, "modify", "host")
	RemoveAttr(doc, "modify", "date_time")
	AddEmptyAttribute(doc, "comment", "label")

	# fmd
	UpdateRootItemVersion(doc, "/nw4f_3dif/model")
	RemoveVertexProcessInfo(doc)
	RemoveBoundingArray(doc)
	ReplaceTexsrtEx(doc, "shader_param")
	AddEmptyAttribute(doc, "shape_info", "original_bone_name")
	AddEmptyAttribute(doc, "shape_info", "original_material_name")
	AddMotionMirroring(doc)

	# ftx
	UpdateRootItemVersion(doc, "/nw4f_3dif/texture")
	AddEmptyAttribute(doc, "texture_info", "original_image_hash")
	ConvertMipOffsetToLevelOffset(doc)
	RemoveAttr(doc, "texture_info", "tile_mode")
	RemoveAttr(doc, "texture_info", "swizzle")
	RemoveAttr(doc, "texture_info", "alignment")
	RemoveAttr(doc, "texture_info", "pitch")

	# fsk
	UpdateRootItemVersion(doc, "/nw4f_3dif/skeletal_anim")

	# fma, fsp, ftp, fvm
	UpdateRootItemVersion(doc, "/nw4f_3dif/material_anim")
	UpdateRootItemVersion(doc, "/nw4f_3dif/shader_param_anim")
	UpdateRootItemVersion(doc, "/nw4f_3dif/tex_pattern_anim")
	UpdateRootItemVersion(doc, "/nw4f_3dif/mat_visibility_anim")
	ReplaceTexsrtEx(doc, "param_anim")

	# fvb
	UpdateRootItemVersion(doc, "/nw4f_3dif/bone_visibility_anim")

	# fsh
	UpdateRootItemVersion(doc, "/nw4f_3dif/shape_anim")

	# fsn
	UpdateRootItemVersion(doc, "/nw4f_3dif/scene_anim")

	# fsc
	UpdateRootItemVersion(doc, "/nw4f_3dif/shader_config")

	# fsv
	UpdateRootItemVersion(doc, "/nw4f_3dif/shader_variation")
	RemoveMacroArrayFromShaderProgram(doc)

	# fsd
	ReplaceTexsrtEx(doc, "uniform_var")

def UpdateRootItemVersion(doc, target_xpath):
	node = doc.SelectSingleNode(target_xpath)
	if node != None:
		node.SetAttribute("version", "4.0.0")

def RemoveAttr(doc, elem_name, attr_name):
	for node in doc.SelectNodes("//" + elem_name):
		node.Attributes.RemoveNamedItem(attr_name)

def FindChildNode(node, child_node_name):
	for child_node in node.ChildNodes:
		if child_node.Name == child_node_name:
			return child_node
	return None

def RemoveMacroArrayFromShaderProgram(doc):
	for shader_program_node in doc.SelectNodes("//shader_program"):
		macro_array_node = FindChildNode(shader_program_node, "macro_array")
		if macro_array_node != None:
			shader_program_node.RemoveChild(macro_array_node)

def RemoveBoundingArray(doc):
	for shape_node in doc.SelectNodes("//shape"):
		bounding_array_node = shape_node.SelectSingleNode("bounding_array")
		if bounding_array_node != None:
			shape_node.RemoveChild(bounding_array_node)

def RemoveNamedChild(node, child_name):
	remove_list = []
	for child_node in node.SelectNodes("//" + child_name):
		remove_list.append(child_node)
	for remove_node in remove_list:
		node.RemoveChild(remove_node)

def ReplaceTexsrtEx(doc, element_name):
	for node in doc.SelectNodes("//" + element_name):
		for attr in node.Attributes:
			if attr.Value == "texsrt_ex":
				attr.Value = "texsrt"

def RemoveVertexProcessInfo(doc):
	model_info_node = doc.SelectSingleNode("/nw4f_3dif/model/model_info")
	if model_info_node != None:
		model_info_node.Attributes.RemoveNamedItem("total_vertex")
		model_info_node.Attributes.RemoveNamedItem("total_index")
		model_info_node.Attributes.RemoveNamedItem("total_triangle")
		model_info_node.Attributes.RemoveNamedItem("process_vertex_per_triangle")

def AddEmptyAttribute(doc, elem_name, attr_name):
	for node in doc.SelectNodes("//" + elem_name):
		attr = doc.CreateAttribute(attr_name)
		attr.Value = ""
		node.Attributes.Append(attr)

def AddMotionMirroring(doc):
	mirroring_node = doc.SelectSingleNode("/nw4f_3dif/model/tool_data/nw_mirroring_info")
	if mirroring_node != None:
		enable = mirroring_node.GetAttribute("enable")
		AddAttribute(doc, "skeleton_info", "motion_mirroring_enable", enable)
		tool_data_node = doc.SelectSingleNode("/nw4f_3dif/model/tool_data")
		RemoveNamedChild(tool_data_node, "nw_mirroring_info")
		if tool_data_node.HasChildNodes == False:
			model_node = doc.SelectSingleNode("/nw4f_3dif/model")
			RemoveNamedChild(model_node, "tool_data")
	else:
		AddAttribute(doc, "skeleton_info", "motion_mirroring_enable", "false")

def AddAttribute(doc, elem_name, attr_name, value):
	for node in doc.SelectNodes("//" + elem_name):
		attr = doc.CreateAttribute(attr_name)
		attr.Value = value
		node.Attributes.Append(attr)

def ConvertMipOffsetToLevelOffset(doc):
	tex_info = doc.SelectSingleNode("/nw4f_3dif/texture/texture_info")
	if tex_info != None:
		mip_level = int(tex_info.GetAttribute("mip_level"))
		level_offsets = [0] * mip_level
		if mip_level >= 2:
			mip_offsets = tex_info.GetAttribute("mip_offset").split(' ')
			level_offsets[1] = int(mip_offsets[0])
			for level in range(1, mip_level - 1):
				level_offsets[level + 1] = level_offsets[1] + int(mip_offsets[level])
		attr = doc.CreateAttribute("level_offset")
		value = ""
		for offset in level_offsets:
			value = value + "%d "%offset;
		attr.Value = value.strip()
		tex_info.Attributes.Append(attr)
		tex_info.Attributes.RemoveNamedItem("mip_offset")
