﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の doc を更新します
def Update(doc):
	# <nw4f_3dif> version を 0.4.0 に変更
	version = doc.SelectSingleNode("/nw4f_3dif/@version")
	version.Value = "0.4.0"

	# <nw4f_3dif> binary_offset を削除
	binary_offset = doc.SelectSingleNode("/nw4f_3dif/@binary_offset")
	binary_offset.OwnerElement.RemoveAttributeNode(binary_offset)

	# <user_tool_data> を <stream_array> の後ろに移動
	MoveToEnd(doc, "/nw4f_3dif/texture/user_tool_data")
	MoveToEnd(doc, "/nw4f_3dif/skeletal_anim/user_tool_data")
	MoveToEnd(doc, "/nw4f_3dif/tex_pattern_anim/user_tool_data")

	# モデルの更新
	if doc.SelectSingleNode("/nw4f_3dif/model"):
		UpdateModel(doc)

	# シェーダパラメータアニメの更新
	if doc.SelectSingleNode("/nw4f_3dif/shader_param_anim"):
		UpdateShaderParamAnim(doc)

#----------------------------------------------------------
# モデルの更新
def UpdateModel(doc):
	material = "/nw4f_3dif/model/material_array/material"
	original_material = "/nw4f_3dif/model/original_material_array/original_material"

	#------------------------------------------------------
	# <user_tool_data> を <stream_array> の後ろに移動
	MoveToEnd(doc, "/nw4f_3dif/model/user_tool_data")

	#------------------------------------------------------
	# <material_info> visibility を true で追加
	for material_info in doc.SelectNodes(
		material + "/material_info"):
		material_info.SetAttribute("visibility", "true")

	#------------------------------------------------------
	#  <shader_param> original_hint を空文字列で追加
	for shader_param in doc.SelectNodes(
		material + "/material_shader_assign/shader_param_array/shader_param"):
		shader_param.SetAttribute("original_hint", "")

	#------------------------------------------------------
	# <original_color> の id を削除
	for original_color_id in doc.SelectNodes(
		original_material + "/original_color_array/original_color/@id"):
		original_color_id.OwnerElement.RemoveAttributeNode(original_color_id)

	#------------------------------------------------------
	# <original_texsrt> の id を削除
	for original_texsrt_id in doc.SelectNodes(
		original_material + "/original_texsrt_array/original_texsrt/@id"):
		original_texsrt_id.OwnerElement.RemoveAttributeNode(original_texsrt_id)

#----------------------------------------------------------
# シェーダパラメータアニメの更新
def UpdateShaderParamAnim(doc):

	#------------------------------------------------------
	# <user_tool_data> を <stream_array> の後ろに移動
	MoveToEnd(doc, "/nw4f_3dif/shader_param_anim/user_tool_data")

	#------------------------------------------------------
	# <param_anim> original_hint を空文字列で追加
	for param_anim in doc.SelectNodes(
		"/nw4f_3dif/shader_param_anim/shader_param_mat_anim_array/" +
		"shader_param_mat_anim/param_anim_array/param_anim"):
		param_anim.SetAttribute("original_hint", "")

	#------------------------------------------------------
	# <original_color_anim> の id を削除
	for original_color_anim_id in doc.SelectNodes(
		"/nw4f_3dif/shader_param_anim/original_material_anim_array/" +
		"original_material_anim/original_color_anim_array/original_color_anim/@id"):
		original_color_anim_id.OwnerElement.RemoveAttributeNode(original_color_anim_id)

	#------------------------------------------------------
	# <original_texsrt_anim> の id を削除
	for original_texsrt_anim_id in doc.SelectNodes(
		"/nw4f_3dif/shader_param_anim/original_material_anim_array/" +
		"original_material_anim/original_texsrt_anim_array/original_texsrt_anim/@id"):
		original_texsrt_anim_id.OwnerElement.RemoveAttributeNode(original_texsrt_anim_id)

#----------------------------------------------------------
# 末尾へ移動
def MoveToEnd(doc, path):
	for element in doc.SelectNodes(path):
		parent = element.ParentNode
		parent.RemoveChild(element)
		parent.AppendChild(element)

#----------------------------------------------------------
