﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の doc を更新します
def Update(doc):
	# バージョン番号の更新
	version = doc.SelectSingleNode("/nw4f_3dif/@version")
	version.Value = "0.2.0"

	# モデルの更新
	if doc.SelectSingleNode("/nw4f_3dif/model"):
		UpdateModel(doc)

	# スケルタルアニメの更新
	if doc.SelectSingleNode("/nw4f_3dif/skeletal_anim"):
		UpdateSkeletalAnim(doc)

#----------------------------------------------------------
# モデルの更新
def UpdateModel(doc):

	#------------------------------------------------------
	# 名前系属性追加、hint の解析には未対応
	AddAttr(doc, "model/vertex_array/vertex/vtx_attrib_array/vtx_attrib", "name", "_")
	AddAttr(doc, "model/material_array/material/material_info", "env_name", "")
	AddAttr(doc, "model/material_array/material/sampler_array/sampler", "name", "_")

	#------------------------------------------------------
	# quantize_type の値変更
	quantize_typeDic = {
		"u16": "uint_16",
		"u32": "uint_32",
	}
	ReplaceAttrValue(doc, "model/shape_array/shape/mesh/@quantize_type", quantize_typeDic)

	#------------------------------------------------------
	# 配列の size 属性を length 属性に変更
	ToLength(doc, "model/renderset_array/@size")
	ToLength(doc, "model/skeleton/bone_array/@size")
	ToLength(doc, "model/vertex_array/@size")
	ToLength(doc, "model/vertex_array/vertex/vtx_attrib_array/@size")
	ToLength(doc, "model/vertex_array/vertex/vtx_buffer_array/@size")
	ToLength(doc, "model/vertex_array/vertex/vtx_buffer_array/vtx_buffer/input_array/@size")
	ToLength(doc, "model/shape_array/@size")
	ToLength(doc, "model/shape_array/shape/mesh/submesh_array/@size")
	ToLength(doc, "model/shape_array/shape/shape_shader_assign/shader_option_array/@size")
	ToLength(doc, "model/shape_array/shape/shape_shader_assign/attrib_assign_array/@size")
	ToLength(doc, "model/material_array/@size")
	ToLength(doc, "model/material_array/material/sampler_array/@size")
	ToLength(doc, "model/material_array/material/material_shader_assign/shader_option_array/@size")
	ToLength(doc, "model/material_array/material/material_shader_assign/sampler_assign_array/@size")
	ToLength(doc, "model/material_array/material/material_shader_assign/shader_param_array/@size")
	ToLength(doc, "model/stream_array/@size")

	#------------------------------------------------------
	# 参照用インデックスへの名前付け
	RenameAttr(doc, "model/skeleton/bone_array/bone/@index", "bone_index")
	RenameAttr(doc, "model/vertex_array/vertex/@index", "vertex_index")
	RenameAttr(doc, "model/vertex_array/vertex/vtx_attrib_array/vtx_attrib/@index", "attrib_index")
	RenameAttr(doc, "model/shape_array/shape/@index", "shape_index")
	RenameAttr(doc, "model/material_array/material/@index", "material_index")
	RenameAttr(doc, "model/material_array/material/sampler_array/sampler/@index", "sampler_index")

	#------------------------------------------------------
	# 個数の size 属性を count 属性に変更
	ToCount(doc, "model/vertex_array/vertex/vtx_attrib_array/vtx_attrib/@size")
	RenameAttr(doc, "model/shape_array/shape/shape_info/@vertex_skinning_size", "vertex_skinning_count")
	ToCount(doc, "model/shape_array/shape/mesh/@size")
	ToCount(doc, "model/material_array/material/material_shader_assign/shader_param_array/shader_param/@size")
	ToCount(doc, "model/stream_array/stream/@size")

#----------------------------------------------------------
# スケルタルアニメの更新
def UpdateSkeletalAnim(doc):

	#------------------------------------------------------
	# 配列の size 属性を length 属性に変更
	ToLength(doc, "skeletal_anim/bone_anim_array/@size")
	ToLength(doc, "skeletal_anim/stream_array/@size")

	# 個数の size 属性を count 属性に変更
	RenameAttr(doc, "skeletal_anim/skeletal_anim_info/@frame_size", "frame_count")
	ToCount(doc, "skeletal_anim/bone_anim_array/bone_anim/bone_anim_target/hermite_curve/@size")
	ToCount(doc, "skeletal_anim/stream_array/stream/@size")

#----------------------------------------------------------
# 属性の追加
def AddAttr(doc, xPath, attrName, attrValue):
	for elem in doc.SelectNodes("/nw4f_3dif/" + xPath):
		attr = doc.CreateAttribute(attrName)
		attr.Value = attrValue
		elem.SetAttributeNode(attr)

# 属性のリネーム
def RenameAttr(doc, xPath, newName):
	for oldAttr in doc.SelectNodes("/nw4f_3dif/" + xPath):
		newAttr = doc.CreateAttribute(newName)
		newAttr.Value = oldAttr.Value
		ownerElem = oldAttr.OwnerElement
		ownerElem.RemoveAttributeNode(oldAttr)
		ownerElem.SetAttributeNode(newAttr)

# length 属性へのリネーム
def ToLength(doc, xPath):
	RenameAttr(doc, xPath, "length")

# count 属性へのリネーム
def ToCount(doc, xPath):
	RenameAttr(doc, xPath, "count")

# 属性値の置換
def ReplaceAttrValue(doc, xPath, replaceDic):
	for attr in doc.SelectNodes("/nw4f_3dif/" + xPath):
		if attr.Value in replaceDic:
			attr.Value = replaceDic[attr.Value]

#----------------------------------------------------------
