-- NintendoExport Utilities Script
-- Version 3.12.0
-- Copyright (C)Nintendo All rights reserved.

NintendoExportOptionPairArray = #( \
	#("export_target", "et"), #("output_file_name", "ofn"),  #("output_folder", "of"), #("merge_fmd", "mmd"), \
	#("merge_fmd_path", "mmdp	"), #("merge_ftx", "mtx"), #("merge_anim", "man"), #("merge_anim_folder", "manf"), #("merge_anim_name", "mann"), \
	#("magnify", "mag"), #("texsrt_mode", "tsm"), #("frame_range", "fr"), #("start_frame", "s"), #("end_frame", "e"), #("loop_anim", "l"), \
	#("bake_all_anim", "baa"), #("frame_precision", "fp"), \
	#("output_fmd", "fmd"), #("output_ftx", "ftx"), #("output_fsk", "fsk"), #("output_fvb", "fvb"), #("output_fcl", "fcl"), \
	#("output_fts", "fts"), #("output_ftp", "ftp"),  #("output_fsh", "fsh"), #("output_fsn", "fsn"),  \
	#("compress_bone", "cb"), #("unite_child", "uc"),  #("compress_material", "cm"), #("compress_shape", "cs"),  \
	#("tolerance_scale", "ts"), #("tolerance_rotate", "tr"), #("tolerance_translate", "tt"), #("tolerance_color", "tc"), \
	#("tolerance_tex_scale", "tts"), #("tolerance_tex_rotate", "ttr"), #("tolerance_tex_translate", "ttt"), \
	#("quantize_tolerance_scale", "qts"), #("quantize_tolerance_rotate", "qtr"), #("quantize_tolerance_translate", "qtt"), \
	#("quantize_tolerance_tex_scale", "qtts"),  #("quantize_tolerance_tex_rotate", "qttr"), #("quantize_tolerance_tex_translate", "qttt"), \
	#("pre_export_script", "pres"), #("post_export_script", "poes") \
)

/********************************************************
struct NintendoExportUtilities
 ********************************************************/
struct NintendoExportUtilities
(
	enableSaveToScene = true,
	showDisableZYAxisConversion = false,
	displayIntegerInHex = false,
	recentFdes = #(),
	
	
	fn outComment fs str =
	(
		format "# %\n" str to:fs
	),
	
	fn outReturn fs=
	(
		format "\n" to:fs
	),
	
	fn outValue fs key v =
	(
		format "%=\"%\"\n" key (v as string) to:fs
	),
	
	fn outVersion fs key v =
	(
		local str = ""
		for i = 1 to 3 do
		(
			local d = (mod v 10) as integer
			v = (v - d) / 10
			str = (d as string) + str
			if i != 3 do str = "." + str
		)
		outValue fs key str
	),
	
	fn outQuantValue fs key v =
	(
		local str = case v of
		(
			3: "Byte"
			2: "Short"
			default: "Float"
		)
		
		outValue fs key str
	),
	
	fn QuantStrToInt str =
	(
		local val = toLower str
		case val of
		(
			"byte": 3
			"short": 2
			default: 1
		)
	),
	
	fn intToHexString v = 
	(
		local str = (bit.intAsHex v) as String
		str = toUpper str
		for i = 1 to (8 - str.count) do
		(
			str = "0" + str
		)
		return str
	),
	
	fn useNonUniformScale =
	(
		((systemTools.getEnvVariable "NW4F_USE_NON_UNIFORM_SCALE") == "1")
	),
	
	fn convertBSlashToSlash str =
	(
		substituteString str @"\" "/"
	),
	
	fn listToString list = 
	(
		local str = ""
		if (classof list) == Array do
		(
			for item in list do
			(
				local n = item as String
				if (findString n " ") != undefined then
				(
					str += " \"" + n + "\""
				)
				else
				(
					str += " " + n
				)
			)
		)
		return trimLeft str
	),
	
	fn stringToList str = 
	(
		local list = #()
		if (classof str) == String do
		(
			local ss = str as StringStream
			local item = ""
			local bDQ = false
			local c
			
			seek ss 0
			
			while not eof ss do
			(
				c = readChar ss
				case c of
				(
					" ": continue
					"\n": continue
					"\t": continue
					"\"": item = readDelimitedString ss "\""
					"'": item = readDelimitedString ss "'"
					default:  item = c + (readDelimitedString ss " \n\t")
				)
				append list item
			)
			close ss
		)
		return list
	),
	
	fn scriptToFdes str =
	(
		for i = 1 to str.count do
		(
			local c = str[i]
			str[i] = case c of
			(
				"\"": "'"
				";": "!"
				default: c
			)
		)
		return str
	),
	
	fn fdesToScript str =
	(
		for i = 1 to str.count do
		(
			local c = str[i]
			str[i] = case c of
			(
				"'": "\""
				"!": ";"
				default: c
			)
		)
		return str
	),
	
	-- vZbgAsciiŃt@CɎg镶̂
	fn isValidPresetName pname showMsgBox:false showErrMsg:false =
	(
		if pname.count > 0 do
		(
			if pathConfig.isLegalPath pname do
			(
				local c
				local valid = true
				if (stricmp pname "None") == 0 do valid = false
				for i = 1 to pname.count while valid do
				(
					c = pname[i]
					if c < " " or "~" < c then
					(
						valid = false
					)
					else if c == ";" or c == ":" or c == "/" or \
						c == "\\" or c == "*" or c == "?" or \
						c == "<" or c == ">" or c == "|" do 
					(
						valid = false 
					)
				)
				if valid do return true
			)
		)
		
		local ss = stringstream ""
		local mes = "Preset Name(%) is wrong\n (please don't use [non acsii character] [;] [:] [/] [\\] [*] [?] [<] [>] [|] [double quote] [None])"
		if showMsgBox then
		(
			format mes pname to:ss
			messagebox (ss as string)
		)
		else if showErrMsg then
		(
			--break()
			format mes pname to:ss
			format "ERROR: %\n" (ss as string)
		)
		return false
	),

	fn nw4fExportDialogLocalizer ro lang =
	(
		local isEn = lang != "ja"
		/*
		if isEn then "Save/Load Export Settings" else "oݒ̕ۑ/ǂݍ"
		if isEn then  "Load " else "ǂݍ"
		if isEn then  "Save " else "ۑ"
		if isEn then  "Reset " else "Zbg"
		
		srOutput = ro.nw4fSR_Output
		srGeneral = ro.nw4fSR_General
		srFileSelection = ro.nw4fSR_FileSelection
		srOptimization = ro.nw4fSR_Optimization
		srAnimation = ro.nw4fSR_Animation
		srToletance = ro.nw4fSR_Toletance
		srQuantToletance = nw4fSR_QuantToletance
		
		*/
		ro.srOutput.title = 						if isEn then "Output Options" else "o̓IvV"
		ro.srOutput.lblSelection.text =		if isEn then "Export Target" else "o͑Ώ"
		--ro.srOutput.rdoSelection.labels =	if isEn then #("All", "Selection") else #("ׂ", "Iꂽ")
		ro.srOutput.lblFilename.text =			if isEn then "Output File Name" else "o̓t@C"
		ro.srOutput.btnNameScene.text =	if isEn then "Scene" else "V["
		ro.srOutput.btnNameNode.text =	if isEn then "Node" else "m[h"
		ro.srOutput.lblFilepath.text =		if isEn then "    Output Folder " else "o̓tH_"
		ro.srOutput.chkDisableZYConv.text =	if isEn then "Disable Z-Y Axis Conversion" else "Z-Yϊ𖳌ɂ"
		ro.srOutput.chkMergeModel.text = if isEn then "Merge fmd File" else "fmd ̃}[W"
		ro.srOutput.chkMergeTex.text = if isEn then "Merge ftx File" else "ftx ̃}[W"
		ro.srOutput.chkMergeAnim.text = if isEn then "Merge Animation Folder" else "Aj[Ṽ}[W"
		--ro.srOutput.chkMergeAnim.text = if isEn then "merge_anim_folder" else "tH_"
		ro.srOutput.lblMergeAnimName.text = if isEn then "Merge Animation Name" else "}[WAj[V"
		
		ro.srGeneral.title = 							if isEn then "General Options" else "ʃIvV"
		ro.srGeneral.spnMagnify.text = if isEn then "Magnify " else "{ "
		ro.srGeneral.chkUseFigureMode.text = if isEn then "Use FigureMode and SkinPose" else "tBMA[hXL|[Yg"
		ro.srGeneral.editComment.caption = 		if isEn then "Comment" else "Rg"
		
		ro.srAnimation.title = if isEn then "Animation Options" else "Aj[VIvV"
		ro.srAnimation.lblTimeRange.text = if isEn then "Start/End Frame" else "Jn/It["
		--ro.srAnimation..text = if isEn then "Playback" else "Đ"
		--ro.srAnimation..text = if isEn then "Range" else "͈"
		--ro.srAnimation..text = if isEn then "Start" else "Jnt["
		--ro.srAnimation..text = if isEn then "End" else "It["
		--ro.srAnimation..text = if isEn then "Bake All Animation" else "SẴAj[VxCN"
		ro.srAnimation.ddlAnimationPrecision.text = if isEn then "Frame Precision" else "t[̐x"
		ro.srAnimation.chkAnimationLoop.text = if isEn then "Loop" else "[v"
	
		ro.srFileSelection.title = 		 					if isEn then "Output File Selection" else "o̓t@CI"
		ro.srFileSelection.lblExportModel.text = 		if isEn then "Model Data " else "f "
		ro.srFileSelection.lblExportTex.text = 		 	if isEn then "Texture Data " else "eNX` "
		ro.srFileSelection.lblExportSkelAnim.text = 	if isEn then "Character Animation Data " else "XP^Aj "
		ro.srFileSelection.lblExportMdlAnim.text = 	if isEn then "Bone Visibility Animation Data " else "rWreBAj "
		ro.srFileSelection.lblExportMtlCol.text = 		if isEn then "Material Color Animation Data " else "J[Aj "
		ro.srFileSelection.lblExportTexSRT.text = 	if isEn then "Texture SRT Animation Data " else "eNX` SRT Aj "
		ro.srFileSelection.lblExportTexPat.text = 		if isEn then "Texture Pattern Animation Data " else "eNX`p^[Aj "
		ro.srFileSelection.lblExportShape.text = 		if isEn then "Shape Animation Data " else "VFCvAj[V "
		ro.srFileSelection.lblExportScene.text = 		if isEn then "Scene Animation Data " else "V[Aj "
		ro.srFileSelection.btnSearchAnim.text = 		if isEn then "Search Animation" else "Aj[V"
			
		ro.srOptimization.title = 							if isEn then "Optimization Options" else "œKIvV"
		ro.srOptimization.ddlCompressNode.text = 	if isEn then "Compress Bone" else "{[k"
		ro.srOptimization.ddlCompressNode.items =	if isEn then 
		(
			#("None", "Cull", "Merge", "Unite", "Unite All")  
		)
		else
		(		
			#("Ȃ", "JO", "", "", "iktOj")
		)
		ro.srOptimization.chkUniteChild.text = 			if isEn then "Unite Child" else "q{[̓"
		ro.srOptimization.chkCompressMtl.text = 		if isEn then "Compress Material" else "}eAk"
		ro.srOptimization.chkCompressShape.text = 	if isEn then "Compress Shape" else "VFCvk"
		--if isEn then "Softimage Options" else "Softimage@IvV"
		--if isEn then "Invert VertexColor Alpha" else "_J[̃At@]"
		--if isEn then "Ignore Ambient Texture" else "ArGgeNX`𖳎"
		
		ro.srToletance.title = 							if isEn then "Animation Bake Tolerance Options" else "xCNAj[V̋e덷IvV"
		ro.srToletance.spnToleranceNodeT.text = if isEn then "Node Translate" else "m[ḧړ"
		ro.srToletance.spnToleranceNodeR.text = if isEn then "Node Rotate()" else "m[h̉]"
		ro.srToletance.spnToleranceNodeS.text = if isEn then "         Node Scale" else "m[h̃XP["
		ro.srToletance.spnToleranceTexT.text = 	if isEn then " Texture Translate" else "eNX`̈ړ"
		ro.srToletance.spnToleranceTexR.text = 	if isEn then " Texture Rotate()" else "eNX`̉]"
		ro.srToletance.spnToleranceTexS.text = 	if isEn then "         Texture Scale" else "eNX`̃XP["
		ro.srToletance.spnToleranceColor.text = 	if isEn then "            Color" else "J["
			
		ro.srQuantToletance.title = 									if isEn then "Animation Quantization Tolerance Options" else "Aj[Vʎq̋e덷IvV"
		ro.srQuantToletance.spnQuantToleranceNodeT.text = if isEn then "Node Translate(%)" else "m[ḧړ(%)"
		ro.srQuantToletance.spnQuantToleranceNodeR.text = if isEn then "    Node Rotate()" else "m[h̉]()"
		ro.srQuantToletance.spnQuantToleranceNodeS.text = if isEn then "         Node Scale(%)" else "m[h̃XP[(%)"
		ro.srQuantToletance.spnQuantToleranceTexT.text = 	if isEn then "Texture Translate(%)" else "eNX`̈ړ(%)"
		ro.srQuantToletance.spnQuantToleranceTexR.text = 	if isEn then "    Texture Rotate()" else "eNX`̉]()"
		ro.srQuantToletance.spnQuantToleranceTexS.text = 	if isEn then "          Texture Scale(%)" else "eNX`̃XP[(%)"
		
		ro.btnExport.text = 	if isEn then  "Export" else "o"
		ro.btnApply.text = 	if isEn then  "Apply" else "Kp"
		ro.btnClose.text = 	if isEn then  "Close" else ""
	),
	
	fn preloadLockInfo fs =
	(
		local ninexp = NintendoExport
		while not (eof fs) do
		(
			str = readLine fs
			-- skip comment and null line
			if (str.count < 1) or (str[1] == "#") do 
			(
				if eof fs do ( isEOF = true )
				continue
			)
			local elem = filterString str "="
			if (classof elem != Array) or elem.count != 2 do continue
			key = elem[1]
			val = substituteString elem[2] "\"" ""
			--format "\"%\"=\"%\"\n" key val
			case key of
			(
				"preset": (
					/*
					if val.count > 0 do
					(
						if not (isValidPresetName val showErrMsg:true) do
						(
							return false
						)
					)
					*/
				)
				-- Lock Options
				"lock_export_target": ninexp.Lock_export_target = val as booleanclass
				"lock_output_file_name": ninexp.Lock_output_file_name = val as booleanclass
				"lock_output_folder": ninexp.Lock_output_folder = val as booleanclass
				"lock_merge_fmd": ninexp.Lock_merge_fmd = val as booleanclass
				"lock_merge_ftx": ninexp.Lock_merge_ftx = val as booleanclass
				"lock_merge_anim": ninexp.Lock_merge_anim = val as booleanclass
				"lock_merge_anim_name": ninexp.Lock_merge_anim_name = val as booleanclass
				"lock_magnify": ninexp.Lock_magnify = val as booleanclass
				"lock_texsrt_mode": ninexp.Lock_texsrt_mode = val as booleanclass
				"lock_remove_namespace": ninexp.Lock_remove_namespace = val as booleanclass
				"lock_use_figure_mode": ninexp.Lock_use_figure_mode = val as booleanclass
				"lock_comment": ninexp.Lock_comment = val as booleanclass
				"lock_frame_range": ninexp.Lock_frame_range = val as booleanclass
				"lock_loop_anim": ninexp.Lock_loop_anim = val as booleanclass
				"lock_bake_all_anim": ninexp.Lock_bake_all_anim = val as booleanclass
				"lock_frame_precision": ninexp.Lock_frame_precision = val as booleanclass
				"lock_output_fmd": ninexp.Lock_output_fmd = val as booleanclass
				"lock_output_ftx": ninexp.Lock_output_ftx = val as booleanclass
				"lock_output_fsk": ninexp.Lock_output_fsk = val as booleanclass
				"lock_output_fvb": ninexp.Lock_output_fvb = val as booleanclass
				"lock_output_fcl": ninexp.Lock_output_fcl = val as booleanclass
				"lock_output_fts": ninexp.Lock_output_fts = val as booleanclass
				"lock_output_ftp": ninexp.Lock_output_ftp = val as booleanclass
				"lock_output_fsh": ninexp.Lock_output_fsh = val as booleanclass
				"lock_output_fsn": ninexp.Lock_output_fsn = val as booleanclass
				"lock_compress_bone": ninexp.Lock_compress_bone = val as booleanclass
				"lock_unite_child": ninexp.Lock_unite_child = val as booleanclass
				"lock_compress_material": ninexp.Lock_compress_material = val as booleanclass
				"lock_compress_shape": ninexp.Lock_compress_shape = val as booleanclass
				"lock_tolerance_scale": ninexp.Lock_tolerance_scale = val as booleanclass
				"lock_tolerance_rotate": ninexp.Lock_tolerance_rotate = val as booleanclass
				"lock_tolerance_translate": ninexp.Lock_tolerance_translate = val as booleanclass
				"lock_tolerance_color": ninexp.Lock_tolerance_color = val as booleanclass
				"lock_tolerance_tex_scale": ninexp.Lock_tolerance_tex_scale = val as booleanclass
				"lock_tolerance_tex_rotate": ninexp.Lock_tolerance_tex_rotate = val as booleanclass
				"lock_tolerance_tex_translate": ninexp.Lock_tolerance_tex_translate = val as booleanclass
				"lock_quantize_tolerance_scale": ninexp.Lock_quantize_tolerance_scale = val as booleanclass
				"lock_quantize_tolerance_rotate": ninexp.Lock_quantize_tolerance_rotate = val as booleanclass
				"lock_quantize_tolerance_translate": ninexp.Lock_quantize_tolerance_translate = val as booleanclass
				"lock_quantize_tolerance_tex_scale": ninexp.Lock_quantize_tolerance_tex_scale = val as booleanclass
				"lock_quantize_tolerance_tex_rotate": ninexp.Lock_quantize_tolerance_tex_rotate = val as booleanclass
				"lock_quantize_tolerance_tex_translate": ninexp.Lock_quantize_tolerance_tex_translate = val as booleanclass
				"lock_pre_export_script": ninexp.Lock_pre_export_script = val as booleanclass
				"lock_post_export_script": ninexp.Lock_post_export_script = val as booleanclass
				 
				 --default: format "WARNING: unknown key found in fdes(%=%)\n" key val
			)							
		)
		return true
	),
	
	
	fn loadSettingFromFile filename stream:undefined isPreset:false = 
	(
		local ninexp = NintendoExport
		if ninexp == undefined do return false
		if filename == undefined do return false
		local fs = undefined
		local cmdmode = false
		if stream == undefined then
		(
			fs = openFile filename mode:"rt"
			if fs == undefined do
			(
				format "loadSettingFromFile:File Open Error(%)\n" filename
				return false
			)
		)
		else
		(
			fs = stream
			seek fs 0
			cmdmode = true
			--print (stream as string)
		)
		
		
		-- read header
		if (findString (readLine fs) "NW4F_Export settings") == undefined do return false
		
		if isPreset do
		(
			local fpos = filePos fs
			if not (preloadLockInfo fs) do
			(
				close fs
				return false
			)
			seek fs fpos
		)
		
		local str, key, val, ver = 0
		local isEOF = false
		while not (eof fs) do
		(
			str = readLine fs
			-- skip comment and null line
			if (str.count < 1) or (str[1] == "#") do 
			(
				if eof fs do ( isEOF = true )
				continue
			)
			local elem = filterString str "="
			if (classof elem != Array) or elem.count != 2 do continue
			key = elem[1]
			val = substituteString elem[2] "\"" ""
			--format "\"%\"=\"%\"\n" key val
			case key of
			(
				-- NW4F_Export settings
				"settings_version": ( ver = (substituteString val "." "") as integer)
				"date_time": ()
				"tool_name": ()
				"tool_version": ()
				
				-- Preset Options
				"preset": 	(
									if not isPreset do
									(
										if val.count == 0 or (isValidPresetName val showErrMsg:true) then
										(
											ninexp.PresetName = val
										)
										else
										(
											close fs
											return false
										)
									)
								)
				 "show_preset_ui": ninexp.ShowPresetUI = val as booleanclass
				
				-- Output Options
				"export_target":  	if not isPreset or ninexp.Lock_export_target do \
												ninexp.doesExportSelected = ((stricmp val "selection") == 0)
				"output_file_name": 	if not isPreset or ninexp.Lock_output_file_name do \
												ninexp.filename = val
				"output_folder": 		(
											if not isPreset or ninexp.Lock_output_folder do \
												ninexp.outputFolder = val
										)
				"merge_fmd": 			if not isPreset or ninexp.Lock_merge_fmd do \
												ninexp.useMerge = val as booleanclass
				"merge_fmd_path": (
											if not isPreset or ninexp.Lock_merge_fmd do \
												ninexp.mergeFilename = val
											if cmdmode do ninexp.useMerge = true
										)
				"merge_ftx": 			if not isPreset or ninexp.Lock_merge_ftx do \
												ninexp.useMergeFtx = val as booleanclass
				"merge_anim": 		if not isPreset or ninexp.Lock_merge_anim do \
												ninexp.useMergeAnim = val as booleanclass
				"merge_anim_folder": (
											if not isPreset or ninexp.Lock_merge_anim do \
												ninexp.MergeAnimFolder = val
											if cmdmode do ninexp.useMergeAnim = true
										)
				"merge_anim_name": (
											if not isPreset or ninexp.Lock_merge_anim_name do \
												ninexp.MergeAnimName = val
											if cmdmode do ninexp.useMergeAnim = true
										)
				-- General Options
												
				"magnify": 							if not isPreset or ninexp.Lock_magnify do \
															ninexp.magnify = val as float
				"texsrt_mode": 					()
				"remove_namespace": 			()
				"comment": 						if not isPreset or ninexp.Lock_comment do \
															ninexp.commentText = val
				
				"3dsmax_use_figure_mode": 	if not isPreset or ninexp.Lock_use_figure_mode do \
															ninexp.useFiguremode = val as booleanclass -- old name
				"use_figure_mode": 				if not isPreset or ninexp.Lock_use_figure_mode do \
															ninexp.useFiguremode = val as booleanclass
				"disable_zyaxis_conversion": 	ninexp.DisableZYAxisConversion = val as booleanclass
				
				-- Animation Options
				"frame_range": 		if not isPreset or ninexp.Lock_frame_range do \
												ninexp.doesExportAllFrames =  ((stricmp val "Range") != 0)
				"start_frame": (
											if not isPreset or ninexp.Lock_frame_range do \
												ninexp.startFrame = val as integer
											if cmdmode do ninexp.doesExportAllFrames = false
				)
				"end_frame": (
											if not isPreset or ninexp.Lock_frame_range do \
												ninexp.endFrame = val as integer 
											if cmdmode do ninexp.doesExportAllFrames = false
				)
				"loop_anim": 			if not isPreset or ninexp.Lock_loop_anim do \
												ninexp.isLoop = val as booleanclass
				"bake_all_anim": 		()
				"frame_precision": 	(
					if not isPreset or ninexp.Lock_frame_precision do 
					(
						local fval = val as float
						if fval > 0.0 do
						(
							local ival = (1.0 / fval) as integer
							ninexp.framePrecision = case of
							(
								(ival <= 1): 1
								(ival <= 2): 2
								(ival <= 5): 5
								default: 10
							)
						)
					)
				 )
				 
				-- Output File Selection
				"output_fmd":	if not isPreset or ninexp.Lock_output_fmd do \
										ninexp.doesExportModel = val as booleanclass
				"output_ftx": 	if not isPreset or ninexp.Lock_output_ftx do \
										ninexp.doesExportTexture = val as booleanclass
				"output_fsk": 	if not isPreset or ninexp.Lock_output_fsk do \
										ninexp.doesExportSkelAnim = val as booleanclass
				"output_fvb": 	if not isPreset or ninexp.Lock_output_fvb do \
										ninexp.doesExportVisBoneAnim = val as booleanclass
				"output_fcl": 	if not isPreset or ninexp.Lock_output_fcl do \
										ninexp.doesExportMtlColorAnim = val as booleanclass
				"output_ftp": 	if not isPreset or ninexp.Lock_output_ftp do \
										ninexp.doesExportMtlTexPatternAnim = val as booleanclass
				"output_fts": 	if not isPreset or ninexp.Lock_output_fts do \
										ninexp.doesExportMtlTexSRTAnim = val as booleanclass
				"output_fsh": 	if not isPreset or ninexp.Lock_output_fsh do \
										ninexp.doesExportShapeAnim = val as booleanclass
				"output_fsn": 	if not isPreset or ninexp.Lock_output_fsn do \
										ninexp.doesExportSceneAnim = val as booleanclass
				"output_fsc": 	if not isPreset or ninexp.Lock_output_fsn do \
										ninexp.doesExportSceneAnim = val as booleanclass -- old name
				
				-- Optimization Options
				"compress_bone": (
					if not isPreset or ninexp.Lock_compress_bone do 
					(
						ninexp.compressNode = case val of
						(
							"cull": 2
							"merge": 3
							"unite": 4
							"unite_all": 5
							default: 1 -- none
						)
					)
				)
				"unite_child": 				if not isPreset or ninexp.Lock_unite_child do \
													ninexp.doesUniteChild = val as booleanclass
				"compress_material": 	if not isPreset or ninexp.Lock_compress_material do \
													ninexp.doesCompressMaterial = val as booleanclass
				"compress_shape": 		if not isPreset or ninexp.Lock_compress_shape do \
													ninexp.doesCompressShape = val as booleanclass
				-- Bake Tolerance Options
				"tolerance_scale": 			if not isPreset or ninexp.Lock_tolerance_scale do \
														ninexp.toleranceScale = val as float
				"tolerance_rotate": 			if not isPreset or ninexp.Lock_tolerance_rotate do \
														ninexp.toleranceRotate = val as float
				"tolerance_translate": 		if not isPreset or ninexp.Lock_tolerance_translate do \
														ninexp.toleranceTrans = val as float
				"tolerance_color": 			if not isPreset or ninexp.Lock_tolerance_color do \
														ninexp.toleranceColor= val as float
				"tolerance_tex_scale": 		if not isPreset or ninexp.Lock_tolerance_tex_scale do \
														ninexp.toleranceUVScale = val as float
				"tolerance_tex_rotate": 	if not isPreset or ninexp.Lock_tolerance_tex_rotate do \
														ninexp.toleranceUVRotate = val as float
				"tolerance_tex_translate":	if not isPreset or ninexp.Lock_tolerance_tex_translate do \
														ninexp.toleranceUVTrans = val as float
				 
				-- Quantization Tolerance Options
				"quantize_tolerance_scale": 			if not isPreset or ninexp.Lock_quantize_tolerance_scale do \
																	ninexp.QuantToleranceScale = val as float
				"quantize_tolerance_rotate": 			if not isPreset or ninexp.Lock_quantize_tolerance_rotate do \
																	ninexp.QuantToleranceRotate = val as float
				"quantize_tolerance_translate": 		if not isPreset or ninexp.Lock_quantize_tolerance_translate do \
																	ninexp.QuantToleranceTrans = val as float
				"quantize_tolerance_tex_scale": 		if not isPreset or ninexp.Lock_quantize_tolerance_tex_scale do \
																	ninexp.QuantToleranceUVScale = val as float
				"quantize_tolerance_tex_rotate": 	if not isPreset or ninexp.Lock_quantize_tolerance_tex_rotate do \
																	ninexp.QuantToleranceUVRotate = val as float
				"quantize_tolerance_tex_translate":	if not isPreset or ninexp.Lock_quantize_tolerance_tex_translate do \
																	ninexp.QuantToleranceUVTrans = val as float
																	
				-- Script Optinos
				"pre_export_script":	if not isPreset or ninexp.Lock_pre_export_script do \
													ninexp.PreExportScript = fdesToScript val
				"post_export_script":	if not isPreset or ninexp.Lock_post_export_script do \
													ninexp.PostExportScript = fdesToScript val
				
				-- Lock Options
				"lock_export_target": ninexp.Lock_export_target = val as booleanclass
				"lock_output_file_name": ninexp.Lock_output_file_name = val as booleanclass
				"lock_output_folder": ninexp.Lock_output_folder = val as booleanclass
				"lock_merge_fmd": ninexp.Lock_merge_fmd = val as booleanclass
				"lock_merge_ftx": ninexp.Lock_merge_ftx = val as booleanclass
				"lock_merge_anim": ninexp.Lock_merge_anim = val as booleanclass
				"lock_merge_anim_name": ninexp.Lock_merge_anim_name = val as booleanclass
				"lock_magnify": ninexp.Lock_magnify = val as booleanclass
				"lock_texsrt_mode": ninexp.Lock_texsrt_mode = val as booleanclass
				"lock_remove_namespace": ninexp.Lock_remove_namespace = val as booleanclass
				"lock_use_figure_mode": ninexp.Lock_use_figure_mode = val as booleanclass
				"lock_comment": ninexp.Lock_comment = val as booleanclass
				"lock_frame_range": ninexp.Lock_frame_range = val as booleanclass
				"lock_loop_anim": ninexp.Lock_loop_anim = val as booleanclass
				"lock_bake_all_anim": ninexp.Lock_bake_all_anim = val as booleanclass
				"lock_frame_precision": ninexp.Lock_frame_precision = val as booleanclass
				"lock_output_fmd": ninexp.Lock_output_fmd = val as booleanclass
				"lock_output_ftx": ninexp.Lock_output_ftx = val as booleanclass
				"lock_output_fsk": ninexp.Lock_output_fsk = val as booleanclass
				"lock_output_fvb": ninexp.Lock_output_fvb = val as booleanclass
				"lock_output_fcl": ninexp.Lock_output_fcl = val as booleanclass
				"lock_output_fts": ninexp.Lock_output_fts = val as booleanclass
				"lock_output_ftp": ninexp.Lock_output_ftp = val as booleanclass
				"lock_output_fsh": ninexp.Lock_output_fsh = val as booleanclass
				"lock_output_fsn": ninexp.Lock_output_fsn = val as booleanclass
				"lock_compress_bone": ninexp.Lock_compress_bone = val as booleanclass
				"lock_unite_child": ninexp.Lock_unite_child = val as booleanclass
				"lock_compress_material": ninexp.Lock_compress_material = val as booleanclass
				"lock_compress_shape": ninexp.Lock_compress_shape = val as booleanclass
				"lock_tolerance_scale": ninexp.Lock_tolerance_scale = val as booleanclass
				"lock_tolerance_rotate": ninexp.Lock_tolerance_rotate = val as booleanclass
				"lock_tolerance_translate": ninexp.Lock_tolerance_translate = val as booleanclass
				"lock_tolerance_color": ninexp.Lock_tolerance_color = val as booleanclass
				"lock_tolerance_tex_scale": ninexp.Lock_tolerance_tex_scale = val as booleanclass
				"lock_tolerance_tex_rotate": ninexp.Lock_tolerance_tex_rotate = val as booleanclass
				"lock_tolerance_tex_translate": ninexp.Lock_tolerance_tex_translate = val as booleanclass
				"lock_quantize_tolerance_scale": ninexp.Lock_quantize_tolerance_scale = val as booleanclass
				"lock_quantize_tolerance_rotate": ninexp.Lock_quantize_tolerance_rotate = val as booleanclass
				"lock_quantize_tolerance_translate": ninexp.Lock_quantize_tolerance_translate = val as booleanclass
				"lock_quantize_tolerance_tex_scale": ninexp.Lock_quantize_tolerance_tex_scale = val as booleanclass
				"lock_quantize_tolerance_tex_rotate": ninexp.Lock_quantize_tolerance_tex_rotate = val as booleanclass
				"lock_quantize_tolerance_tex_translate": ninexp.Lock_quantize_tolerance_tex_translate = val as booleanclass
				"lock_pre_export_script": ninexp.Lock_pre_export_script = val as booleanclass
				"lock_post_export_script": ninexp.Lock_post_export_script = val as booleanclass
				 
				 --default: format "WARNING: unknown key found in fdes(%=%)\n" key val
			)							
			--detect eof
			if eof fs do
			(
				isEOF = true
			)
		)
		
		close fs
		return true
	),
	
	fn saveSettingToFile filename = 
	(
		local ninexp = NintendoExport
		if ninexp == undefined do return false
		if filename == undefined do return false
		local fs = openFile filename mode:"wt"
		if fs == undefined do
		(
			format "saveSettingToFile:File Open Error(%)\n" filename
			return false
		)
		outComment fs "NW4F_Export settings"

		outVersion fs "settings_version" 350

		outValue fs "date_time" (ninexp.GetDateTimeString() as string)

		local str = "NW4F_Export for 3ds Max "
		append str (((maxVersion())[1] / 1000 + 1998) as string)
		append str (if is64bitApplication() then " x64" else " x86")
		outValue fs "tool_name" str
		
-- 		local ver = ninexp.GetVersion()
-- 		outVersion fs "tool_version" ver
		outValue fs "tool_version" (ninexp.GetVersionString())
		outReturn fs
		----------------------------------------------------------------
		outComment fs "Preset Options"
		outValue fs "preset" ninexp.PresetName
		outValue fs "show_preset_ui" ninexp.ShowPresetUI
		outReturn fs
		----------------------------------------------------------------
		outComment fs "Output Options"
		outValue fs "export_target" ( if ninexp.doesExportSelected then "selection" else "all")
		outValue fs "output_file_name" ninexp.filename
		outValue fs "output_folder" (convertBSlashToSlash ninexp.outputFolder)
		outValue fs "merge_fmd" ninexp.useMerge
		outValue fs "merge_fmd_path" (convertBSlashToSlash ninexp.mergeFilename)
		outValue fs "merge_ftx" ninexp.useMergeFtx
		outValue fs "merge_anim" ninexp.useMergeAnim
		outValue fs "merge_anim_folder" (convertBSlashToSlash ninexp.MergeAnimFolder)
		outValue fs "merge_anim_name" ninexp.MergeAnimName
		outReturn fs
		----------------------------------------------------------------
		outComment fs "General Options"
		outValue fs "magnify" ninexp.magnify
		outValue fs "texsrt_mode" "3dsmax"
		outValue fs "comment" ninexp.commentText

		outValue fs "use_figure_mode" ninexp.useFiguremode
		outValue fs "disable_zyaxis_conversion" ninexp.DisableZYAxisConversion
		outReturn fs
		----------------------------------------------------------------
		outComment fs "Animation Options"
		outValue fs "frame_range" (if ninexp.doesExportAllFrames then "all" else "range")
		outValue fs "start_frame" ninexp.StartFrame
		outValue fs "end_frame" ninexp.EndFrame
		outValue fs "loop_anim" ninexp.isLoop
		outValue fs "bake_all_anim" true
		outValue fs "frame_precision" (1.0 / ninexp.framePrecision)
		outReturn fs
		----------------------------------------------------------------
		outComment fs "Output File Selection"
		outValue fs "output_fmd" ninexp.doesExportModel
		outValue fs "output_ftx" ninexp.doesExportTexture
		outValue fs "output_fsk" ninexp.doesExportSkelAnim
		outValue fs "output_fvb" ninexp.doesExportVisBoneAnim
		outValue fs "output_fcl" ninexp.doesExportMtlColorAnim
		outValue fs "output_fts" ninexp.doesExportMtlTexSRTAnim
		outValue fs "output_ftp" ninexp.doesExportMtlTexPatternAnim
		outValue fs "output_fsh" ninexp.doesExportShapeAnim
		outValue fs "output_fsn" ninexp.doesExportSceneAnim
		outReturn fs
		----------------------------------------------------------------
		outComment fs "Optimization Options"
		outValue fs "compress_bone" ( case ninexp.compressNode of
			(
				2: "cull"
				3: "merge"
				4: "unite"
				5: "unite_all"
				default: "none"
			)
		)
		outValue fs "unite_child" ninexp.doesUniteChild
		outValue fs "compress_material" ninexp.doesCompressMaterial
		outValue fs "compress_shape" ninexp.doesCompressShape
		--outValue fs "OptimizePrimitive" ninexp.OptimizePrimitive
		outReturn fs
		----------------------------------------------------------------
		outComment fs "Animation Bake Tolerance Options"
		outValue fs "tolerance_scale" ninexp.toleranceScale
		outValue fs "tolerance_rotate" ninexp.toleranceRotate
		outValue fs "tolerance_translate" ninexp.toleranceTrans
		outValue fs "tolerance_color" ninexp.toleranceColor
		outValue fs "tolerance_tex_scale" ninexp.toleranceUVScale
		outValue fs "tolerance_tex_rotate" ninexp.toleranceUVRotate
		outValue fs "tolerance_tex_translate" ninexp.toleranceUVTrans
		outReturn fs
		----------------------------------------------------------------
		outComment fs "Animation Quantization Tolerance Options"
		--outValue fs "quantize_tolerance_frame" ninexp.QuantToleranceFrame
		outValue fs "quantize_tolerance_scale" ninexp.QuantToleranceScale
		outValue fs "quantize_tolerance_rotate" ninexp.QuantToleranceRotate
		outValue fs "quantize_tolerance_translate" ninexp.QuantToleranceTrans
		outValue fs "quantize_tolerance_tex_scale" ninexp.QuantToleranceUVScale
		outValue fs "quantize_tolerance_tex_rotate" ninexp.QuantToleranceUVRotate
		outValue fs "quantize_tolerance_tex_translate" ninexp.QuantToleranceUVTrans
		outReturn fs
		----------------------------------------------------------------
		outComment fs "Script Options"
		outValue fs "pre_export_script" (scriptToFdes ninexp.PreExportScript)
		outValue fs "post_export_script" (scriptToFdes ninexp.PostExportScript)
		outReturn fs
		----------------------------------------------------------------
		outComment fs "Lock Options"
		outValue fs "lock_export_target" ninexp.Lock_export_target
		outValue fs "lock_output_file_name" ninexp.Lock_output_file_name
		outValue fs "lock_output_folder" ninexp.Lock_output_folder
		outValue fs "lock_merge_fmd" ninexp.Lock_merge_fmd
		outValue fs "lock_merge_ftx" ninexp.Lock_merge_ftx
		outValue fs "lock_merge_anim" ninexp.Lock_merge_anim
		outValue fs "lock_merge_anim_name" ninexp.Lock_merge_anim_name
		outValue fs "lock_magnify" ninexp.Lock_magnify
		outValue fs "lock_texsrt_mode" ninexp.Lock_texsrt_mode
		outValue fs "lock_remove_namespace" ninexp.Lock_remove_namespace
		outValue fs "lock_use_figure_mode" ninexp.Lock_use_figure_mode
		outValue fs "lock_comment" ninexp.Lock_comment
		outValue fs "lock_frame_range" ninexp.Lock_frame_range
		outValue fs "lock_loop_anim" ninexp.Lock_loop_anim
		outValue fs "lock_bake_all_anim" ninexp.Lock_bake_all_anim
		outValue fs "lock_frame_precision" ninexp.Lock_frame_precision
		outValue fs "lock_output_fmd" ninexp.Lock_output_fmd
		outValue fs "lock_output_ftx" ninexp.Lock_output_ftx
		outValue fs "lock_output_fsk" ninexp.Lock_output_fsk
		outValue fs "lock_output_fvb" ninexp.Lock_output_fvb
		outValue fs "lock_output_fcl" ninexp.Lock_output_fcl
		outValue fs "lock_output_fts" ninexp.Lock_output_fts
		outValue fs "lock_output_ftp" ninexp.Lock_output_ftp
		outValue fs "lock_output_fsh" ninexp.Lock_output_fsh
		outValue fs "lock_output_fsn" ninexp.Lock_output_fsn
		outValue fs "lock_compress_bone" ninexp.Lock_compress_bone
		outValue fs "lock_unite_child" ninexp.Lock_unite_child
		outValue fs "lock_compress_material" ninexp.Lock_compress_material
		outValue fs "lock_compress_shape" ninexp.Lock_compress_shape
		outValue fs "lock_tolerance_scale" ninexp.Lock_tolerance_scale
		outValue fs "lock_tolerance_rotate" ninexp.Lock_tolerance_rotate
		outValue fs "lock_tolerance_translate" ninexp.Lock_tolerance_translate
		outValue fs "lock_tolerance_color" ninexp.Lock_tolerance_color
		outValue fs "lock_tolerance_tex_scale" ninexp.Lock_tolerance_tex_scale
		outValue fs "lock_tolerance_tex_rotate" ninexp.Lock_tolerance_tex_rotate
		outValue fs "lock_tolerance_tex_translate" ninexp.Lock_tolerance_tex_translate
		outValue fs "lock_quantize_tolerance_scale" ninexp.Lock_quantize_tolerance_scale
		outValue fs "lock_quantize_tolerance_rotate" ninexp.Lock_quantize_tolerance_rotate
		outValue fs "lock_quantize_tolerance_translate" ninexp.Lock_quantize_tolerance_translate
		outValue fs "lock_quantize_tolerance_tex_scale" ninexp.Lock_quantize_tolerance_tex_scale
		outValue fs "lock_quantize_tolerance_tex_rotate" ninexp.Lock_quantize_tolerance_tex_rotate
		outValue fs "lock_quantize_tolerance_tex_translate" ninexp.Lock_quantize_tolerance_tex_translate
		outValue fs "lock_pre_export_script" ninexp.Lock_pre_export_script
		outValue fs "lock_post_export_script" ninexp.Lock_post_export_script
		----------------------------------------------------------------
		close fs
		return true
	),
	
	fn parseCommandOptions opt =
	(
		if classof opt != String do return false
		
		local ss = stringstream ""
		print @"# NW4F_Export settings" to:ss
		
		local comList = stringToList opt
		local err = false
		local i = 1
		
		while (i < comList.count) and (not err) do
		(
			local com = comList[i]
			if com[1] != "-" do
			(
				err = true
				continue
			)
			com = substring  com 2 (com.count - 1)
			local val = comList[i + 1]
			
			local notFind = true
			for p in NintendoExportOptionPairArray while notFind do
			(
				--format "%, %\n" p[1] p[2]
				if p[2] == com do
				(
					--format "find %\n" com
					notFind = false
					com = p[1]
				)
			)
			
			val = case com of
			(
				"pre_export_script": (scriptToFdes val)
				"post_export_script": (scriptToFdes val)
				default: val
			)
			
			format "%=\"%\"\n" com val  
			format "%=\"%\"\n" com val  to:ss
			i += 2
		)
		
		if err do
		(
			format "command error(%)\n" opt
			return false
		)
		
		loadSettingFromFile "" stream:ss
		
		return true
	),
	
	fn getSettingFilename =
	(
		local fname = GetDir #plugcfg
		append fname "\\NintendoExport.ini"
		return fname
	),
	
	fn loadSettingConfig =
	(
		local fname = getSettingFilename()
		local val
		val = getINISetting fname "nw4f_exporter" "enableSaveToScene"
		enableSaveToScene = if val == "false" then false else true
		
		val = getINISetting fname "nw4f_exporter" "showDisableZYAxisConversion"
		showDisableZYAxisConversion = if val == "true" then true else false
		
		val = getINISetting fname "nw4f_exporter" "displayIntegerInHex"
		displayIntegerInHex = if val == "true" then true else false
			
		recentFdes = #()
		for i = 1 to 10 do
		(
			local key = "recentFdesFile" + (i as String)
			val = getINISetting fname "nw4f_exporter" key
			if val.count > 0 do
			(
				append recentFdes val
			)
		)
	),
	
	
	fn saveSettingConfig =
	(
		local fname = getSettingFilename()
		setINISetting fname "nw4f_exporter" "enableSaveToScene" (enableSaveToScene as string)
		setINISetting fname "nw4f_exporter" "showDisableZYAxisConversion" (showDisableZYAxisConversion as string)
		setINISetting fname "nw4f_exporter" "displayIntegerInHex" (displayIntegerInHex as string)
		for i = 1 to recentFdes.count do
		(
			local key = "recentFdesFile" + (i as String)
			setINISetting fname "nw4f_exporter" key  recentFdes[i]
		)
	),
	
	fn loadSettingDefault =
	(
		local fname = GetDir #plugcfg
		append fname "\\NintendoExport.fdes"
		
		if not (doesFileExist fname) do return false
		(
			loadSettingFromFile fname 
			loadSettingConfig()
		)
	),
	
	fn saveSettingDefault =
	(
		local fname = GetDir #plugcfg
		append fname "\\NintendoExport.fdes"
		saveSettingToFile fname 
		saveSettingConfig()
	),
	
	fn SearchAndSetAnimations isSelected:false =
	(
		local ninexp = NintendoExport
		local animStr = ninexp.searchAnimations isSelected
		local anims = filterString animStr ", "
		
		(
			--ninexp.doesExportModel = false 
			ninexp.doesExportSkelAnim  = false 
			ninexp.doesExportVisBoneAnim  = false 
			ninexp.doesExportMtlColorAnim  = false 
			ninexp.doesExportMtlTexSRTAnim  = false 
			ninexp.doesExportMtlTexPatternAnim  = false 
			ninexp.doesExportShapeAnim = false
			--ninexp.doesExportSceneAnim = false
			
			for str in anims do
			(
				case str of
				(
					"FSK": ninexp.doesExportSkelAnim = true
					"FVB": ninexp.doesExportVisBoneAnim = true
					"FCL": ninexp.doesExportMtlColorAnim = true
					"FTS": ninexp.doesExportMtlTexSRTAnim = true
					"FTP": ninexp.doesExportMtlTexPatternAnim = true
					"FSH": ninexp.doesExportShapeAnim = true
					--"FSN": ninexp.doesExportSceneAnim = true
				)
			)
		)
	),
	
	fn appendRecentFdes fname = 
	(
		loadSettingConfig()
		local idx  = findItem recentFdes fname
		while idx > 0 do
		(
			deleteItem recentFdes idx
			idx = findItem recentFdes fname
		)
		
		insertItem fname recentFdes 1
		while (recentFdes.count > 10) do (deleteItem recentFdes 11)
		saveSettingConfig()
	),
	
	fn getPresetsFolder =
	(
		local pPath
		pPath = systemTools.getEnvVariable "NINTENDO_3DSMAX_PRESETS"
		if pPath != undefined do return pPath

		pPath = systemTools.getEnvVariable "NW4F_3DSMAX_PRESETS"
		if pPath != undefined do return pPath

		pPath = systemTools.getEnvVariable "NINTENDO_SDK_ROOT"
		if pPath != undefined do 
		(
			pPath = pathConfig.appendPath pPath @"\Tools\Graphics\3dsMaxPlugins\Config\Presets\"
			if not (doesFileExist pPath) do
			(
				makeDir pPath
			)
			if (doesFileExist pPath) do return pPath
			pPath = undefined
		)

		pPath = systemTools.getEnvVariable "NW4F_ROOT"
		if pPath != undefined do 
		(
			pPath = pathConfig.appendPath pPath @"\Tool\DccPlugin\3dsMax\Config\Presets\"
			if not (doesFileExist pPath) do
			(
				makeDir pPath
			)
			if (doesFileExist pPath) do return pPath
			pPath = undefined
		)
		
		return pPath
	),
	
	fn loadPresetFile filename =
	(
		if not (doesFileExist filename) do
		(
			messageBox ("preset file not found\n" + filename)
			return()
		)
		if not (loadSettingFromFile filename isPreset:true) do
		(
			messageBox ("preset load error\n" + filename)
		)
	),
	
	fn loadPresetByName presetname =
	(
		local presetsPath = getPresetsFolder()
		local filename = pathConfig.appendPath presetsPath (presetname + ".fdes")
		loadPresetFile filename
	),
	
	fn getMultiExportAttributes =
	(
		local attribList = #()
		for ca in rootnode.custAttributes do
		(
			if classof ca == nw4f_multiexport_custom_attribute do
			(
				append attribList ca
			)
		)
		return attribList
	),
	
	fn DoExportItem attr =
	(
		if classof attr != nw4f_multiexport_custom_attribute do return false
		local ninexp = NintendoExport
		local exportSelected = false
		
		format "\n--- Export Item (%) ---\n" attr.Filename
		local fpath = attr.Folder
		if fpath.count > 0 do
		(
			if not (pathConfig.isAbsolutePath fpath) then
			(
				fpath = pathConfig.convertPathToAbsolute  (pathConfig.appendPath maxFilePath fpath)
			)
			
			if  not (doesFileExist fpath) do
			(
				if  not (makeDir fpath all:true) do
				(
					format "Output Folder is wrong(%)\n" attr.Folder
					return undefined
				)
			)
		)
		
		if attr.FdesFile.count > 0 do 
		(
			local fname = attr.FdesFile
			if not (pathConfig.isAbsolutePath fname) do fname = pathConfig.convertPathToAbsolute  (pathConfig.appendPath maxFilePath fname)
			if  not (doesFileExist fname) do
			(
				format "fdes file not found(%)\n" attr.FdesFile
				return undefined
			)
			
			loadSettingFromFile fname
		)
		
		local mname = attr.MergeFmdFile
		if mname.count > 0 do
		(
			if not (pathConfig.isAbsolutePath mname) then
			(
				mname = pathConfig.convertPathToAbsolute  (pathConfig.appendPath maxFilePath mname)
			)
			if  not (doesFileExist mname) do
			(
				format "fdes file not found(%)\n" attr.MergeFmdFile
				return undefined
			)
		)
		
		if attr.Nodes.count > 0 do
		(
			local nodes = stringToList attr.Nodes
			if nodes.count > 0 do
			(
				exportSelected = true
				clearNodeSelection()
				for nodename in nodes do
				(
					local n = getNodeByName nodename
					if n != undefined do selectMore n
				)
			)
		)
		
		if attr.DispLayers.count > 0 do
		(
			local lman = LayerManager
			local layers = stringToList attr.DispLayers
			if lman.count > 0 and layers.count > 0 do
			(
				for i = 0 to (lman.count - 1) do
				(
					local layer = lman.getLayer i
					layer.on = ((findItem layers layer.name) > 0)
				)
			)
		)
		
		if attr.AnimLayers.count > 0 do
		(
			local alman = AnimLayerManager
			local layers = stringToList attr.AnimLayers
			if alman.getLayerCount() > 0  and layers.count > 0  do
			(
				for i = 1 to alman.getLayerCount() do
				(
					alman.setLayerMute i ((findItem layers (alman.getLayerName i)) == 0)
				)
			)
		)
		
		ninexp.filename = attr.Filename
		if fpath.count > 0 do ninexp.outputFolder = fpath
		ninexp.useMerge = attr.MergeFmd
		if mname.count > 0 do ninexp.mergeFilename = mname
		if attr.Comment.count > 0 do ninexp.commentText = attr.Comment
		ninexp.doesExportAllFrames = attr.ExportAllFrames 
		ninexp.startFrame = attr.StartFrame
		ninexp.endFrame = attr.EndFrame
		ninexp.isLoop = attr.LoopAnim
		ninexp.doesExportModel  = attr.ExportModel
		ninexp.doesExportTexture = attr.ExportTexture
		ninexp.doesExportSkelAnim = attr.ExportSkeletalAnim
		ninexp.doesExportVisBoneAnim = attr.ExportBoneVisAnim
		ninexp.doesExportMtlColorAnim = attr.ExportMtlColorAnim
		ninexp.doesExportMtlTexPatternAnim = attr.ExportMtlTexPatternAnim
		ninexp.doesExportMtlTexSRTAnim = attr.ExportMtlTexSRTAnim
		ninexp.doesExportSceneAnim = attr.ExportSceneAnim
		ninexp.doesExportShapeAnim = attr.ExportShapeAnim
		
		ninexp.doesExportSelected = exportSelected
		
		if attr.Options.count > 0 do
		(
			parseCommandOptions attr.Options
		)
		
		/*
		if exportSelected == false do
		(
			exportSelected = ninexp.doesExportSelected
		)
		*/
		

		if ninexp.presetName.count > 0 do
		(
			loadPresetByName ninexp.presetName
		)
		
		try
		(
			local ret = ninexp.doExport ninexp.doesExportSelected
			--format "%" (ninexp.GetErrorLog())
			if not ret do 
			(
				--errCount = errCount + 1
				--append errFiles (f + "\n")
				format "Export Error\n"
				--format "Export Error\n" to:errfs
			)
		)
		catch
		(
			format "Unknown System Error\n"
			--format "Unknown System Error\n" to:errfs
			--errCount = errCount + 1
			--append errFiles (f + "\n")
		)
	),
	
	fn MultiExport selected:#() =
	(
		local attribList = getMultiExportAttributes()
		if attribList.count == 0 do return false
		if (classof selected != Array) or (selected.count == 0) do
		(
			selected = #()
			for i = 1 to attribList.count do append selected i
		)
		
		saveSettingDefault()
		
		-- save displayer and animlayer
		local dispLayerInfo = #()
		local animLayerInfo = #()
		local lman = LayerManager
		-- LayerManager  0x[X
		for i = 0 to (lman.count - 1) do
		(
			local layer = lman.getLayer i
			append dispLayerInfo layer.on
			--format "%:%\n" layer.name layer.on
		)
		local alman = AnimLayerManager
		for i = 1 to alman.getLayerCount() do
		(
			append animLayerInfo (alman.getLayerMute i)
			--format "%:%\n" (alman.getLayerName i) (alman.getLayerMute i)
		)
		
		format "\n========== NW4F_Multi_Export_Begin ==========\n"
		-- export item
		for i in selected do
		(
			if i > 0 and i <= attribList.count do
			(
				local attr = attribList[i]
				DoExportItem attr
				loadSettingDefault()
			)
			-- restore displayer and animlayer
			-- LayerManager  0x[X
			for i = 0 to (lman.count - 1) do
			(
				local layer = lman.getLayer i
				local maxid = i + 1
				layer.on = dispLayerInfo[maxid]
			)
			for i = 1 to alman.getLayerCount() do
			(
				alman.setLayerMute i animLayerInfo[i]
			)
		)
		format "\n========== NW4F_Multi_Export_End ==========\n"
	),
	
	
	fn GetMatAnimExtensions =
	(
		local ninexp = NintendoExport
		local exts = #("","","")
		if ninexp.GetUseFclFtsFtp() then
		(
			exts[1] = ".fclb"
			exts[2] = ".ftsb"
			exts[3] = ".ftpb"
		)
		else 
		(
			if ninexp.GetSeparateMaterialAnim() then
			(
				exts[1] = "_fcl.fmab"
				exts[2] = "_fts.fmab"
				exts[3] = "_ftp.fmab"
			)
			else
			(
				exts[1] = ".fmab"
				exts[2] = ".fmab"
				exts[3] = ".fmab"
			)
		)
		return exts
	),

	fn checkOverwriteFiles fName =
	(
		local ninexp = NintendoExport
		local owflag = false
		if ninexp.doesExportModel and  doesFileExist(fName + ".fmdb") do ( owflag = true)
		if ninexp.doesExportSkelAnim and  doesFileExist(fName + ".fskb") do ( owflag = true)
		if ninexp.doesExportVisBoneAnim and  doesFileExist(fName + ".fvbb") do ( owflag = true)

		local exts = GetMatAnimExtensions()
		if ninexp.doesExportMtlColorAnim and  doesFileExist(fName + exts[1]) do ( owflag = true)
		if ninexp.doesExportMtlTexSRTAnim and  doesFileExist(fName + exts[2]) do ( owflag = true)
		if ninexp.doesExportMtlTexPatternAnim and  doesFileExist(fName + exts[3]) do ( owflag = true)
		
		/*
		if ninexp.GetUseFclFtsFtp() then
		(
			if ninexp.doesExportMtlColorAnim and  doesFileExist(fName + ".fclb") do ( owflag = true)
			if ninexp.doesExportMtlTexPatternAnim and  doesFileExist(fName + ".ftpb") do ( owflag = true)
			if ninexp.doesExportMtlTexSRTAnim and  doesFileExist(fName + ".ftsb") do ( owflag = true)
		)
		else 
		(
			if ninexp.GetSeparateMaterialAnim() then
			(
				if ninexp.doesExportMtlColorAnim and  doesFileExist(fName + "_fcl.fmab") do ( owflag = true)
				if ninexp.doesExportMtlTexPatternAnim and  doesFileExist(fName + "_ftp.fmab") do ( owflag = true)
				if ninexp.doesExportMtlTexSRTAnim and  doesFileExist(fName + "_fts.fmab") do ( owflag = true)
			)
			else
			(
				if ninexp.doesExportMtlColorAnim or ninexp.doesExportMtlTexPatternAnim or ninexp.doesExportMtlTexSRTAnim do
				(
					if doesFileExist(fName + ".fmab") do ( owflag = true)
				)
			)
		)
		*/

 		if ninexp.doesExportSceneAnim and  doesFileExist(fName + ".fsnb") do ( owflag = true)
 		if ninexp.doesExportShapeAnim and  doesFileExist(fName + ".fshb") do ( owflag = true)
		
			
		if owflag == false do
		(
			return true
		)

		mes = fName + ".*\n" + " already exists.\nOverwrite ?"
		local ret = queryBox mes title:"confirm overwrite"
		return ret
	)
)

/********************************************************
struct nw4f_userData
 ********************************************************/
struct nw4f_userData
(
	dataname = "",
	type = "ASCII",
	val = #(),
	nodes = #(),
	
	fn copyTo dst = 
	(
		if (classof dst) != nw4f_userData do return false
		dst.dataname = dataname
		dst.type = type
		dst.val = deepCopy val
		dst.nodes= deepCopy nodes
		return true
	),
	fn valueToString oneline:false inHex:false = 
	(
		local str = ""
		for j = 1 to val.count do
		(
			if j != 1 do
			(
				str += if (not oneline) and (type == "ASCII" or type == "Unicode") then "\n" else " "
			)
			if inHex and (type == "Integer") then
			(
				str += (NintendoExportUtilities()).intToHexString val[j]
			)
			else
			(
				str += (val[j] as string)
			)
		)
		return str
	),
	fn valueCount = 
	(
		local ret = 0
		if (type == "ASCII" or type == "Unicode") then
		(
			for v in val do
			(
				ret += v.count
			)
		)
		else
		(
			ret = val.count
		)
		return ret 
	),
	fn toString = 
	(
		local str = dataname
		str += "\""
		str += case type of
		(
			"Integer": "i"
			"Float": "f"
			"Unicode": "w"
			default: "s" -- "ASCII"
		)
		str += " "
		str += valueToString()
		str += "\""
		return str
	),
	fn fromString s = 
	(
		local tokens = filterString s "\""
		if tokens.count != 2 do return false
		dataname = tokens[1]
		
		local valStr = tokens[2]
		case valStr[1] of
		(
			"i": type = "Integer"
			"f": type = "Float"
			"w": type = "Unicode"
			default: type = "ASCII" -- "s"
		)
		val = #( )
	
		local valTokens = #()
		
		if (type == "ASCII" or type == "Unicode") then
		(
			valTokens = filterString (substring valStr 3 -1) "\n"
		)
		else
		(
			valTokens = filterString (substring valStr 3 -1) " "
		)
		
		for i = 1 to valTokens.count do
		(
			local v = case type of
			(
				"Integer": (valTokens[i] as Integer)
				"Float": (valTokens[i] as Float)
				"Unicode": (valTokens[i])
				default: (valTokens[i]) -- "ASCII"
			)
			if v != undefined do
			(
				append val v
			)
		)
		return true
	),
	fn compare target =
	(
		return (toString()) == (target.toString())
	)
)

/********************************************************
struct nw4f_userDataSet
 ********************************************************/
struct nw4f_userDataSet
(
	list = #(),
	fn appendData data = 
	(
		if (classof data) != nw4f_userData do return false
		append list data
	),
	fn appendDataUnique data datanode = 
	(
		if (classof data) != nw4f_userData do return false
		for d in list do
		(
			if (d.compare data) then
			(
				appendIfUnique d.nodes datanode
				return ()
			)
		)
		appendIfUnique data.nodes datanode
		append list data
	),
	fn toString = 
	(
		local ret = ""
		if (classof list) != Array do return ""
		for i = 1 to list.count do
		(
			local data = list[i]
			if (classof data) != nw4f_userData do continue
			if i != 1 do ret += " "
			ret += data.toString()
		)
		return ret
	),
	fn fromString s = 
	(
		if (classof s) != String do return false
		list = #()
		local p = 1
		while p <= s.count do
		(
			while s[p] == " " and p < s.count do p += 1 -- Xy[XXLbv
			local ep = p
			while s[ep] != "\"" and ep < s.count do ep += 1 -- ŏ"T
			ep += 1
			while s[ep] != "\"" and ep <= s.count do ep += 1 -- Ō"T
			if ep <= s.count do
			(
				local len = ep - p + 1
				local d = nw4f_userData()
				if (d.fromString (substring s p len) ) do
				(
					append list d
				)
			)
			p = ep + 1
		)
		return true
	),
	fn count =
	(
		return list.count
	),
	fn getFromAttribute attr = 
	(
		list = #()
	),
	fn setToAttribute attr = 
	(
	)
)

-- common user data setting
nw4fEditUserDataRollout_Value = undefined 
nw4fEditUserDataRollout_ValueSet = undefined 
nw4fEditUserDataRollout_ValueIniInHex = false

/********************************************************
nw4fEditUserDataRollout
 ********************************************************/
rollout nw4fEditUserDataRollout "Edit User Data" width:320 --height:380
(
	--label lblHolder "Holders" align:#left
group "Holders"
(
	label lblHolderName "" align:#left width:290
)
group "Edit Data"
(
	editText editName "Name" align:#left
	radioButtons rdoType "Type"  labels:#("Integer", "Float", "ASCII String", "Unicode String") columns:2 align:#left
	label lblNumber "String or Number : (One value per line)" align:#left
	editText editNumber "" height: 200 align:#left
)
	label lbl3 "" across:3
	button btnOK "Ok" width:80
	button btnCancel "Cancel" width:80
	
	fn isValidName n org= 
	(
		if (classof n) != String do return false
		local c, f = true
		for i = 1 to n.count while f do
		(
			c = n[i]
			f = false
			f = f or ("A" <= c and c <= "Z") or ("a" <= c and c <= "z") 
			f = f or ("0" <= c and c <= "9")
			--f = f or (c == "-") or (c == "_") or (c == ".")
			f = f or (c == "_")
		)
		if (not f) do 
		(
			messagebox ("invalid character used in name(" + c + ")")
			return false
		)
		-- find same name
		if n != org do
		(
			local list = nw4fEditUserDataRollout_ValueSet.list
			for d in list do
			(
				if d != nw4fEditUserDataRollout_Value and d.dataname == n do -- f[^ւ̎QƂ͏
				(
					messagebox ("Can't use same name")
					return false
				)
			)
		)
		return true
	)
	
	fn isValidString s = 
	(
		if (classof s) != String do return false
		local c, f = true
		for i = 1 to s.count while f do
		(
			c = s[i]
			f = (c == "<") or (c == ">") or (c == "&") or (c == "'") or (c == "\"")
			if f do 
			(
				messagebox ("invalid character used in String(" + c + ")")
				return false
			)
		)
		return true
	)
	
	fn updateView = 
	(
		if 	(classof nw4fEditUserDataRollout_Value) == nw4f_userData and \
			(classof nw4fEditUserDataRollout_ValueSet) == nw4f_userDataSet do
		(
			local data = nw4fEditUserDataRollout_Value
			editName.text = data.dataname
			rdoType.state = case data.type of
			(
				"Integer": 1
				"Float": 2
				"Unicode": 4
				default: 3 -- "ASCII"
			)

			(
				local str = ""
				for i = 1 to data.val.count do
				(
					if nw4fEditUserDataRollout_ValueIniInHex and (data.type == "Integer") then
					(
						str += ((NintendoExportUtilities()).intToHexString data.val[i]) + "\n"
					)
					else
					(
						str += (data.val[i] as String) + "\n"
					)
				)
				editNumber.text = str
			)
		)
	)
	
	on nw4fEditUserDataRollout open do
	(
		if 	(classof nw4fEditUserDataRollout_Value) == nw4f_userData and \
			(classof nw4fEditUserDataRollout_ValueSet) == nw4f_userDataSet then
		(
			--lblTarget.visible = chkTargetModel.visible = chkTargetAnim.visible = \
			--	nw4cEditUserDataRollout_IsModeNode
			
			local data = nw4fEditUserDataRollout_Value
			if data.nodes.count > 0 then
			(
				local selnodetext = ""
				
				for n in data.nodes do
				(
					selnodetext += if (selnodetext=="") then "" else ", "
					selnodetext += n.name
				)
				lblHolderName.text = selnodetext
			)
			else
			(
				lblHolderName.text = ""				
			)
			updateView()
		)
		else
		(
			messagebox "value error"
			DestroyDialog nw4fEditUserDataRollout
		)
	)
	
	on btnOK pressed do
	(
		if (classof nw4fEditUserDataRollout_Value) == nw4f_userData do
		(
			local orgname = nw4fEditUserDataRollout_Value.dataname
			local data = nw4f_userData()
			data.nodes = deepcopy nw4fEditUserDataRollout_Value.nodes

			if editName.text.count == 0 do
			(
				messagebox "Name is Empty"
				return()
			)
			
			
			if (not (isValidName editName.text orgname)) do
			(
				return()
			)
			
			data.dataname = editName.text
			data.type = case rdoType.state of
			(
				1: "Integer"
				2: "Float"
				4: "Unicode"
				default: "ASCII"
			)
			
			local vs = filterString  editNumber.text "\n"
			if vs.count == 0 do
			(
				messagebox "Number is Empty"
				return()
			)
			
			for i = 1 to vs.count do
			(
				local v = case data.type of
				(
					"Integer": (
						if nw4fEditUserDataRollout_ValueIniInHex then
						(
							-- W16iϊ͐xႢ߁A.netg
							-- 16iƂăRo[gł邩`FbN
							local tmp = ("0x" + vs[i]) as Integer
							if tmp == undefined then 
							(
								undefined
							)
							else
							(
								(dotNetClass "System.Convert").ToInt32 vs[i] 16
							)
						)
						else
						(
							vs[i] as Integer
						) 
					)
					"Float": (vs[i] as Double)
					"Unicode": (vs[i] as String)
					default: (vs[i] as String) -- "ASCII"
				)
				if v == undefined do
				(
					local mes = "Value is not valid(" + vs[i] + ")"
					messagebox mes
					return()
				)
				append data.val v
			)
			if data.val.count == 0 do
			(
				messagebox "Number is Empty"
				return()
			)
			data.dataname = editName.text
			data.copyTo nw4fEditUserDataRollout_Value
		)
		DestroyDialog nw4fEditUserDataRollout
	)
	
	on btnCancel pressed do
	(
		nw4fEditUserDataRollout_Value = undefined
		DestroyDialog nw4fEditUserDataRollout
	)
	on rdoType changed val do
	(
/*
		editString.enabled = (val == 1)
		lblString.enabled = (val == 1)
		editNumber.enabled = (val != 1)
		lblNumber.enabled = (val != 1)
*/
	)
)

nw4fEditMultiExportRollout_Value = undefined 
nw4fEditMultiExportRollout_NeedDelete = undefined 
nw4fEditMultiExportRollout_EndEdit = undefined 
nw4fEditMultiExportRollout_SetFdes = undefined

rcMenu NW4FRecentFdesMenu
(
	menuItem mi_Recent1 "-" --filter:filter1
	menuItem mi_Recent2 "-" --filter:filter2
	menuItem mi_Recent3 "-" --filter:filter3
	menuItem mi_Recent4 "-" --filter:filter4
	menuItem mi_Recent5 "-" --filter:filter5
	menuItem mi_Recent6 "-" --filter:filter6
	menuItem mi_Recent7 "-" --filter:filter7
	menuItem mi_Recent8 "-" --filter:filter8
	menuItem mi_Recent9 "-" --filter:filter9
	menuItem mi_Recent10 "-" --filter:filter10
	
	fn selFdes mi =
	(
		if mi.text.count > 0 do
		(
			nw4fEditMultiExportRollout_SetFdes mi.text
		)
	)
	
	on mi_Recent1 picked do selFdes mi_Recent1
	on mi_Recent2 picked do selFdes mi_Recent2
	on mi_Recent3 picked do selFdes mi_Recent3
	on mi_Recent4 picked do selFdes mi_Recent4
	on mi_Recent5 picked do selFdes mi_Recent5
	on mi_Recent6 picked do selFdes mi_Recent6
	on mi_Recent7 picked do selFdes mi_Recent7
	on mi_Recent8 picked do selFdes mi_Recent8
	on mi_Recent9 picked do selFdes mi_Recent9
	on mi_Recent10 picked do selFdes mi_Recent10
)

/********************************************************
nw4fEditMultiExportRollout
 ********************************************************/
rollout nw4fEditMultiExportRollout "Input Multi Export Item" width:460
(
	label lblFilename "Output File Name"  align:#left across: 4 
	editText editFilename ""  width:240 align:#left  offset:[-20,0]
	button btnNameScene "Scene"  width:45 height:16 align:#right offset:[60,0]
	button btnNameNode "Node"  width:45 height:16 align:#right  

	label lblFilepath "    Output Folder"  width:100 height:20 align:#left across:4 
	editText editFilepath ""  width:320 offset:[-20,0]
	label lblDummy0 ""
	button btnSelectPath "..."  width:20 height:16 toolTip:"Select folder" align:#right

groupBox grp1 "" height:7 width:500 offset:[-30,0]
	checkbox chkMergeModel "Merge fmd File"  height:16 align:#left across:4
	editText editMergeFile ""  width:300 offset:[0,0]
	label lblDummy1 ""
	button btnSelectMerge "..."  width:20 height:16 toolTip:"Select Merge File" align:#right
	
groupBox grp2 "" height:7 width:500 offset:[-30,0]
	label lblFdespath "         fdes File"  width:100 height:20 align:#left across:4 
	editText editFdespath ""  width:332 offset:[-30,0]
	label lblDummy2 ""
	button btnSelectFdes "..."  width:20 height:16 toolTip:"Select fdes" align:#right
	
	label lblDummy3 "" across:4
	button btnRecentFdes "Recent fdes"  offset:[-30,0]
	button btnLoadFdes "Load fdes to Scene"  
	label lblDummy4 ""

groupBox grp3 "" height:7 width:500 offset:[-30,0]
	label lblNodename "Node"  align:#right offset:[-30,0] across: 4 
	editText editNodename ""  width:256 align:#left  offset:[-30,0]
	button btnNodeGet "Get"  width:45 height:16 align:#right offset:[60,0]
	button btnNodeSet "Select"  width:45 height:16 align:#right  
	
	label lblLayername "Layer"  align:#right offset:[-30,0]  across: 4 
	editText editLayername ""  width:256 align:#left  offset:[-30,0]
	button btnLayerGet "Get"  width:45 height:16 align:#right offset:[60,0]
	button btnLayerSet "Set"  width:45 height:16 align:#right  
	
	label lblAnimLayername "Anim Layer"  align:#right offset:[-30,0]  across: 4 
	editText editAnimLayername ""  width:256 align:#left  offset:[-30,0]
	button btnAnimLayerGet "Get"  width:45 height:16 align:#right offset:[60,0]
	button btnAnimLayerSet "Set"  width:45 height:16 align:#right  

groupBox grp4 "" height:7 width:500 offset:[-30,0]
	editText editComment "Comment"

groupBox grp5 "" height:7 width:500 offset:[-30,0]
	label lblTimeRange "Start/End Frame"  width:112 height:20 across:4 align:#left
	radioButtons rdoTimeRange ""  width:104 height:16 labels:#("All", "Range") columns:2  align:#left
	spinner spnTimeStart ""  width:64 height:16 range:[0,100000,0] type:#integer scale:1  align:#left
	spinner spnTimeEnd ""  width:64 height:16 range:[0,100000,100] type:#integer scale:1  align:#left offset:[-40,0]
	checkbox chkAnimationLoop "Loop"  align:#center

groupBox grp6 "" height:7 width:500 offset:[-30,0]
	label lblExportModel "Model Data " align:#right offset:[20,0] across:3
	checkbox chkExportModel "[.fmdb]" align:#left offset:[20,0]
	button btnGetFromFdes "Get from fdes" height:16 align:#left

	label lblExportTex "Texture Data " align:#right offset:[20,0] across:3
	checkbox chkExportTex "[.ftxb]" align:#left offset:[20,0]
	label DummyA02 ""

	label lblExportSkelAnim "Character Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportSkelAnim "[.fskb]" align:#left offset:[20,0]
	label DummyA03 ""

	label lblExportMdlAnim "Bone Visibility Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportVisBoneAnim "[.fvbb]" align:#left offset:[20,0] --enabled:false
	label DummyA04 ""

	label lblExportMtlCol "Material Color Animation Data " align:#right offset:[20,0]  across:3
	checkbox chkExportMtlCol "[.fclb]" align:#left offset:[20,0] --enabled:false
	label DummyA05 ""
	
	label lblExportTexSRT "Texture SRT Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportTexSRT "[.ftsb]" align:#left offset:[20,0] --enabled:false
	label DummyA06 ""

	label lblExportTexPat "Texture Pattern Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportTexPat "[.ftpb]" align:#left offset:[20,0]
	label DummyA07 ""

	label lblExportShape "Shape Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportShape "[.fshb]" align:#left offset:[20,0]
	label DummyA08 ""

	label lblExportScene "Scene Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportScene "[.fsnb]" align:#left offset:[20,0]
	label DummyA09 ""

groupBox grp7 "" height:7 width:500 offset:[-30,0]
	editText editOptions "Additional Options" height:96

	label lbl3 "" across:5
	label lbl4 "" 
	label lbl5 "" 
	--label lbl6 "" 
	button btnOK "Ok" width:80
	button btnCancel "Cancel" width:80
	
	local attr = undefined
	local utils = NintendoExportUtilities()
	
	fn redrawItems =
	(
		chkMergeModel.enabled  = chkExportModel.state
		editMergeFile.enabled = btnSelectMerge.enabled = chkMergeModel.state and chkExportModel.state
		spnTimeStart.enabled = spnTimeEnd.enabled = (rdoTimeRange.state == 2)	
		
		chkAnimationLoop.enabled =  (chkExportSkelAnim.state or chkExportVisBoneAnim.state  or chkExportMtlCol.state or chkExportTexPat.state \
			or chkExportTexSRT.state or chkExportScene.state or chkExportShape.state ) 
			
		local exts = utils.GetMatAnimExtensions()
		chkExportMtlCol.text   = "[" + exts[1] + "]"
		chkExportTexSRT.text = "[" + exts[2] + "]"
		chkExportTexPat.text  = "[" + exts[3] + "]"
	)
	
	fn loadItems = 
	(
		editFilename.text = attr.Filename 
		editFilepath.text = attr.Folder 
		chkMergeModel.state = attr.MergeFmd 
		editMergeFile.text = attr.MergeFmdFile 
		editFdespath.text = attr.FdesFile 
		editNodename.text = attr.Nodes 
		editLayername.text = attr.DispLayers 
		editAnimLayername.text = attr.AnimLayers 
		editComment.text = attr.Comment 
		rdoTimeRange.state = (if attr.ExportAllFrames then 1 else 2)

				
		spnTimeStart.value = attr.StartFrame 
		spnTimeEnd.value = attr.EndFrame 
		chkAnimationLoop.state = attr.LoopAnim 

		chkExportModel.state = attr.ExportModel
		chkExportTex.state = attr.ExportTexture
		chkExportSkelAnim.state = attr.ExportSkeletalAnim
		chkExportVisBoneAnim.state = attr.ExportBoneVisAnim
		chkExportMtlCol.state = attr.ExportMtlColorAnim
		chkExportTexPat.state = attr.ExportMtlTexPatternAnim
		chkExportTexSRT.state = attr.ExportMtlTexSRTAnim
		chkExportScene.state = attr.ExportSceneAnim
		chkExportShape.state = attr.ExportShapeAnim
				
		editOptions.text = attr.Options 
		
		redrawItems()
	)
	
	fn saveItems = 
	(
		attr.Filename = editFilename.text 
		attr.Folder = editFilepath.text 
		attr.MergeFmd = chkMergeModel.state 
		attr.MergeFmdFile = editMergeFile.text 
		attr.FdesFile = editFdespath.text 
		attr.Nodes = editNodename.text 
		attr.DispLayers = editLayername.text 
		attr.AnimLayers = editAnimLayername.text 
		attr.Comment = editComment.text 
		attr.ExportAllFrames = (rdoTimeRange.state == 1)
		attr.StartFrame = spnTimeStart.value 
		attr.EndFrame = spnTimeEnd.value 
		attr.LoopAnim = chkAnimationLoop.state 
		attr.ExportModel= chkExportModel.state 
		attr.ExportTexture= chkExportTex.state 
		attr.ExportSkeletalAnim= chkExportSkelAnim.state 
		attr.ExportBoneVisAnim= chkExportVisBoneAnim.state 
		attr.ExportMtlColorAnim= chkExportMtlCol.state 
		attr.ExportMtlTexPatternAnim= chkExportTexPat.state 
		attr.ExportMtlTexSRTAnim= chkExportTexSRT.state 
		attr.ExportSceneAnim= chkExportScene.state 
		attr.ExportShapeAnim= chkExportShape.state 
		attr.Options = editOptions.text 
	)
	
	fn setFdesFile fname =
	(
		editFdespath.text = fname
		utils.appendRecentFdes fname
	)
	
	fn loadOutputSettingFromFile filename = 
	(
		local ninexp = NintendoExport
		if ninexp == undefined do return false
		if filename == undefined do return false
		local fs = openFile filename mode:"rt"
		if fs == undefined do
		(
			format "loadOutputSettingFromFile:File Open Error(%)\n" filename
			return false
		)
		-- read header
		if (findString (readLine fs) "NW4F_Export settings") == undefined do return false
		local str, key, val, ver = 0
		local isEOF = false
		while isEOF == false do
		(
			str = readLine fs
			-- skip comment and null line
			if (str.count < 1) or (str[1] == "#") do 
			(
				if eof fs do ( isEOF = true )
				continue
			)
			local elem = filterString str "="
			if (classof elem != Array) or elem.count != 2 do continue
			key = elem[1]
			val = substituteString elem[2] "\"" ""
			--format "\"%\"=\"%\"\n" key val
			case key of
			(
				-- Output File Selection
				"output_fmd": chkExportModel.state = val as booleanclass
				"output_ftx": chkExportTex.state = val as booleanclass
				"output_fsk": chkExportSkelAnim.state = val as booleanclass
				"output_fvb": chkExportVisBoneAnim.state = val as booleanclass
				"output_fcl": chkExportMtlCol.state = val as booleanclass
				"output_ftp": chkExportTexPat.state = val as booleanclass
				"output_fts": chkExportTexSRT.state = val as booleanclass
				"output_fsh": chkExportShape.state = val as booleanclass
				"output_fsn": chkExportScene.state = val as booleanclass
				"output_fsc": chkExportScene.state = val as booleanclass -- old name
			)							
			--detect eof
			if eof fs do
			(
				isEOF = true
			)
		)
		
		close fs
		return true
	)
	
	
	on chkMergeModel changed val do redrawItems()
	on rdoTimeRange changed val do redrawItems()
	on chkExportModel changed val do redrawItems()
	on chkExportTex changed val do redrawItems()
	on chkExportVisBoneAnim changed val do redrawItems()
	on chkExportSkelAnim changed val do redrawItems()
	on chkExportMtlCol changed val do redrawItems()
	on chkExportTexPat changed val do redrawItems()
	on chkExportTexSRT changed val do redrawItems()
	on chkExportShape changed val do redrawItems()
	on chkExportScene changed val do redrawItems()
	
	on btnSelectPath pressed do
	(
		local filepath = getSavePath initialDir:editFilepath.text
		if(filepath != undefined) do editFilepath.text = filepath
	)
	on btnNameNode pressed do
	(
		sel = getCurrentSelection()
		if sel.count > 0 do
		(
			editFilename.text = sel[1].name
		)
	)
	on btnNameScene pressed do
	(
		if(maxFilePath != "") do
		(
			editFilename.text = (getFilenameFile maxFileName)
		)
	)
	on btnSelectMerge pressed do
	(
		local filepath = getOpenFileName initialDir:editMergeFile.text types:"Model(fmdb)|*.fmdb|All|*.*|"
		if(filepath != undefined) do editMergeFile.text = filepath
	)
	
	on btnSelectFdes pressed do
	(
		local fname = getOpenFileName caption:"Load Setting File" types:"Settings(*.fdes)|*.fdes|All|*.*|" historyCategory:"NintendoExport_Setting_File"
		if (fname != undefined) do setFdesFile fname
	)

	on btnRecentFdes pressed do
	(
		--print "recent fdes"
		--menuMan.createSubMenuItem "Test Menu" NW4FRecentFdesMenu
		utils.loadSettingConfig()
		for i = 1 to 10 do
		(
			local mi = execute ("NW4FRecentFdesMenu.mi_Recent" + (i as String))
			if mi == undefined do continue
				
			if i <= utils.recentFdes.count then
			(
				mi.text = utils.recentFdes[i]
				mi.enabled = true
			)
			else
			(
				mi.text = ""
				mi.enabled = true
			)
		)
		nw4fEditMultiExportRollout_SetFdes = setFdesFile
		popUpMenu NW4FRecentFdesMenu
	)
	
	on btnLoadFdes pressed do
	(
		if not nintendoExportRollout.open do
		(
			CreateDialog  nintendoExportRollout menu:NW4FSettingMenu
		)
		setFocus nintendoExportRollout
		
		local fname = editFdespath.text
		if doesfileexist fname then
		(
			if not (utils.loadSettingFromFile fname) do
			(
				messageBox "fdes load error"
			)
			nintendoExportRollout.loadConfig loadFromScene:false
		)
		else
		(
			nintendoExportRollout.loadConfig loadFromScene:true
		)
		nintendoExportRollout.redrawItems()
	)
		
	on btnNodeGet pressed do
	(
		local sel = getCurrentSelection()
		if sel.count > 0 do
		(
			local names = #()
			for s in sel do append names s.name
			editNodeName.text = utils.listToString names
		)
	)

	on btnNodeSet pressed do
	(
		local nodes = utils.stringToList editNodeName.text
		if nodes.count > 0 do
		(
			clearNodeSelection()
			for nodename in nodes do
			(
				local n = getNodeByName nodename
				if n != undefined do selectMore n
			)
		)
	)

	on btnLayerGet pressed do
	(
		local lman = LayerManager
		if lman.count > 0 do
		(
			local layers = #()
			for i = 0 to (lman.count - 1) do
			(
				local layer = lman.getLayer i
				if layer.on do append layers layer.name
			)
			editLayerName.text = utils.listToString layers
		)
	)
	
	on btnLayerSet pressed do
	(
		local lman = LayerManager
		local layers = utils.stringToList editLayerName.text
		if lman.count > 0 and layers.count > 0 do
		(
			for i = 0 to (lman.count - 1) do
			(
				local layer = lman.getLayer i
				layer.on = ((findItem layers layer.name) > 0)
			)
		)
	)
	
	on btnAnimLayerGet pressed do
	(
		local alman = AnimLayerManager
		if alman.getLayerCount() > 0 do
		(
			local layers = #()
			for i = 1 to alman.getLayerCount() do
			(
				if not (alman.getLayerMute i) do append layers (alman.getLayerName i)
			)
			editAnimLayerName.text = utils.listToString layers
		)
	)
	
	on btnAnimLayerSet pressed do
	(
		local layers = utils.stringToList editAnimLayerName.text
		local alman = AnimLayerManager
		if alman.getLayerCount() > 0  and layers.count > 0  do
		(
			for i = 1 to alman.getLayerCount() do
			(
				alman.setLayerMute i ((findItem layers (alman.getLayerName i)) == 0)
			)
		)
	)
	
	on btnGetFromFdes pressed do
	(
		local fname = editFdespath.text
		if doesfileexist fname then
		(
			loadOutputSettingFromFile fname
		)
		else
		(
			local ninexp = NintendoExport
			chkExportModel.state = ninexp.doesExportModel
			chkExportTex.state = ninexp.doesExportTexture
			chkExportSkelAnim.state = ninexp.doesExportSkelAnim
			chkExportVisBoneAnim.state = ninexp.doesExportVisBoneAnim
			chkExportMtlCol.state = ninexp.doesExportMtlColorAnim
			chkExportTexPat.state = ninexp.doesExportMtlTexPatternAnim
			chkExportTexSRT.state = ninexp.doesExportMtlTexSRTAnim
			chkExportShape.state = ninexp.doesExportShapeAnim
			chkExportScene.state = ninexp.doesExportSceneAnim
		)
		redrawItems()
		
	)
	
	on nw4fEditMultiExportRollout open  do
	(
		attr = nw4fEditMultiExportRollout_Value
		if attr == undefined do return()
		loadItems()
	)
	
	on nw4fEditMultiExportRollout close  do
	(
		--nw4fEditMultiExportRollout_Value = undefined
		nw4fEditMultiExportRollout_EndEdit()
	)
	
	on btnOK pressed do
	(
		if editFilename.text.count <= 0 do
		(
			messageBox "Output File Name is wrong"
			return undefined
		)
		
		local fpath = editFilepath.text
		
		if not (pathConfig.isLegalPath fpath) do
		(
			messageBox "Output Folder is wrong"
			return undefined
		)
		
		/*
		if not (pathConfig.isAbsolutePath fpath) then
		(
			fpath = pathConfig.convertPathToAbsolute  (pathConfig.appendPath maxFilePath fpath)
		)
		
		if  not (doesFileExist fpath) do
		(
			if  not (makeDir fpath all:true) do
			(
				messageBox "Output Folder is wrong"
				return undefined
			)
		)
		*/
		saveItems()
		nw4fEditMultiExportRollout_NeedDelete = false
		DestroyDialog nw4fEditMultiExportRollout
	)
	
	on btnCancel pressed do
	(
		DestroyDialog nw4fEditMultiExportRollout
	)
)

/********************************************************
nw4fMultiExportRollout
 ********************************************************/
rcMenu nw4fMultiExportMenu
(
	subMenu "Help" 
	(
		menuItem mi_Help "Help On Multi Export..."
	)
	on mi_Help picked do nintendoExportRollout.showHelp @"html\NW4F_MultiExport.html"
)
rollout nw4fMultiExportRollout "Multi Export" width:1020 --height:290
(
	group ""
	(
		button btnUp "Move Up" width:80 across:11
		button btnDown "Move Down" width:80 
		button btnAdd "Add..." width:80 
		button btnDuplicate "Duplicate" width:80 
		button btnDelete "Delete" width:80 
		button btnEdit "Edit..." width:80  --border:false
		label lblDummy1 ""
		--label lblDummy2 ""
		--label lblDummy3 ""
		--label lblDummy4 ""
		button btnLoadFdes "Load fdes to Scene" width:110 offset:[-10,0]
		button btnGetRange "Get Playback Range" width:120 offset:[20,0] 
		label lblDummy5 ""
		button btnSetRange "Set Playback Range" width:120 offset:[-40,0] 
		
		dotNetControl lv_data "System.Windows.Forms.ListView" width:1000 height:400
	)
	
	group ""
	(
		label lblItemInfo "" align:#left offset:[0,-8]
	)
	
	button btnExportSelection "Export Selected Items" width:480 across:2
	button btnExportAll "Export All Items" width:480
	
	button btnClose "Close" width:980 --height:24
		
	local utils = NintendoExportUtilities()
	
	fn updateButtons = 
	(
		btnAdd.enabled  = true
		if lv_data.SelectedIndices.Count == 0 then
		(
			btnUp.enabled = btnDown.enabled  = false
			btnDelete.enabled  = btnDuplicate.enabled  = false
			btnEdit.enabled  = false
			btnLoadFdes.enabled = btnGetRange.enabled = false
			btnSetRange.enabled = false
			btnExportSelection.enabled  = false
		)
		else
		(
			btnUp.enabled = btnDown.enabled  = true
			btnDelete.enabled  = btnDuplicate.enabled  = true
			btnEdit.enabled  = btnLoadFdes.enabled = btnSetRange.enabled = (lv_data.SelectedIndices.Count == 1)
			btnGetRange.enabled = true
			btnExportSelection.enabled  = true
		)
	)
	
	fn setEnabledAll val =
	(
		btnUp.Enabled = val
		btnDown.Enabled = val
		btnAdd.Enabled = val
		btnDuplicate.Enabled = val
		btnDelete.Enabled = val
		btnEdit.Enabled = val
		lv_data.Enabled = val
		btnExportSelection.Enabled = val
		btnExportAll.Enabled = val
		btnClose.Enabled = val
	)
	
	fn updateSelection =
	(
		lv_data.Items.Clear()
		local attribList = utils.getMultiExportAttributes()
		local lvItems =#()

		for attr in attribList do
		(
			local li = dotNetObject "System.Windows.Forms.ListViewItem" attr.Filename
			local sub_li 
			local selstr = ""
			
			selstr += if attr.ExportModel then "M" else "-"
			selstr += if attr.ExportTexture then "T" else "-"
			selstr += if attr.ExportSkeletalAnim then "S" else "-"
			selstr += if attr.ExportBoneVisAnim then "V" else "-"
			selstr += if attr.ExportMtlColorAnim then "C" else "-"
			selstr += if attr.ExportMtlTexSRTAnim then "R" else "-"
			selstr += if attr.ExportMtlTexPatternAnim then "P" else "-"
			selstr += if attr.ExportShapeAnim then "H" else "-"
			selstr += if attr.ExportSceneAnim then "N" else "-"
			
			--sub_li = li.SubItems.add attr.Filename
			sub_li = li.SubItems.add (filenameFromPath  attr.FdesFile)
			sub_li = li.SubItems.add attr.Nodes
			sub_li = li.SubItems.add attr.DispLayers
			sub_li = li.SubItems.add attr.Comment
			sub_li = li.SubItems.add (attr.StartFrame as string)
			sub_li = li.SubItems.add (attr.EndFrame as string)
			sub_li = li.SubItems.add (if attr.LoopAnim then "ON" else "OFF")
			sub_li = li.SubItems.add selstr
			sub_li = li.SubItems.add attr.Options
			append lvItems li
		)
		lv_data.Items.AddRange lvItems 
		updateButtons()
	)
	
	fn initListView =
	(
		lv_data.gridLines = true
		lv_data.View = (dotNetClass "System.Windows.Forms.View").Details
		lv_data.fullRowSelect = true
		lv_data.AutoSize = true
		lv_data.MultiSelect = true
		lv_data.HideSelection = false
		lv_data.Columns.add "Output File Name"
		lv_data.Columns.add "fdes File"
		lv_data.Columns.add "Node"
		lv_data.Columns.add "Layer"
		lv_data.Columns.add "Comment"
		lv_data.Columns.add "Start"
		lv_data.Columns.add "End "
		lv_data.Columns.add "Loop"
		lv_data.Columns.add "Selection"
		lv_data.Columns.add "Options"
		--lv_data.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").HeaderSize)
		--lv_data.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").ColumnContent)
		local headerW = #(100, 150, 150, 150, 100, 40, 40, 35, 80, 150)
		--local taCenter = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
		for i = 1 to lv_data.Columns.Count do
		(
			local cm = lv_data.Columns.item[i - 1]
			cm.width = headerW[i]
			--cm.TextAlign = taCenter
		)
	)
	
	fn endEdit =
	(
		if nw4fEditMultiExportRollout_NeedDelete and nw4fEditMultiExportRollout_Value != undefined do
		(
			--print "endEdit"
			local deleted = false
			for i = rootnode.custAttributes.count to 1 by -1 while (not deleted) do
			(
				if rootnode.custAttributes[i] == nw4fEditMultiExportRollout_Value do
				(
					--print "delete attr"
					deleteItem rootnode.custAttributes i
					deleted = true
				)
			)
		)
		setEnabledAll true
		updateSelection()
		
		-- select last edit
		local attribList = utils.getMultiExportAttributes()
		for i = 1 to attribList.count do
		(
			if attribList[i] == nw4fEditMultiExportRollout_Value do
			(
				lv_data.Items.Item[i-1].Selected = true				
			)
		)
		lv_data.Focus()
		
	)
	
	fn beginEdit attr isNew:false =
	(
		nw4fEditMultiExportRollout_NeedDelete = isNew
		nw4fEditMultiExportRollout_Value = attr
		nw4fEditMultiExportRollout_EndEdit = endEdit
		setEnabledAll false
		CreateDialog  nw4fEditMultiExportRollout --modal:true	
	)
	
	on lv_data SelectedIndexChanged e do
	(
		updateButtons()
		lblItemInfo.text = if lv_data.SelectedIndices.Count == 1 then
		(
			local attribList = utils.getMultiExportAttributes()
			local attr = (attribList[lv_data.SelectedIndices.Item[0] + 1])
			local ss = StringStream ""
			if attr.Folder.count > 0 do  format "Output Folder: % " attr.Folder to:ss
			if attr.MergeFmdFile.count > 0 do  format "Merge Fmd File: % " attr.MergeFmdFile to:ss
			if attr.AnimLayers.count > 0 do  format "Anim Layer: % " attr.AnimLayers to:ss
			ss as String	
		)
		else
		(
			""
		)
	)
	
	on lv_data DoubleClick e do
	(
		if lv_data.SelectedIndices.Count == 1 then
		(
			local attribList = utils.getMultiExportAttributes()
			beginEdit (attribList[lv_data.SelectedIndices.Item[0] + 1])
		)
	)
	
	on btnEdit pressed do 
	(
		if lv_data.SelectedIndices.Count > 0 do
		(
			local attribList = utils.getMultiExportAttributes()
			beginEdit (attribList[lv_data.SelectedIndices.Item[0] + 1])
		)
	)
	
	on btnAdd pressed do 
	(
		local attr = nw4f_multiexport_custom_attribute()
		attr.Nodes = ""
		if lv_data.SelectedIndices.Count == 1 then
		(
			local attribList = utils.getMultiExportAttributes()
			local maxid = lv_data.SelectedIndices.Item[0] + 1
			for tattr in attribList do
			(
				deleteItem rootnode.custAttributes (findItem rootnode.custAttributes tattr)
			)
			insertItem attr attribList (maxid + 1)
			for tattr in attribList do
			(
				append rootnode.custAttributes tattr
			)
		)
		else
		(
			append rootnode.custAttributes attr
		)
		updateSelection()
		beginEdit attr isNew:true
	)
	
	on btnUp pressed do 
	(
		if lv_data.SelectedIndices.Count > 0 then
		(
			local attribList = utils.getMultiExportAttributes()
			local newSel = #()
			
			for i = 0 to (lv_data.SelectedIndices.Count - 1) do
			(
				local id = lv_data.SelectedIndices.Item[i]
				local maxid = id + 1
				if id > 0  and \
					 (findItem newSel (id - 1)) == 0 then
				(
					local tmp = attribList[maxid]
					deleteItem attribList (maxid)
					insertItem tmp attribList (maxid - 1)
					appendIfUnique newSel (id - 1)
				)
				else
				(
					appendIfUnique newSel id
				)
			)
			
			for attr in attribList do
			(
				deleteItem rootnode.custAttributes (findItem rootnode.custAttributes attr)
			)
			for attr in attribList do
			(
				append rootnode.custAttributes attr
			)
			
			updateSelection()
			lv_data.Focus()
			for s in newSel do lv_data.Items.Item[s].Selected = true
		)
	)
	
	on btnDown pressed do 
	(
		if lv_data.SelectedIndices.Count > 0 do
		(
			local attribList = utils.getMultiExportAttributes()
			local newSel = #()
			for i = (lv_data.SelectedIndices.Count - 1) to 0 by -1 do
			(
				local id = lv_data.SelectedIndices.Item[i]
				local maxid = id + 1
				if maxid < attribList.count and \
					(findItem newSel (id + 1)) == 0 then
				(
					local tmp = attribList[maxid]
					deleteItem attribList (maxid)
					insertItem tmp attribList (maxid + 1)
					appendIfUnique newSel (id + 1)
				)
				else
				(
					appendIfUnique newSel id
				)
			)
			for attr in attribList do
			(
				deleteItem rootnode.custAttributes (findItem rootnode.custAttributes attr)
			)
			for attr in attribList do
			(
				append rootnode.custAttributes attr
			)
			updateSelection()
			lv_data.Focus()
			for s in newSel do lv_data.Items.Item[s].Selected = true
		)
	)
	
	on btnDuplicate pressed do 
	(
		if lv_data.SelectedIndices.Count > 0 do
		(
			local attribList = utils.getMultiExportAttributes()
			local newSel = #()
			local dupList = #()
			for i = 0 to (lv_data.SelectedIndices.Count - 1) do
			(
				local id = lv_data.SelectedIndices.Item[i]
				local maxid = id + 1
				append dupList attribList[maxid]
			)
			
			for attr in dupList do
			(
				local insertpos = findItem attribList attr 
				local dupattr = copy attr
				insertItem dupattr attribList (insertpos + 1)
				appendIfUnique newSel ((findItem attribList dupattr) - 1)
			)

			for attr in attribList do
			(
				local pos = findItem rootnode.custAttributes attr
				if pos > 0 do
				(
					deleteItem rootnode.custAttributes pos
				)
			)
			for attr in attribList do
			(
				append rootnode.custAttributes attr
			)
			updateSelection()
			lv_data.Focus()
			for s in newSel do lv_data.Items.Item[s].Selected = true
		)
	)
	
	on btnDelete pressed do 
	(
		if lv_data.SelectedIndices.Count > 0 then
		(
			if not (queryBox "Delete selected item?") do return ()
			
			local attribList = utils.getMultiExportAttributes()
			local deleteList = #()
			
			for i = 0 to (lv_data.SelectedIndices.Count - 1) do
			(
				local id = lv_data.SelectedIndices.Item[i]
				local maxid = id + 1
				append deleteList attribList[maxid]
			)
			
			--print deleteList
			
			for i = rootnode.custAttributes.count to 1 by -1 do
			(
				local deleted = false
				for ca in deleteList while (not deleted) do
				(
					if rootnode.custAttributes[i] == ca do
					(
						deleteItem rootnode.custAttributes i
						deleted = true
					)
				)
			)
			
			updateSelection()
			lv_data.Focus()
		)
		else
		(
			messageBox "Please select item."
		)	
	)
	
	on btnLoadFdes pressed do
	(
		if lv_data.SelectedIndices.Count != 1 do return()
		local attribList = utils.getMultiExportAttributes()
		local attr = (attribList[lv_data.SelectedIndices.Item[0] + 1])
		if not nintendoExportRollout.open do
		(
			CreateDialog  nintendoExportRollout menu:NW4FSettingMenu
		)
		setFocus nintendoExportRollout
		
		local fname = attr.FdesFile 
		if doesfileexist fname then
		(
			if not (utils.loadSettingFromFile fname) do
			(
				messageBox "fdes load error"
			)
			nintendoExportRollout.loadConfig loadFromScene:false
		)
		else
		(
			--nintendoExportRollout.loadConfig loadFromScene:true
		)
		nintendoExportRollout.redrawItems()
	)
	
	on btnGetRange pressed do
	(
		if lv_data.SelectedIndices.Count == 0 do return()
		local attribList = utils.getMultiExportAttributes()
		local setList = #()
		local sel = #()
		
		for i = 0 to (lv_data.SelectedIndices.Count - 1) do
		(
			local id = lv_data.SelectedIndices.Item[i]
			local maxid = id + 1
			append setList attribList[maxid]
			append sel id
		)
		
		local start = animationRange.start.frame
		local end = animationRange.end.frame
		for attr in setList do
		(
			attr.StartFrame = start
			attr.EndFrame = end
		)

		updateSelection()
		lv_data.Focus()
		for s in sel do lv_data.Items.Item[s].Selected = true
	)
	
	on btnSetRange pressed do
	(
		if lv_data.SelectedIndices.Count != 1 do return()
		local attribList = utils.getMultiExportAttributes()
		local attr = (attribList[lv_data.SelectedIndices.Item[0] + 1])
		animationRange = interval attr.StartFrame attr.EndFrame
	)
	
		
	fn filePostOpenCallback =
	(
		if nw4fMultiExportRollout.open do
		(
			updateSelection()
		)
	)
	
	on nw4fMultiExportRollout open  do
	(
		callbacks.removeScripts id:#nw4fMultiExportFilePostOpen
		callbacks.addScript #filePostOpen "nw4fMultiExportRollout.filePostOpenCallback()" id:#nw4fMultiExportFilePostOpen
		initListView()
		updateSelection()
	)
	on nw4fMultiExportRollout close do
	(
		callbacks.removeScripts id:#nw4fMultiExportFilePostOpen
		DestroyDialog nw4fEditMultiExportRollout
	)
	
	on btnExportSelection pressed do
	(
		if lv_data.SelectedIndices.Count > 0 do
		(
			local selItems = #()
			for i = 0 to (lv_data.SelectedIndices.Count - 1) do
			(
				local id = lv_data.SelectedIndices.Item[i]
				local maxid = id + 1
				append selItems maxid
			)
			
			utils.MultiExport selected:selItems
		)
	)
	
	on btnExportAll pressed do
	(
		utils.MultiExport ()
	)
	
	on btnClose pressed  do DestroyDialog nw4fMultiExportRollout
)

