-- NintendoExport BatchExport Script
-- Version 3.12.0
-- Copyright (C)Nintendo All rights reserved.

global ninexpBatchExpInDir, ninexpBatchExpOutDir

fn nintendoDoBatchExport = 
(
	if ninexpBatchExpInDir == undefined do ninexpBatchExpInDir = ""
	if ninexpBatchExpOutDir == undefined do ninexpBatchExpOutDir = ""
	
	--set folders
	local inDir, outDir, inFilesWC
	inDir = getSavePath caption:"Nintendo batch export\nSelect max file folder." initialDir:ninexpBatchExpInDir
	format "\nInput Folder: %\n" inDir
	if (inDir == undefined) do return ()
	ninexpBatchExpInDir = inDir
	
	if not (doesFileExist ninexpBatchExpOutDir) do ninexpBatchExpOutDir = inDir
	outDir = getSavePath caption:"Nintendo batch export\nSelect destination folder." initialDir:ninexpBatchExpOutDir
	format "Output Folder: %\n" outDir
	if (outDir == undefined) do return ()
	ninexpBatchExpOutDir = outDir
	
	inFilesWC = inDir + "\\*.max"
	local files = getFiles inFilesWC
	if (files.count == 0 )do return ()
	
	
	local autoSearchAnim = queryBox "Automatically select animations?"
	
	format "\nBegin Export\n"
	local errCount = 0
	local errFiles = ""
	
	local ninexp = NintendoExport
	local utils = NintendoExportUtilities
	print utils
	if (ninexp == undefined) or (utils == undefined ) do return()
	
	-- error log 
	local dt = getLocalTime()
	local ss = stringStream ""
	format "\\ExportLog_%-%-%_%-%-%.txt" dt[1] dt[2] dt[4] dt[5] dt[6] dt[7]  to:ss
	local errfilename = outDir + (ss as string)
	--print errfilename 
	local errfs = openFile errfilename mode:"wt"
	if errfs == undefined do
	(
		format "Log File Open Error(%)\n" errfilename
		return false
	)
	

	for f in files do
	(
		format "-----------------------------\n"
		format "-----------------------------\n" to:errfs
		format "Export Max File(%)\n" f
		format "Export Max File(%)\n" f to:errfs
		
		outFilename = outDir + "\\" + (getFilenameFile f) + ".cmdl"
		-- Load max file and export
		--resetMaxFile #noPrompt
		if (loadMaxFile f quiet:true useFileUnits:true) then
		(
			completeRedraw()
			ninexp.LoadSetting()
			ninexp.outputFolder = outDir
			ninexp.filename = ( getFilenameFile f )
			
			if autoSearchAnim do
			(
				ninexp.doesExportModel = true
				ninexp.doesExportTexture = true
				ninexp.useMerge = false
				ninexp.useMergeFtx = false
				ninexp.useMergeAnim = false
				
				utils.SearchAndSetAnimations()
			)
			
			try
			(
				local ret = ninexp.doExport false
				format "%" (ninexp.GetErrorLog()) to:errfs
				if not ret do 
				(
					errCount = errCount + 1
					append errFiles (f + "\n")
					format "Export Error\n"
					format "Export Error\n" to:errfs
				)
			)
			catch
			(
				format "Unknown System Error\n"
				format "Unknown System Error\n" to:errfs
				errCount = errCount + 1
				append errFiles (f + "\n")
			)
		)
		else
		(
			format "Load Error\n"
			format "Load Error\n" to:errfs
			append errFiles (f + "\n")
		)
		
	)
	close errfs
	format "Finish Export\n"
	resetMaxFile #noPrompt
	
	if (errCount > 0) then
	(
		local mes = ("Exporting error in " + errCount as String + "files\n\n")
		append mes errFiles
		messagebox mes
	)
	else
	(
		messagebox "Finish Export"
	)
	
	
)

-- NintendoExport exists?
if (NintendoExport != undefined and NintendoExportUtilities != undefined) do
(
	nintendoDoBatchExport()
)
