# coding: utf-8

import os

def Filter(target):
    UpdateParentMaterialPathToFileName(target.Document)
    UpdateMaterialLabelFormat(target.Document)
    UpdateMaterialCommentFormat(target.Document)
    target.Write()

def UpdateParentMaterialPathToFileName(doc):
    for parent_mat_info in doc.SelectNodes("//ParentMaterial"):
        model_path = parent_mat_info.GetAttribute("Model")
        model_file_name = os.path.basename(model_path)
        parent_mat_info.SetAttribute("Model", model_file_name)
        
def UpdateMaterialLabelFormat(doc):
    for mat in doc.SelectNodes("//material"):
        comment = mat.SelectSingleNode("//comment")
        if comment != None:
            comment.SetAttribute("label", comment.GetAttribute("text"))

def UserDataCommentToCommentText(user_data_array, comment):
    user_data = user_data_array.SelectSingleNode("//user_data[@name='Comment']")
    if user_data == None:
        return
    string = user_data.SelectSingleNode("//string")
    if string == None:
        return
    comment.SetAttribute("text", string.InnerText)
    user_data.ParentNode.RemoveChild(user_data)
    if user_data_array.HasChildNodes == False:
        user_data_array.ParentNode.RemoveChild(user_data_array)

def UpdateMaterialCommentFormat(doc):
    for mat in doc.SelectNodes("//material"):
        user_data_array = mat.SelectSingleNode("//user_data_array")
        if user_data_array == None:
            return
        comment = mat.SelectSingleNode("//comment")
        if comment == None:
            comment = doc.CreateNode("element", "comment", "")
            comment.SetAttribute("label", "")
            comment.SetAttribute("color", "")
            comment.SetAttribute("text", "")
            mat.AppendChild(comment)
        UserDataCommentToCommentText(user_data_array, comment)
