﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <cstring>
#include <cstdarg>
#include <cstdlib>

#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>

#include <nnt/nntest.h>

#include <zlib.h>

#include <nn/util/util_StreamingDecompression.h>

extern "C" bool test_deflate(Byte *compr, uLong comprLen);
extern "C" bool test_inflate(Byte *compr, uLong comprLen, Byte *uncompr, uLong uncomprLen);
extern "C" bool test_large_deflate(Byte *compr, uLong comprLen, Byte *uncompr, uLong uncomprLen);
extern "C" bool test_large_inflate(Byte *compr, uLong comprLen, Byte *uncompr, uLong uncomprLen);
extern "C" bool test_flush(Byte *compr, uLong *comprLen);
extern "C" bool test_sync(Byte *compr, uLong comprLen, Byte *uncompr, uLong uncomprLen);
extern "C" bool test_dict_deflate(Byte *compr, uLong comprLen);
extern "C" bool test_dict_inflate(Byte *compr, uLong comprLen, Byte *uncompr, uLong uncomprLen);

TEST(zlib, examplec)
{
    // cx ライブラリを呼んでもシンボルがぶつからないことを確認するために呼んでいる。
    auto pContext = new nn::util::StreamingDecompressZlibContext;
    nn::util::InitializeStreamingDecompressZlibContext(pContext);

    // 以下は example.c の内容のうち、main の中を TEST として動作するように持ってきたもの
    // ------------------------------------------------------------------------------------
    Byte *compr;
    Byte *uncompr;
    uLong comprLen = 10000 * sizeof(int); /* don't overflow on MSDOS */
    uLong uncomprLen = comprLen;
    static const char* myVersion = ZLIB_VERSION;

    if (zlibVersion()[0] != myVersion[0])
    {
        NN_LOG("incompatible zlib version\n");
        FAIL();
    }
    else if (strcmp(zlibVersion(), ZLIB_VERSION) != 0)
    {
        NN_LOG("warning: different zlib version\n");
    }

    NN_LOG("zlib version %s = 0x%04x, compile flags = 0x%lx\n", ZLIB_VERSION, ZLIB_VERNUM, zlibCompileFlags());

    compr    = (Byte*)calloc((uInt)comprLen, 1);
    uncompr  = (Byte*)calloc((uInt)uncomprLen, 1);

    /* compr and uncompr are cleared to avoid reading uninitialized
     * data and to ensure that uncompr compresses well.
     */
    if (compr == Z_NULL || uncompr == Z_NULL)
    {
        NN_LOG("out of memory\n");
        FAIL();
    }

    EXPECT_TRUE(test_deflate(compr, comprLen));
    EXPECT_TRUE(test_inflate(compr, comprLen, uncompr, uncomprLen));

    EXPECT_TRUE(test_large_deflate(compr, comprLen, uncompr, uncomprLen));
    EXPECT_TRUE(test_large_inflate(compr, comprLen, uncompr, uncomprLen));

    EXPECT_TRUE(test_flush(compr, &comprLen));
    EXPECT_TRUE(test_sync(compr, comprLen, uncompr, uncomprLen));
    comprLen = uncomprLen;

    EXPECT_TRUE(test_dict_deflate(compr, comprLen));
    EXPECT_TRUE(test_dict_inflate(compr, comprLen, uncompr, uncomprLen));

    free(compr);
    free(uncompr);

    // ------------------------------------------------------------

    delete pContext;
}
