﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/util/util_ScopeExit.h>
#include <nv/nv_ServiceName.h>

#include <nn/vi/manager/vi_Manager.h>

#include "MemoryManagement.h"
#include "Log.h"

#include "ManagerObject.h"
#include "IndirectLayerSlotList.h"
#include "ServerManager.h"

extern "C" void nninitStartup() NN_NOEXCEPT
{
}

extern "C" void nndiagStartup() NN_NOEXCEPT
{
    // do nothing
}

extern "C" void nnMain() NN_NOEXCEPT
{
    nv::SetGraphicsServiceName("nvdrv:t");

    NN_SDK_LOG("Starting process\n");
    //nn::os::ChangeThreadPriority(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_PRIORITY(vi, Main));
    //nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(vi, Main));

    SetupMemory();
    nnt::vi::g_ManagerObject.Initialize(nn::vi::PolicyLevel_Composition, &nnt::vi::g_ManagerProxyName);
    nnt::vi::g_IndirectLayerSlotList.Initialize();
    nnt::vi::g_ServerManager.Initialize();

    NNT_VI_LOG("Start Service\n");
    nnt::vi::g_ServerManager.Run();

    nnt::vi::g_ServerManager.Finalize();
    nnt::vi::g_IndirectLayerSlotList.Finalize();
    nnt::vi::g_ManagerObject.Finalize();
    NNT_VI_LOG("Exiting process\n");
}
