﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "IndirectLayerSlotList.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/vi/vi_Result.h>

namespace nnt{ namespace vi{
    IndirectLayerSlotList g_IndirectLayerSlotList = {};

    void IndirectLayerSlotList::Initialize() NN_NOEXCEPT
    {
        memset(&m_List, 0, sizeof(m_List));
    }

    void IndirectLayerSlotList::Finalize() NN_NOEXCEPT
    {
    }

    IndirectLayerSlot& IndirectLayerSlotList::operator[](int index) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_RANGE(index, 0, IndirectLayerSlotCount);
        return m_List[index];
    }

}}
