﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/os.h>
#include <nn/vi/profiler/vi_Profiler.h>
#include <nv/nv_MemoryManagement.h>
#include "../Common/testVi_MemoryFixture.h"

// No allocations should occur on graphics heap
TEST_F(MemoryFixture, InitializeProfiler)
{
    nn::vi::profiler::Initialize();
    CheckLeaks();

    nn::os::SystemEvent vsync;
    nn::vi::profiler::GetVsyncEvent(vsync.GetBase());
    CheckLeaks();

    nn::vi::profiler::Finalize();
    CheckLeaks();
}
