﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.h>

typedef nnt::vi::util::Fixture OpenDisplay;

TEST_F(OpenDisplay, Internal_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotFound, nn::vi::OpenDisplay(&pDisplay, "Internal"));
    EXPECT_EQ(nullptr, pDisplay);
}

TEST_F(OpenDisplay, External_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotFound, nn::vi::OpenDisplay(&pDisplay, "External"));
    EXPECT_EQ(nullptr, pDisplay);
}

TEST_F(OpenDisplay, Edid_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotFound, nn::vi::OpenDisplay(&pDisplay, "Edid"));
    EXPECT_EQ(nullptr, pDisplay);
}

TEST_F(OpenDisplay, Null_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotFound, nn::vi::OpenDisplay(&pDisplay, "Null"));
    EXPECT_EQ(nullptr, pDisplay);
}
