﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture SetLayerZ;

TEST_F(SetLayerZ, Success_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::Layer* pLayer;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

    int min = nn::vi::GetZOrderCountMin(pDisplay);
    int max = nn::vi::GetZOrderCountMax(pDisplay);
    int z;

    NNT_ASSERT_RESULT_SUCCESS(nn::vi::SetLayerZ(pLayer, max));
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetLayerZ(&z, pLayer));
    EXPECT_EQ(max, z);

    NNT_ASSERT_RESULT_SUCCESS(nn::vi::SetLayerZ(pLayer, min));
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetLayerZ(&z, pLayer));
    EXPECT_EQ(min, z);

    nn::vi::DestroyLayer(pLayer);
    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetLayerZ, InvalidRange_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::Layer* pLayer;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

    int min = nn::vi::GetZOrderCountMin(pDisplay);
    int max = nn::vi::GetZOrderCountMax(pDisplay);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidRange, nn::vi::SetLayerZ(pLayer, min - 1));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidRange, nn::vi::SetLayerZ(pLayer, max + 1));

    nn::vi::DestroyLayer(pLayer);
    nn::vi::CloseDisplay(pDisplay);
}

TEST(SetLayerZPreconditions, ViNotInitialized_Any)
{
    nn::vi::Layer* pLayer = reinterpret_cast<nn::vi::Layer*>(0x1234);
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::SetLayerZ(pLayer, 0), "");
}

TEST(SetLayerZPreconditions, pLayerNull_Any)
{
    nn::vi::Initialize();

    EXPECT_DEATH_IF_SUPPORTED(nn::vi::SetLayerZ(nullptr, 0), "");

    nn::vi::Finalize();
}

TEST(SetLayerZPreconditions, pLayerInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::Layer* pLayer = nullptr;
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

        if( pLayer != nullptr )
        {
            nn::vi::DestroyLayer(pLayer);
            EXPECT_DEATH_IF_SUPPORTED(nn::vi::SetLayerZ(pLayer, 0), "");
        }

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}
