﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture SetLayerAlpha;

TEST_F(SetLayerAlpha, Success_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::Layer* pLayer;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

    NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetLayerAlpha(pLayer, 0.f));
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetLayerAlpha(pLayer, 1.f));

    nn::vi::DestroyLayer(pLayer);
    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetLayerAlpha, InvalidRange_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::Layer* pLayer;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidRange, nn::vi::SetLayerAlpha(pLayer, std::numeric_limits<float>::lowest()));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidRange, nn::vi::SetLayerAlpha(pLayer, std::numeric_limits<float>::max()));

    nn::vi::DestroyLayer(pLayer);
    nn::vi::CloseDisplay(pDisplay);
}

TEST(SetLayerAlphaPreconditions, ViNotInitialized_Any)
{
    nn::vi::Layer* pLayer = reinterpret_cast<nn::vi::Layer*>(0x1234);
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::SetLayerAlpha(pLayer, 0.f), "");
}

TEST(SetLayerAlphaPreconditions, pLayerNull_Any)
{
    nn::vi::Initialize();

    EXPECT_DEATH_IF_SUPPORTED(nn::vi::SetLayerAlpha(nullptr, 0.f), "");

    nn::vi::Finalize();
}

TEST(SetLayerAlphaPreconditions, pLayerInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::Layer* pLayer = nullptr;
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

        if( pLayer != nullptr )
        {
            nn::vi::DestroyLayer(pLayer);
            EXPECT_DEATH_IF_SUPPORTED(nn::vi::SetLayerAlpha(pLayer, 0.f), "");
        }

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}
