﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture GetLayerZ;

TEST(GetLayerZPreconditions, ViNotInitialized_Any)
{
    nn::vi::Layer* pLayer = reinterpret_cast<nn::vi::Layer*>(0x1234);
    int z;
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetLayerZ(&z, pLayer), "");
}

TEST(GetLayerZPreconditions, pOutZNull_Any)
{
    nn::vi::Layer* pLayer = reinterpret_cast<nn::vi::Layer*>(0x1234);
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetLayerZ(nullptr, pLayer), "");
}

TEST(GetLayerZPreconditions, pLayerNull_Any)
{
    nn::vi::Initialize();

    int z;
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetLayerZ(&z, nullptr), "");

    nn::vi::Finalize();
}

TEST(GetLayerZPreconditions, pLayerInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::Layer* pLayer = nullptr;
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

        if( pLayer != nullptr )
        {
            nn::vi::DestroyLayer(pLayer);
            int z;
            EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetLayerZ(&z, pLayer), "");
        }

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}
