﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture GetDisplayLogicalResolution;

TEST_F(GetDisplayLogicalResolution, Default_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(GetDisplayLogicalResolution, External_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(GetDisplayLogicalResolution, Edid_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Edid"));

    int width;
    int height;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST(GetDisplayLogicalResolutionPreconditions, ViNotInitialized_Any)
{
    nn::vi::Display* pDisplay = reinterpret_cast<nn::vi::Display*>(0x1234);

    int width;
    int height;
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay), "");
}

TEST(GetDisplayLogicalResolutionPreconditions, pOutWidthNull_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        int height;
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayLogicalResolution(nullptr, &height, pDisplay), "");

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}

TEST(GetDisplayLogicalResolutionPreconditions, pOutHeightNull_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        int width;
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayLogicalResolution(&width, nullptr, pDisplay), "");

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}

TEST(GetDisplayLogicalResolutionPreconditions, pDisplayNull_Any)
{
    nn::vi::Initialize();

    int width;
    int height;
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayLogicalResolution(&width, &height, nullptr), "");

    nn::vi::Finalize();
}

TEST(GetDisplayLogicalResolutionPreconditions, pDisplayInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::CloseDisplay(pDisplay);

        int width;
        int height;
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay), "");
    }

    nn::vi::Finalize();
}
