﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture GetDisplayContrastRatio;

TEST_F(GetDisplayContrastRatio, Default_WrongMode_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::CmuMode revert;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayCmuMode(&revert, pDisplay));

    NNT_ASSERT_RESULT_SUCCESS(nn::vi::SetDisplayCmuMode(pDisplay, nn::vi::CmuMode_Default));

    float ratio = 0.f;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayContrastRatio(&ratio, pDisplay));

    NNT_ASSERT_RESULT_SUCCESS(nn::vi::SetDisplayCmuMode(pDisplay, revert));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(GetDisplayContrastRatio, External_WrongMode_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    nn::vi::CmuMode revert;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayCmuMode(&revert, pDisplay));

    NNT_ASSERT_RESULT_SUCCESS(nn::vi::SetDisplayCmuMode(pDisplay, nn::vi::CmuMode_Default));

    float ratio = 0.f;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayContrastRatio(&ratio, pDisplay));

    NNT_ASSERT_RESULT_SUCCESS(nn::vi::SetDisplayCmuMode(pDisplay, revert));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(GetDisplayContrastRatio, Edid_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Edid"));

    float ratio;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayContrastRatio(&ratio, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST(GetDisplayContrastRatioPreconditions, ViNotInitialized_Any)
{
    nn::vi::Display* pDisplay = reinterpret_cast<nn::vi::Display*>(0x1234);
    float ratio;
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayContrastRatio(&ratio, pDisplay), "");
}

TEST(GetDisplayContrastRatioPreconditions, pOutRatioNull_Any)
{
    nn::vi::Display* pDisplay = reinterpret_cast<nn::vi::Display*>(0x1234);
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayContrastRatio(nullptr, pDisplay), "");
}

TEST(GetDisplayContrastRatioPreconditions, pDisplayNull_Any)
{
    nn::vi::Initialize();

    float ratio;
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayContrastRatio(&ratio, nullptr), "");

    nn::vi::Finalize();
}

TEST(GetDisplayContrastRatioPreconditions, pDisplayInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::CloseDisplay(pDisplay);

        float ratio;
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayContrastRatio(&ratio, pDisplay), "");
    }

    nn::vi::Finalize();
}
