﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/nn_Log.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/os.h>
#include <nn/os/os_TransferMemoryApi.h>
#include <nn/fs.h>
#include <nv/nv_ServiceName.h>
#include <nn/vi/detail/vi_SystemServiceProxy.private.h>
#include <nnt.h>
#include <nnt/vi/testVi_TestServerProxy.h>

#include "testVi_MemoryManagement.h"

namespace {
    //NN_ALIGNAS(4096) char g_FileSystemCache[16 * 1024];

    bool g_IsServiceInitialized = false;
    nnt::vi::TestServiceProxy g_TestServiceProxy;
    nn::sf::SharedPointer<nnt::vi::Service> g_pTestService;

    void EnsureServiceInitialized() NN_NOEXCEPT
    {
        if(g_IsServiceInitialized)
        {
            return;
        }
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_TestServiceProxy.Initialize());
        g_pTestService = g_TestServiceProxy.GetService();
        g_IsServiceInitialized = true;
    }
}

namespace {

    //const int Width = 1280;
    //const int Height = 720;

    //void InvokeOpenIndirectImage(
    //    nn::os::SystemEventType* pOutIsBufferReadyEvent,
    //    nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>& pAppSrv,
    //    nn::vi::IndirectConsumerHandleType hConsumerEp,
    //    void* pBuffer,
    //    size_t bufferSize
    //    ) NN_NOEXCEPT
    //{
    //    auto myAruid = nn::applet::GetAppletResourceUserId();

    //    NN_LOG("Opening IndirectImage\n");
    //    nn::sf::NativeHandle bufferTransferMemoryHandle;
    //    {
    //        NN_LOG("  Creating TransferMemory\n");
    //        nn::os::TransferMemoryType bufferTransferMemory;
    //        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateTransferMemory(&bufferTransferMemory, pBuffer, bufferSize, nn::os::MemoryPermission_ReadOnly));
    //        auto handle = nn::os::DetachTransferMemory(&bufferTransferMemory);
    //        nn::os::DestroyTransferMemory(&bufferTransferMemory);
    //        bufferTransferMemoryHandle = nn::sf::NativeHandle(handle, true);
    //    }

    //    nn::sf::NativeHandle isBufferReadyEventHandle;
    //    {
    //        NN_LOG("  Calling OpenIndirectImage\n");
    //        NN_ABORT_UNLESS_RESULT_SUCCESS(pAppSrv->OpenIndirectImage(
    //            &isBufferReadyEventHandle,
    //            std::move(bufferTransferMemoryHandle),
    //            static_cast<uint64_t>(bufferSize),
    //            Width,
    //            Height,
    //            hConsumerEp,
    //            myAruid
    //        ));
    //        bufferTransferMemoryHandle.Reset();
    //    }

    //    {
    //        NN_LOG("  Opening IsBufferReadyEvent\n");
    //        nn::os::AttachReadableHandleToSystemEvent(
    //            pOutIsBufferReadyEvent,
    //            isBufferReadyEventHandle.GetOsHandle(),
    //            isBufferReadyEventHandle.IsManaged(),
    //            nn::os::EventClearMode_ManualClear
    //        );
    //        isBufferReadyEventHandle.Detach();
    //    }
    //    NN_LOG("Opening IndirectImage ... done\n");
    //}

    //void InvokeCloseIndirectImage(
    //    nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>& pAppSrv,
    //    nn::vi::IndirectConsumerHandleType hConsumerEp
    //    ) NN_NOEXCEPT
    //{
    //    NN_LOG("Closing IndirectImage\n");
    //    NN_LOG("  Calling CloseIndirectImage\n");
    //    NN_ABORT_UNLESS_RESULT_SUCCESS(pAppSrv->CloseIndirectImage(hConsumerEp));
    //    NN_LOG("Closing IndirectImage ... done\n");
    //}

    //nn::Result InvokeGetIndirectImage(
    //    nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>& pAppSrv,
    //    nn::vi::IndirectConsumerHandleType hConsumerEp,
    //    nn::os::SystemEventType* pIsBufferReadySystemEvent
    //    ) NN_NOEXCEPT
    //{
    //    NN_LOG("Getting IndirectImage\n");
    //    NN_UTIL_SCOPE_EXIT {
    //        NN_LOG("Getting IndirectImage ... done\n");
    //    };

    //    int64_t size = 0;
    //    int64_t stride = 0;
    //    NN_LOG("  Calling UpdateIndirectImage\n");
    //    NN_RESULT_DO(pAppSrv->UpdateIndirectImage(&size, &stride, hConsumerEp, 0, 0, 1, 1));

    //    NN_LOG("  Waiting for buffer ready ...\n");
    //    nn::os::WaitSystemEvent(pIsBufferReadySystemEvent);
    //    NN_LOG("  Received buffer ready\n");
    //    NN_RESULT_SUCCESS;
    //}

}



extern "C" void nninitStartup() NN_NOEXCEPT
{
    InitializeAllocator();
}

TEST(IndirectDisplayStateChangeTest, Dummy)
{
    EnsureServiceInitialized();
}


//TEST(IndirectDisplayStateChangeTest, ConsumerBindUnbind)
//{
//    NN_LOG("ConsumerBindUnbind--------------------------------\n");
//    const int RepeatCount = 10;
//
//    const uint32_t SlotIndex = 0;
//    auto myAruid = nn::applet::GetAppletResourceUserId();
//    EnsureServiceInitialized();
//    nn::vi::detail::SystemServiceProxy viProxy;
//    viProxy.InitializeIndirectDisplay();
//    NN_UTIL_SCOPE_EXIT{ viProxy.Finalize(); };
//    auto pAppSrv = viProxy.GetApplicationDisplayService();
//
//    g_pTestService->CreateIndirectLayer(SlotIndex);
//
//    nn::vi::IndirectConsumerHandleType hConsumerEp = 0;
//    g_pTestService->DestroyIndirectLayerConsumerEndPoint(SlotIndex);
//    NN_ABORT_UNLESS_RESULT_SUCCESS(g_pTestService->CreateIndirectLayerConsumerEndPoint(&hConsumerEp, SlotIndex, myAruid));
//
//    int64_t bufferSize;
//    int64_t bufferAlignment;
//    NN_ABORT_UNLESS_RESULT_SUCCESS(pAppSrv->GetIndirectLayerImageRequiredMemoryInfo(&bufferSize, &bufferAlignment, Width, Height));
//    NN_LOG("buffer size=%lld, align=%lld\n", bufferSize, bufferAlignment);
//
//    void* pBuffer = aligned_alloc(static_cast<size_t>(bufferAlignment), static_cast<size_t>(bufferSize));
//    NN_ABORT_UNLESS_NOT_NULL(pBuffer);
//    NN_UTIL_SCOPE_EXIT { free(pBuffer); };
//
//    for(int trial = 0; trial < RepeatCount; trial++) {
//        NN_LOG("trial %d\n", trial);
//        nn::os::SystemEventType isBufferReadyEvent;
//        InvokeOpenIndirectImage(&isBufferReadyEvent, pAppSrv, hConsumerEp, pBuffer, bufferSize);
//        InvokeCloseIndirectImage(pAppSrv, hConsumerEp);
//        nn::os::DestroySystemEvent(&isBufferReadyEvent);
//    }
//}
//
//TEST(IndirectDisplayStateChangeTest, GetIndirectImage)
//{
//    NN_LOG("GetIndirectImage--------------------------------\n");
//    const int RepeatCount = 100;
//
//    const uint32_t SlotIndex = 0;
//    auto myAruid = nn::applet::GetAppletResourceUserId();
//    EnsureServiceInitialized();
//    nn::vi::detail::SystemServiceProxy viProxy;
//    viProxy.InitializeIndirectDisplay();
//    NN_UTIL_SCOPE_EXIT{ viProxy.Finalize(); };
//    auto pAppSrv = viProxy.GetApplicationDisplayService();
//
//    g_pTestService->CreateIndirectLayer(SlotIndex);
//
//    nn::vi::IndirectConsumerHandleType hConsumerEp = 0;
//    g_pTestService->DestroyIndirectLayerConsumerEndPoint(SlotIndex);
//    NN_ABORT_UNLESS_RESULT_SUCCESS(g_pTestService->CreateIndirectLayerConsumerEndPoint(&hConsumerEp, SlotIndex, myAruid));
//
//    int64_t bufferSize;
//    int64_t bufferAlignment;
//    NN_ABORT_UNLESS_RESULT_SUCCESS(pAppSrv->GetIndirectLayerImageRequiredMemoryInfo(&bufferSize, &bufferAlignment, Width, Height));
//    NN_LOG("buffer size=%lld, align=%lld\n", bufferSize, bufferAlignment);
//
//    void* pBuffer = aligned_alloc(static_cast<size_t>(bufferAlignment), static_cast<size_t>(bufferSize));
//    NN_ABORT_UNLESS_NOT_NULL(pBuffer);
//    NN_UTIL_SCOPE_EXIT { free(pBuffer); };
//
//    for(int trial = 0; trial < RepeatCount; trial++) {
//        NN_LOG("trial %d\n", trial);
//        nn::os::SystemEventType isBufferReadyEvent;
//        InvokeOpenIndirectImage(&isBufferReadyEvent, pAppSrv, hConsumerEp, pBuffer, bufferSize);
//        InvokeGetIndirectImage(pAppSrv, hConsumerEp, &isBufferReadyEvent);
//        InvokeCloseIndirectImage(pAppSrv, hConsumerEp);
//        nn::os::DestroySystemEvent(&isBufferReadyEvent);
//    }
//}
