﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "PanelText.h"
#include "PanelTextPreparationTask.h"

#include "../framework/Framework.h"

PanelText::PanelText()
    : PanelBase(PanelType_Text)
    , m_TextPositionX(0)
    , m_TextPositionY(0)
    , m_TextSize(10)
    , m_TextColor(1, 1, 1, 1)
{
}

void PanelText::SetTextPosition(float x, float y) NN_NOEXCEPT
{
    m_TextPositionX = x;
    m_TextPositionY = y;
}

void PanelText::SetTextSize(float size) NN_NOEXCEPT
{
    m_TextSize = size;
}

void PanelText::SetTextColor(const nn::util::Color4f& color) NN_NOEXCEPT
{
    m_TextColor = color;
}

void PanelText::SetText(const std::string& str) NN_NOEXCEPT
{
    m_Text = str;
}

void PanelText::Update() NN_NOEXCEPT
{
    auto size = GetSize();
    auto pTask = std::make_shared<panel::PanelTextPreparationTask>(
        this->shared_from_this(),
        m_TextPositionX,
        m_TextPositionY,
        size.x,
        size.y,
        m_TextSize,
        m_TextColor,
        m_Text
    );
    Framework::GetPanelPreparationTaskQueue()->Enqueue(pTask);
}

void PanelText::ChangeText(const std::string& string) NN_NOEXCEPT
{
    SetText(string);
    Update();
}

void PanelText::SetTextWriter(const std::shared_ptr<framework::PoolTextWriterHolder>& value) NN_NOEXCEPT
{
    m_TextWriter = value;
}

std::shared_ptr<framework::PoolTextWriterHolder> PanelText::GetTextWriter() NN_NOEXCEPT
{
    return m_TextWriter;
}
