﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "PanelPreparationTaskProcessor.h"

#include "../Config.h"

//#define NN_FRAMEWORK_LOG_PANEL(...) NN_SDK_LOG("[panel]" __VA_ARGS__)

#ifndef NN_FRAMEWORK_LOG_PANEL
#define NN_FRAMEWORK_LOG_PANEL(...)
#endif

namespace panel{

    void PanelPreparationTaskProcessor::Process(
        PanelPreparationTaskQueue* pQueue,
        nn::gfx::CommandBuffer* pCommandBuffer,
        int resourceLockIndex
    ) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pQueue);

        //NN_FRAMEWORK_LOG_PANEL("PreparationTask Start %d\n", pQueue->GetCount());

        for(;;)
        {
            auto pTask = pQueue->Dequeue();
            if(pTask == nullptr)
            {
                break;
            }

            auto r = pTask->Prepare(pCommandBuffer, resourceLockIndex);

            if(r == PanelPreparationResult_Success)
            {
                //NN_FRAMEWORK_LOG_PANEL("  Preparation Success\n");
                continue;
            }
            else if(r == PanelPreparationResult_Canceled)
            {
                NN_FRAMEWORK_LOG_PANEL("  Preparation Canceled\n");
                continue;
            }
            else if(r == PanelPreparationResult_Failure)
            {
                NN_FRAMEWORK_LOG_PANEL("  Preparation Failed\n");
            }
            else if(r == PanelPreparationResult_NeedRetry)
            {
                // TORIAEZU: 順番の入れ替えとか面倒なので中断してしまう
                NN_FRAMEWORK_LOG_PANEL("  Preparation NeedRetry\n");
                pQueue->Cancel(std::move(pTask));
                break;
            }
        }

        if(pQueue->IsEmpty())
        {
            //NN_FRAMEWORK_LOG_PANEL("PreparationTask Complete\n");
        }
        else
        {
            NN_FRAMEWORK_LOG_PANEL("PreparationTask remaining %d\n", pQueue->GetCount());
        }

    }

}
