﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "IPanel.h"
#include "PanelBase.h"

#include "../framework/ImageTransferBuffer.h"
#include "../framework/TexturePool.h"

class PanelImage
    : public PanelBase<IPanel>
    , public std::enable_shared_from_this<PanelImage>
{
public:
    PanelImage() NN_NOEXCEPT;

    // 表示する画像を設定する。
    // テクスチャへの転送後、自動的にクリアされます。
    void SetTransferBuffer(const std::shared_ptr<ImageTransferBuffer>& value) NN_NOEXCEPT;
    // 表示する内容を更新する
    void Update() NN_NOEXCEPT;

    // 内部実装用。
    std::shared_ptr<ImageTransferBuffer> GetTransferBuffer() NN_NOEXCEPT;
    void SetTexture(const std::shared_ptr<framework::PoolTexture>& value) NN_NOEXCEPT;
    std::shared_ptr<framework::PoolTexture> GetTexture() NN_NOEXCEPT;

    PANEL_CAST_FUNCTION(Image);

private:
    std::shared_ptr<ImageTransferBuffer> m_pTransferBuffer;
    std::shared_ptr<framework::PoolTexture> m_pTexture;
};

