﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/nn_Common.h>
#include "IPanel.h"
#include "PanelBase.h"

class PanelContainer
    : public PanelBase<IPanel>
    , public std::enable_shared_from_this<PanelContainer>
{
public:
    PanelContainer() NN_NOEXCEPT;

    // 描画に影響を及ぼさないコンテナとしてパラメータを設定します
    void SetupDummyContainer() NN_NOEXCEPT;

    int GetChildCount() const NN_NOEXCEPT;
    std::shared_ptr<IPanel> GetChild(int index) NN_NOEXCEPT;
    void AddChild(const std::shared_ptr<IPanel>& child) NN_NOEXCEPT;

    void RemoveChild(const std::shared_ptr<IPanel>& child) NN_NOEXCEPT;
    void ClearChildren() NN_NOEXCEPT;

    bool IsCroppingEnabled() const NN_NOEXCEPT;
    void SetCroppingEnabled(bool value) NN_NOEXCEPT;

    PANEL_CAST_FUNCTION(Container);

private:
    std::vector<std::shared_ptr<IPanel>> m_Children;
    bool m_IsCroppingEnabled;
};
