﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <vector>
#include <nn/nn_Common.h>

namespace framework{ namespace detail{

    class CommandResourceLock
    {
    public:
        typedef std::vector<std::shared_ptr<void>> ResourceList;
    public:
        // 指定されたバッファ数で初期化します。
        void Initialize(int bufferCount) NN_NOEXCEPT;

        // 破棄します。すべてのリソースのロックはただちに解除されます。
        void Finalize() NN_NOEXCEPT;

        // 指定したインデックスのリスト上にリソースのロックを作成します。
        void Lock(int index, const std::shared_ptr<void>& p) NN_NOEXCEPT;

        // 指定したインデックスのリスト上のリソースのロックを解放します。
        // ロックの解放は Lock と逆順に行われます。
        void Release(int index) NN_NOEXCEPT;
    private:
        // m_ResourceListList[buffer][i]
        std::vector<ResourceList> m_ResourceListList;
    };

}}
