﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/gfx.h>

class ResShader
{
public:
    void Initialize(const char* shaderFilePath) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    nn::gfx::Shader* GetShader(int variation) NN_NOEXCEPT;

private:
    ptrdiff_t   m_BinaryOffset;
    size_t      m_BinarySize;
    nn::gfx::ResShaderFile*      m_pResShaderFile;
    nn::gfx::ResShaderContainer* m_pResShaderContainer;
    nn::gfx::ShaderCodeType      m_CodeType;
};
