﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

template<typename ValueType>
struct HidButtons
{
    ValueType A;
    ValueType B;
    ValueType X;
    ValueType Y;
    ValueType L;
    ValueType R;
    ValueType Left;
    ValueType Up;
    ValueType Right;
    ValueType Down;
};

struct HidButtonState
{
    // 押されている間 true になります。
    HidButtons<bool> isPressed;
    // 押されはじめのフレームと押されている間一定フレーム間隔で true になります。
    HidButtons<bool> isTriggered;
    // 押されはじめたフレームのみ true になります。
    HidButtons<bool> isDown;
    // 離されたフレームのみ true になります。
    HidButtons<bool> isUp;
};

struct HidButtonHandleParameter
{
    // 長押しによる連打判定を開始するフレーム数
    // 0 以下の場合、連打判定しない。
    int repeatTriggerFrameBeginCount;

    // 長押しによる連打のフレーム間隔。
    // 1 のとき毎フレーム連打になる。
    int repeatTriggerFrameInterval;
};

class Hid
{
public:
    static void Initialize() NN_NOEXCEPT;
    static void Finalize() NN_NOEXCEPT;
    static void SetParameter(const HidButtonHandleParameter& param) NN_NOEXCEPT;
    static void Update() NN_NOEXCEPT;

    static HidButtonState GetButtonState() NN_NOEXCEPT;
};

