﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace framework{

    struct FrameworkMemoryPoolParameter
    {
        // テクスチャ用メモリプールの大きさ(byte)
        size_t texturePoolSize;

        // コマンドバッファ用メモリプールの大きさ(byte)
        size_t commandBufferPoolSize;

        // コンスタントバッファ用メモリプールの大きさ(byte)
        size_t constantBufferPoolSize;

        // シェーダ用メモリプールの大きさ(byte)
        size_t shaderPoolSize;

        // データ用メモリプールの大きさ(byte)
        size_t dataPoolSize;
    };

    struct FrameworkParameter
    {
        // ルートコマンドバッファの本数
        int rootCommandBufferCount;

        // フレームバッファの枚数
        int frameBufferCount;

        // フレームバッファの幅(px)
        int width;

        // フレームバッファの高さ(px)
        int height;

        // ファームウェアメモリの大きさ(byte)
        size_t firmwareMemorySize;

        // ルートコマンドバッファのコマンドメモリの大きさ(byte)
        size_t rootCommandMemorySize;

        // ルートコマンドバッファのコントロールメモリの大きさ(byte)
        size_t rootControlMemorySize;

        FrameworkMemoryPoolParameter memoryPool;

        // テクスチャプールのテクスチャの幅(px)
        int poolTextureWidth;

        // テクスチャプールのテクスチャの高さ(px)
        int poolTextureHeight;

        // テクスチャプールのテクスチャの数
        int poolTextureCount;

        // 1 つのテキストライターて書ける最大文字数
        int poolTextWriterCharCountMax;

        // テキストライタープールのテキストライターの数
        int poolTextWriterCount;
    };

}
