﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testVi_Native.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>


namespace nnt{ namespace vi{

    void WaitSync(const nn::vi::native::NativeSync& sync) NN_NOEXCEPT
    {
        int n = reinterpret_cast<const unsigned&>(sync._data[0]);
        const NvRmFence* pFenceList = reinterpret_cast<const NvRmFence*>(sync._data + 4);
        if(n <= 0)
        {
            return;
        }

        int fd = sync_create_nvrm_mapping(pFenceList, n);
        NN_ABORT_UNLESS_GREATER_EQUAL(fd, 0);
        sync_wait(fd, -1);
        sync_close(fd);
    }

}}
