﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nnt.h>

#include "testVi_Context.h"
#include "testVi_Macro.h"

const int DefaultLoopCount = 100;
const int DefaultSharedBufferSlot = 0;
const int DefaultBufferCount = 6;



NNT_VI_TEST_SERVERSTATE(SLMLAttach_SLMLForceDetach)
{
    const int LoopCount   = DefaultLoopCount;
    const int Slot        = DefaultSharedBufferSlot;
    const int BufferCount = DefaultBufferCount;
    NN_LOG("SL-MLAttach>SL-MLForceDetach-------------------------------\n");
    Context context0({"server"});
    Context context1({"client"});

    nn::vi::fbshare::SharedLayerHandle hSharedLayer = {};
    context0.ConnectService();
    context1.ConnectService();
    auto hSharedBuffer = context0.CreateSharedBuffer(Slot, BufferCount);
    auto displayId = context0.OpenDisplay();
    auto layerId = context0.CreateManagedLayer(displayId);
    NN_ABORT_UNLESS_RESULT_SUCCESS(context0.BindLowLevelLayerToManagedLayer(layerId));
    NN_ABORT_UNLESS_RESULT_SUCCESS(context0.ConnectLowLevelLayerToSharedBuffer(layerId, hSharedBuffer));

    NN_ABORT_UNLESS_RESULT_SUCCESS(context0.CreateSharedLayer(&hSharedLayer, nn::applet::GetAppletResourceUserId()));
    NN_ABORT_UNLESS_RESULT_SUCCESS(context1.OpenSharedLayer(hSharedLayer));

    for(int i = 0; i < LoopCount; i++)
    {
        NN_LOG("LOOP %d/%d\n", i + 1, LoopCount);
        auto indexList = nn::vi::fbshare::SharedLayerTextureIndexList::Get(i % BufferCount, (i + 1) % BufferCount);
        NN_ABORT_UNLESS_RESULT_SUCCESS(context0.AttachSharedLayerToLowLevelLayer(hSharedLayer, layerId, indexList));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context0.ForceDetachSharedLayerFromLowLevelLayer(hSharedLayer));
    }

    context1.DisconnectService();
    context0.DisconnectService();
    context0.CleanSharedBuffer(Slot);
}

NNT_VI_TEST_SERVERSTATE(SLCreate_SLMLAttach_SLDestroy)
{
    const int LoopCount   = DefaultLoopCount;
    const int Slot        = DefaultSharedBufferSlot;
    const int BufferCount = DefaultBufferCount;
    const int AttachBufferCount = 2;
    NN_LOG("SLCreate>SL-MLAttach>SLDestroy-------------------------------\n");
    Context context0({"server"});
    Context context1({"client"});

    nn::vi::fbshare::SharedLayerHandle hSharedLayer = {};
    context0.ConnectService();
    context1.ConnectService();
    auto hSharedBuffer = context0.CreateSharedBuffer(Slot, BufferCount);
    auto displayId = context0.OpenDisplay();
    auto layerId = context0.CreateManagedLayer(displayId);
    NN_ABORT_UNLESS_RESULT_SUCCESS(context0.BindLowLevelLayerToManagedLayer(layerId));
    NN_ABORT_UNLESS_RESULT_SUCCESS(context0.ConnectLowLevelLayerToSharedBuffer(layerId, hSharedBuffer));


    for(int i = 0; i < LoopCount; i++)
    {
        NN_LOG("LOOP %d/%d\n", i + 1, LoopCount);
        auto indexList = nn::vi::fbshare::SharedLayerTextureIndexList::GetInvalidValue();
        for(int j = 0; j < AttachBufferCount; j++)
        {
            indexList[j] = (i + j) % BufferCount;
        }
        NN_ABORT_UNLESS_RESULT_SUCCESS(context0.CreateSharedLayer(&hSharedLayer, nn::applet::GetAppletResourceUserId()));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context0.AttachSharedLayerToLowLevelLayer(hSharedLayer, layerId, indexList));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context0.DestroySharedLayer(hSharedLayer));
    }

    context1.DisconnectService();
    context0.DisconnectService();
    context0.CleanSharedBuffer(Slot);
}
